/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.event;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.Context;
import com.larksuite.oapi.core.event.DefaultHandler;
import java.util.HashMap;
import java.util.Map;

public interface IHandler<E> {
    public E getEvent();

    public void Handle(Context var1, E var2) throws Exception;

    public static class defaultHandler
    implements IHandler<Map<String, Object>> {
        private final DefaultHandler handler;

        public defaultHandler(DefaultHandler handler) {
            this.handler = handler;
        }

        @Override
        public Map<String, Object> getEvent() {
            return new HashMap<String, Object>();
        }

        @Override
        public void Handle(Context context, Map<String, Object> event) throws Exception {
            this.handler.Handle(context, event);
        }
    }

    public static class Hub {
        public static final Map<String, Map<String, IHandler>> appID2EventType2Handler = new HashMap<String, Map<String, IHandler>>();

        public static void setEventTypeHandler(Config config, String eventType, IHandler handler) {
            String appID = config.getAppSettings().getAppID();
            Map eventType2Handler = appID2EventType2Handler.computeIfAbsent(appID, k -> new HashMap());
            eventType2Handler.put(eventType, handler);
        }

        public static void setEventTypeHandler(Config config, String eventType, DefaultHandler handler) {
            Hub.setEventTypeHandler(config, eventType, new defaultHandler(handler));
        }

        public static IHandler GetEventHandler(Config config, String eventType) {
            String appID = config.getAppSettings().getAppID();
            Map<String, IHandler> eventType2Handler = appID2EventType2Handler.get(appID);
            if (eventType2Handler == null) {
                return null;
            }
            return eventType2Handler.get(eventType);
        }
    }
}

