/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.event.handler;

import com.larksuite.oapi.core.Context;
import com.larksuite.oapi.core.event.exception.NotFoundHandlerException;
import com.larksuite.oapi.core.event.handler.ISubHandler;
import com.larksuite.oapi.core.event.handler.subhandler.HandleSubHandler;
import com.larksuite.oapi.core.event.handler.subhandler.UnmarshalSubHandler;
import com.larksuite.oapi.core.event.model.HTTPEvent;
import com.larksuite.oapi.core.model.OapiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler {
    public static final Handler DEFAULT = new Handler();
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    private final ISubHandler[] subHandlers = new ISubHandler[]{new UnmarshalSubHandler(), new HandleSubHandler()};

    public void handle(Context context, HTTPEvent httpEvent) {
        OapiResponse response = httpEvent.getResponse();
        response.setStatusCode(200);
        response.setContentType("application/json");
        try {
            for (ISubHandler subHandler : this.subHandlers) {
                subHandler.handle(context, httpEvent);
            }
            this.complement(httpEvent, response);
        }
        catch (Exception e) {
            if (e instanceof NotFoundHandlerException) {
                log.info("event handle failed, requestId:{} - {}", (Object)context.getRequestID(), (Object)e.getMessage());
                response.setBody(String.format("{\"codemsg\":\"%s\"}", e.getMessage()));
                return;
            }
            log.error("event handle failed, requestId:{} - {}", new Object[]{context.getRequestID(), e.getMessage(), e});
            response.setStatusCode(500);
            response.setBody(String.format("{\"codemsg\":\"%s\"}", e.getMessage()));
        }
    }

    private void complement(HTTPEvent httpEvent, OapiResponse response) {
        if ("url_verification".equals(httpEvent.getType())) {
            response.setBody(String.format("{\"challenge\":\"%s\"}", httpEvent.getChallenge()));
            return;
        }
        response.setBody(String.format("{\"codemsg\":\"%s\"}", "success"));
    }
}

