/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.contact.v3;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.contact.v3.model.CustomAttrEventUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.Department;
import com.larksuite.oapi.service.contact.v3.model.DepartmentCreateResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentCreatedEvent;
import com.larksuite.oapi.service.contact.v3.model.DepartmentDeletedEvent;
import com.larksuite.oapi.service.contact.v3.model.DepartmentGetResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentListResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentParentResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentPatchResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentSearchReqBody;
import com.larksuite.oapi.service.contact.v3.model.DepartmentSearchResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUnbindDepartmentChatReqBody;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUnit;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUnitCreateResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUnitPatchReqBody;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUnitPatchResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUpdateDepartmentIdReqBody;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUpdateResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumActivedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumCreatedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumDeactivatedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumDeletedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumListResult;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.ScopeUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.User;
import com.larksuite.oapi.service.contact.v3.model.UserCreateResult;
import com.larksuite.oapi.service.contact.v3.model.UserCreatedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserDeleteReqBody;
import com.larksuite.oapi.service.contact.v3.model.UserDeletedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserGetResult;
import com.larksuite.oapi.service.contact.v3.model.UserGroup;
import com.larksuite.oapi.service.contact.v3.model.UserGroupCreateResult;
import com.larksuite.oapi.service.contact.v3.model.UserGroupCreatedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserGroupDeletedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserGroupGetResult;
import com.larksuite.oapi.service.contact.v3.model.UserGroupListResult;
import com.larksuite.oapi.service.contact.v3.model.UserGroupMemberChangedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserGroupMemberCreateReqBody;
import com.larksuite.oapi.service.contact.v3.model.UserGroupMemberListResult;
import com.larksuite.oapi.service.contact.v3.model.UserGroupPatchResult;
import com.larksuite.oapi.service.contact.v3.model.UserGroupUpdateUserGroupIdReqBody;
import com.larksuite.oapi.service.contact.v3.model.UserGroupUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserListResult;
import com.larksuite.oapi.service.contact.v3.model.UserPatchResult;
import com.larksuite.oapi.service.contact.v3.model.UserUpdateResult;
import com.larksuite.oapi.service.contact.v3.model.UserUpdateUserIdReqBody;
import com.larksuite.oapi.service.contact.v3.model.UserUpdatedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactService {
    private final Config config;
    private final DepartmentUnits departmentUnits;
    private final Users users;
    private final UserGroups userGroups;
    private final UserGroupMembers userGroupMembers;
    private final Departments departments;
    private final Scopes scopes;
    private final CustomAttrEvents customAttrEvents;
    private final EmployeeTypeEnums employeeTypeEnums;

    public ContactService(Config config) {
        this.config = config;
        this.departmentUnits = new DepartmentUnits(this);
        this.users = new Users(this);
        this.userGroups = new UserGroups(this);
        this.userGroupMembers = new UserGroupMembers(this);
        this.departments = new Departments(this);
        this.scopes = new Scopes(this);
        this.customAttrEvents = new CustomAttrEvents(this);
        this.employeeTypeEnums = new EmployeeTypeEnums(this);
    }

    public DepartmentUnits getDepartmentUnits() {
        return this.departmentUnits;
    }

    public Users getUsers() {
        return this.users;
    }

    public UserGroups getUserGroups() {
        return this.userGroups;
    }

    public UserGroupMembers getUserGroupMembers() {
        return this.userGroupMembers;
    }

    public Departments getDepartments() {
        return this.departments;
    }

    public Scopes getScopes() {
        return this.scopes;
    }

    public CustomAttrEvents getCustomAttrEvents() {
        return this.customAttrEvents;
    }

    public EmployeeTypeEnums getEmployeeTypeEnums() {
        return this.employeeTypeEnums;
    }

    public void setDepartmentCreatedEventHandler(DepartmentCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.department.created_v3", handler);
    }

    public void setDepartmentDeletedEventHandler(DepartmentDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.department.deleted_v3", handler);
    }

    public void setDepartmentUpdatedEventHandler(DepartmentUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.department.updated_v3", handler);
    }

    public void setUserCreatedEventHandler(UserCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user.created_v3", handler);
    }

    public void setUserDeletedEventHandler(UserDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user.deleted_v3", handler);
    }

    public void setUserUpdatedEventHandler(UserUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user.updated_v3", handler);
    }

    public void setUserGroupCreatedEventHandler(UserGroupCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user_group.created_v3", handler);
    }

    public void setUserGroupDeletedEventHandler(UserGroupDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user_group.deleted_v3", handler);
    }

    public void setUserGroupUpdatedEventHandler(UserGroupUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user_group.updated_v3", handler);
    }

    public void setScopeUpdatedEventHandler(ScopeUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.scope.updated_v3", handler);
    }

    public void setUserGroupMemberChangedEventHandler(UserGroupMemberChangedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user_group.member.changed_v3", handler);
    }

    public void setCustomAttrEventUpdatedEventHandler(CustomAttrEventUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.custom_attr_event.updated_v3", handler);
    }

    public void setEmployeeTypeEnumActivedEventHandler(EmployeeTypeEnumActivedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.actived_v3", handler);
    }

    public void setEmployeeTypeEnumCreatedEventHandler(EmployeeTypeEnumCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.created_v3", handler);
    }

    public void setEmployeeTypeEnumDeactivatedEventHandler(EmployeeTypeEnumDeactivatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.deactivated_v3", handler);
    }

    public void setEmployeeTypeEnumDeletedEventHandler(EmployeeTypeEnumDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.deleted_v3", handler);
    }

    public void setEmployeeTypeEnumUpdatedEventHandler(EmployeeTypeEnumUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.updated_v3", handler);
    }

    public static abstract class EmployeeTypeEnumUpdatedEventHandler
    implements IHandler<EmployeeTypeEnumUpdatedEvent> {
        @Override
        public EmployeeTypeEnumUpdatedEvent getEvent() {
            return new EmployeeTypeEnumUpdatedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumDeletedEventHandler
    implements IHandler<EmployeeTypeEnumDeletedEvent> {
        @Override
        public EmployeeTypeEnumDeletedEvent getEvent() {
            return new EmployeeTypeEnumDeletedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumDeactivatedEventHandler
    implements IHandler<EmployeeTypeEnumDeactivatedEvent> {
        @Override
        public EmployeeTypeEnumDeactivatedEvent getEvent() {
            return new EmployeeTypeEnumDeactivatedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumCreatedEventHandler
    implements IHandler<EmployeeTypeEnumCreatedEvent> {
        @Override
        public EmployeeTypeEnumCreatedEvent getEvent() {
            return new EmployeeTypeEnumCreatedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumActivedEventHandler
    implements IHandler<EmployeeTypeEnumActivedEvent> {
        @Override
        public EmployeeTypeEnumActivedEvent getEvent() {
            return new EmployeeTypeEnumActivedEvent();
        }
    }

    public static abstract class CustomAttrEventUpdatedEventHandler
    implements IHandler<CustomAttrEventUpdatedEvent> {
        @Override
        public CustomAttrEventUpdatedEvent getEvent() {
            return new CustomAttrEventUpdatedEvent();
        }
    }

    public static abstract class UserGroupMemberChangedEventHandler
    implements IHandler<UserGroupMemberChangedEvent> {
        @Override
        public UserGroupMemberChangedEvent getEvent() {
            return new UserGroupMemberChangedEvent();
        }
    }

    public static abstract class ScopeUpdatedEventHandler
    implements IHandler<ScopeUpdatedEvent> {
        @Override
        public ScopeUpdatedEvent getEvent() {
            return new ScopeUpdatedEvent();
        }
    }

    public static abstract class UserGroupUpdatedEventHandler
    implements IHandler<UserGroupUpdatedEvent> {
        @Override
        public UserGroupUpdatedEvent getEvent() {
            return new UserGroupUpdatedEvent();
        }
    }

    public static abstract class UserGroupDeletedEventHandler
    implements IHandler<UserGroupDeletedEvent> {
        @Override
        public UserGroupDeletedEvent getEvent() {
            return new UserGroupDeletedEvent();
        }
    }

    public static abstract class UserGroupCreatedEventHandler
    implements IHandler<UserGroupCreatedEvent> {
        @Override
        public UserGroupCreatedEvent getEvent() {
            return new UserGroupCreatedEvent();
        }
    }

    public static abstract class UserUpdatedEventHandler
    implements IHandler<UserUpdatedEvent> {
        @Override
        public UserUpdatedEvent getEvent() {
            return new UserUpdatedEvent();
        }
    }

    public static abstract class UserDeletedEventHandler
    implements IHandler<UserDeletedEvent> {
        @Override
        public UserDeletedEvent getEvent() {
            return new UserDeletedEvent();
        }
    }

    public static abstract class UserCreatedEventHandler
    implements IHandler<UserCreatedEvent> {
        @Override
        public UserCreatedEvent getEvent() {
            return new UserCreatedEvent();
        }
    }

    public static abstract class DepartmentUpdatedEventHandler
    implements IHandler<DepartmentUpdatedEvent> {
        @Override
        public DepartmentUpdatedEvent getEvent() {
            return new DepartmentUpdatedEvent();
        }
    }

    public static abstract class DepartmentDeletedEventHandler
    implements IHandler<DepartmentDeletedEvent> {
        @Override
        public DepartmentDeletedEvent getEvent() {
            return new DepartmentDeletedEvent();
        }
    }

    public static abstract class DepartmentCreatedEventHandler
    implements IHandler<DepartmentCreatedEvent> {
        @Override
        public DepartmentCreatedEvent getEvent() {
            return new DepartmentCreatedEvent();
        }
    }

    public static class EmployeeTypeEnumListReqCall
    extends ReqCaller<Object, EmployeeTypeEnumListResult> {
        private final EmployeeTypeEnums employeeTypeEnums;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmployeeTypeEnumListResult result;

        private EmployeeTypeEnumListReqCall(EmployeeTypeEnums employeeTypeEnums, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmployeeTypeEnumListResult();
            this.employeeTypeEnums = employeeTypeEnums;
        }

        public EmployeeTypeEnumListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public EmployeeTypeEnumListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<EmployeeTypeEnumListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmployeeTypeEnumListResult> request = Request.newRequest("contact/v3/employee_type_enums", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.employeeTypeEnums.service.config, request);
        }
    }

    public static class EmployeeTypeEnums {
        private final ContactService service;

        public EmployeeTypeEnums(ContactService service) {
            this.service = service;
        }

        public EmployeeTypeEnumListReqCall list(RequestOptFn ... optFns) {
            return new EmployeeTypeEnumListReqCall(this, optFns);
        }
    }

    public static class CustomAttrEvents {
        private final ContactService service;

        public CustomAttrEvents(ContactService service) {
            this.service = service;
        }
    }

    public static class Scopes {
        private final ContactService service;

        public Scopes(ContactService service) {
            this.service = service;
        }
    }

    public static class DepartmentSearchReqCall
    extends ReqCaller<DepartmentSearchReqBody, DepartmentSearchResult> {
        private final Departments departments;
        private final DepartmentSearchReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentSearchResult result;

        private DepartmentSearchReqCall(Departments departments, DepartmentSearchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentSearchResult();
            this.departments = departments;
        }

        public DepartmentSearchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentSearchReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentSearchReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public DepartmentSearchReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<DepartmentSearchResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<DepartmentSearchReqBody, DepartmentSearchResult> request = Request.newRequest("contact/v3/departments/search", "POST", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentUnbindDepartmentChatReqCall
    extends ReqCaller<DepartmentUnbindDepartmentChatReqBody, EmptyData> {
        private final Departments departments;
        private final DepartmentUnbindDepartmentChatReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private DepartmentUnbindDepartmentChatReqCall(Departments departments, DepartmentUnbindDepartmentChatReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.departments = departments;
        }

        public DepartmentUnbindDepartmentChatReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<DepartmentUnbindDepartmentChatReqBody, EmptyData> request = Request.newRequest("contact/v3/departments/unbind_department_chat", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentUpdateDepartmentIdReqCall
    extends ReqCaller<DepartmentUpdateDepartmentIdReqBody, EmptyData> {
        private final Departments departments;
        private final DepartmentUpdateDepartmentIdReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private DepartmentUpdateDepartmentIdReqCall(Departments departments, DepartmentUpdateDepartmentIdReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.departments = departments;
        }

        public DepartmentUpdateDepartmentIdReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentUpdateDepartmentIdReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<DepartmentUpdateDepartmentIdReqBody, EmptyData> request = Request.newRequest("contact/v3/departments/:department_id/update_department_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentParentReqCall
    extends ReqCaller<Object, DepartmentParentResult> {
        private final Departments departments;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DepartmentParentResult result;

        private DepartmentParentReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentParentResult();
            this.departments = departments;
        }

        public DepartmentParentReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentParentReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentParentReqCall setDepartmentId(String departmentId) {
            this.queryParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentParentReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public DepartmentParentReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<DepartmentParentResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, DepartmentParentResult> request = Request.newRequest("contact/v3/departments/parent", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentUpdateReqCall
    extends ReqCaller<Department, DepartmentUpdateResult> {
        private final Departments departments;
        private final Department body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentUpdateResult result;

        private DepartmentUpdateReqCall(Departments departments, Department body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentUpdateResult();
            this.departments = departments;
        }

        public DepartmentUpdateReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentUpdateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<DepartmentUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Department, DepartmentUpdateResult> request = Request.newRequest("contact/v3/departments/:department_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Departments departments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private DepartmentDeleteReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.departments = departments;
        }

        public DepartmentDeleteReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentDeleteReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentDeleteReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("contact/v3/departments/:department_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentCreateReqCall
    extends ReqCaller<Department, DepartmentCreateResult> {
        private final Departments departments;
        private final Department body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentCreateResult result;

        private DepartmentCreateReqCall(Departments departments, Department body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentCreateResult();
            this.departments = departments;
        }

        public DepartmentCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentCreateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentCreateReqCall setClientToken(String clientToken) {
            this.queryParams.put("client_token", clientToken);
            return this;
        }

        @Override
        public Response<DepartmentCreateResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Department, DepartmentCreateResult> request = Request.newRequest("contact/v3/departments", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentPatchReqCall
    extends ReqCaller<Department, DepartmentPatchResult> {
        private final Departments departments;
        private final Department body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentPatchResult result;

        private DepartmentPatchReqCall(Departments departments, Department body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentPatchResult();
            this.departments = departments;
        }

        public DepartmentPatchReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentPatchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentPatchReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<DepartmentPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Department, DepartmentPatchResult> request = Request.newRequest("contact/v3/departments/:department_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentListReqCall
    extends ReqCaller<Object, DepartmentListResult> {
        private final Departments departments;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DepartmentListResult result;

        private DepartmentListReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentListResult();
            this.departments = departments;
        }

        public DepartmentListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentListReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentListReqCall setParentDepartmentId(String parentDepartmentId) {
            this.queryParams.put("parent_department_id", parentDepartmentId);
            return this;
        }

        public DepartmentListReqCall setFetchChild(Boolean fetchChild) {
            this.queryParams.put("fetch_child", fetchChild);
            return this;
        }

        public DepartmentListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public DepartmentListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<DepartmentListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, DepartmentListResult> request = Request.newRequest("contact/v3/departments", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentGetReqCall
    extends ReqCaller<Object, DepartmentGetResult> {
        private final Departments departments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DepartmentGetResult result;

        private DepartmentGetReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentGetResult();
            this.departments = departments;
        }

        public DepartmentGetReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentGetReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<DepartmentGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, DepartmentGetResult> request = Request.newRequest("contact/v3/departments/:department_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class Departments {
        private final ContactService service;

        public Departments(ContactService service) {
            this.service = service;
        }

        public DepartmentGetReqCall get(RequestOptFn ... optFns) {
            return new DepartmentGetReqCall(this, optFns);
        }

        public DepartmentListReqCall list(RequestOptFn ... optFns) {
            return new DepartmentListReqCall(this, optFns);
        }

        public DepartmentPatchReqCall patch(Department body, RequestOptFn ... optFns) {
            return new DepartmentPatchReqCall(this, body, optFns);
        }

        public DepartmentCreateReqCall create(Department body, RequestOptFn ... optFns) {
            return new DepartmentCreateReqCall(this, body, optFns);
        }

        public DepartmentDeleteReqCall delete(RequestOptFn ... optFns) {
            return new DepartmentDeleteReqCall(this, optFns);
        }

        public DepartmentUpdateReqCall update(Department body, RequestOptFn ... optFns) {
            return new DepartmentUpdateReqCall(this, body, optFns);
        }

        public DepartmentParentReqCall parent(RequestOptFn ... optFns) {
            return new DepartmentParentReqCall(this, optFns);
        }

        public DepartmentUpdateDepartmentIdReqCall updateDepartmentId(DepartmentUpdateDepartmentIdReqBody body, RequestOptFn ... optFns) {
            return new DepartmentUpdateDepartmentIdReqCall(this, body, optFns);
        }

        public DepartmentUnbindDepartmentChatReqCall unbindDepartmentChat(DepartmentUnbindDepartmentChatReqBody body, RequestOptFn ... optFns) {
            return new DepartmentUnbindDepartmentChatReqCall(this, body, optFns);
        }

        public DepartmentSearchReqCall search(DepartmentSearchReqBody body, RequestOptFn ... optFns) {
            return new DepartmentSearchReqCall(this, body, optFns);
        }
    }

    public static class UserGroupMemberDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final UserGroupMembers userGroupMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private UserGroupMemberDeleteReqCall(UserGroupMembers userGroupMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.userGroupMembers = userGroupMembers;
        }

        public UserGroupMemberDeleteReqCall setUserGroupId(String userGroupId) {
            this.pathParams.put("user_group_id", userGroupId);
            return this;
        }

        public UserGroupMemberDeleteReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserGroupMemberDeleteReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("contact/v3/user_groups/:user_group_id/members/:user_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroupMembers.service.config, request);
        }
    }

    public static class UserGroupMemberListReqCall
    extends ReqCaller<Object, UserGroupMemberListResult> {
        private final UserGroupMembers userGroupMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserGroupMemberListResult result;

        private UserGroupMemberListReqCall(UserGroupMembers userGroupMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGroupMemberListResult();
            this.userGroupMembers = userGroupMembers;
        }

        public UserGroupMemberListReqCall setUserGroupId(String userGroupId) {
            this.pathParams.put("user_group_id", userGroupId);
            return this;
        }

        public UserGroupMemberListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserGroupMemberListReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public UserGroupMemberListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public UserGroupMemberListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<UserGroupMemberListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserGroupMemberListResult> request = Request.newRequest("contact/v3/user_groups/:user_group_id/members", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroupMembers.service.config, request);
        }
    }

    public static class UserGroupMemberCreateReqCall
    extends ReqCaller<UserGroupMemberCreateReqBody, EmptyData> {
        private final UserGroupMembers userGroupMembers;
        private final UserGroupMemberCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private UserGroupMemberCreateReqCall(UserGroupMembers userGroupMembers, UserGroupMemberCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.userGroupMembers = userGroupMembers;
        }

        public UserGroupMemberCreateReqCall setUserGroupId(String userGroupId) {
            this.pathParams.put("user_group_id", userGroupId);
            return this;
        }

        public UserGroupMemberCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<UserGroupMemberCreateReqBody, EmptyData> request = Request.newRequest("contact/v3/user_groups/:user_group_id/members", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroupMembers.service.config, request);
        }
    }

    public static class UserGroupMembers {
        private final ContactService service;

        public UserGroupMembers(ContactService service) {
            this.service = service;
        }

        public UserGroupMemberCreateReqCall create(UserGroupMemberCreateReqBody body, RequestOptFn ... optFns) {
            return new UserGroupMemberCreateReqCall(this, body, optFns);
        }

        public UserGroupMemberListReqCall list(RequestOptFn ... optFns) {
            return new UserGroupMemberListReqCall(this, optFns);
        }

        public UserGroupMemberDeleteReqCall delete(RequestOptFn ... optFns) {
            return new UserGroupMemberDeleteReqCall(this, optFns);
        }
    }

    public static class UserGroupGetReqCall
    extends ReqCaller<Object, UserGroupGetResult> {
        private final UserGroups userGroups;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserGroupGetResult result;

        private UserGroupGetReqCall(UserGroups userGroups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGroupGetResult();
            this.userGroups = userGroups;
        }

        public UserGroupGetReqCall setUserGroupId(String userGroupId) {
            this.pathParams.put("user_group_id", userGroupId);
            return this;
        }

        @Override
        public Response<UserGroupGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, UserGroupGetResult> request = Request.newRequest("contact/v3/user_groups/:user_group_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroups.service.config, request);
        }
    }

    public static class UserGroupListReqCall
    extends ReqCaller<Object, UserGroupListResult> {
        private final UserGroups userGroups;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserGroupListResult result;

        private UserGroupListReqCall(UserGroups userGroups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGroupListResult();
            this.userGroups = userGroups;
        }

        public UserGroupListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public UserGroupListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<UserGroupListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserGroupListResult> request = Request.newRequest("contact/v3/user_groups", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroups.service.config, request);
        }
    }

    public static class UserGroupCreateReqCall
    extends ReqCaller<UserGroup, UserGroupCreateResult> {
        private final UserGroups userGroups;
        private final UserGroup body;
        private final List<RequestOptFn> optFns;
        private UserGroupCreateResult result;

        private UserGroupCreateReqCall(UserGroups userGroups, UserGroup body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGroupCreateResult();
            this.userGroups = userGroups;
        }

        @Override
        public Response<UserGroupCreateResult> execute() throws Exception {
            Request<UserGroup, UserGroupCreateResult> request = Request.newRequest("contact/v3/user_groups", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroups.service.config, request);
        }
    }

    public static class UserGroupPatchReqCall
    extends ReqCaller<UserGroup, UserGroupPatchResult> {
        private final UserGroups userGroups;
        private final UserGroup body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private UserGroupPatchResult result;

        private UserGroupPatchReqCall(UserGroups userGroups, UserGroup body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGroupPatchResult();
            this.userGroups = userGroups;
        }

        public UserGroupPatchReqCall setUserGroupId(String userGroupId) {
            this.pathParams.put("user_group_id", userGroupId);
            return this;
        }

        @Override
        public Response<UserGroupPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<UserGroup, UserGroupPatchResult> request = Request.newRequest("contact/v3/user_groups/:user_group_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroups.service.config, request);
        }
    }

    public static class UserGroupDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final UserGroups userGroups;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private UserGroupDeleteReqCall(UserGroups userGroups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.userGroups = userGroups;
        }

        public UserGroupDeleteReqCall setUserGroupId(String userGroupId) {
            this.pathParams.put("user_group_id", userGroupId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("contact/v3/user_groups/:user_group_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroups.service.config, request);
        }
    }

    public static class UserGroupUpdateUserGroupIdReqCall
    extends ReqCaller<UserGroupUpdateUserGroupIdReqBody, EmptyData> {
        private final UserGroups userGroups;
        private final UserGroupUpdateUserGroupIdReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private UserGroupUpdateUserGroupIdReqCall(UserGroups userGroups, UserGroupUpdateUserGroupIdReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.userGroups = userGroups;
        }

        public UserGroupUpdateUserGroupIdReqCall setUserGroupId(String userGroupId) {
            this.pathParams.put("user_group_id", userGroupId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<UserGroupUpdateUserGroupIdReqBody, EmptyData> request = Request.newRequest("contact/v3/user_groups/:user_group_id/update_user_group_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userGroups.service.config, request);
        }
    }

    public static class UserGroups {
        private final ContactService service;

        public UserGroups(ContactService service) {
            this.service = service;
        }

        public UserGroupUpdateUserGroupIdReqCall updateUserGroupId(UserGroupUpdateUserGroupIdReqBody body, RequestOptFn ... optFns) {
            return new UserGroupUpdateUserGroupIdReqCall(this, body, optFns);
        }

        public UserGroupDeleteReqCall delete(RequestOptFn ... optFns) {
            return new UserGroupDeleteReqCall(this, optFns);
        }

        public UserGroupPatchReqCall patch(UserGroup body, RequestOptFn ... optFns) {
            return new UserGroupPatchReqCall(this, body, optFns);
        }

        public UserGroupCreateReqCall create(UserGroup body, RequestOptFn ... optFns) {
            return new UserGroupCreateReqCall(this, body, optFns);
        }

        public UserGroupListReqCall list(RequestOptFn ... optFns) {
            return new UserGroupListReqCall(this, optFns);
        }

        public UserGroupGetReqCall get(RequestOptFn ... optFns) {
            return new UserGroupGetReqCall(this, optFns);
        }
    }

    public static class UserListReqCall
    extends ReqCaller<Object, UserListResult> {
        private final Users users;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserListResult result;

        private UserListReqCall(Users users, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserListResult();
            this.users = users;
        }

        public UserListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserListReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public UserListReqCall setDepartmentId(String departmentId) {
            this.queryParams.put("department_id", departmentId);
            return this;
        }

        public UserListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public UserListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<UserListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserListResult> request = Request.newRequest("contact/v3/users", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserGetReqCall
    extends ReqCaller<Object, UserGetResult> {
        private final Users users;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserGetResult result;

        private UserGetReqCall(Users users, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGetResult();
            this.users = users;
        }

        public UserGetReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserGetReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<UserGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserGetResult> request = Request.newRequest("contact/v3/users/:user_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserUpdateUserIdReqCall
    extends ReqCaller<UserUpdateUserIdReqBody, EmptyData> {
        private final Users users;
        private final UserUpdateUserIdReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private UserUpdateUserIdReqCall(Users users, UserUpdateUserIdReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.users = users;
        }

        public UserUpdateUserIdReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserUpdateUserIdReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<UserUpdateUserIdReqBody, EmptyData> request = Request.newRequest("contact/v3/users/:user_id/update_user_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserPatchReqCall
    extends ReqCaller<User, UserPatchResult> {
        private final Users users;
        private final User body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private UserPatchResult result;

        private UserPatchReqCall(Users users, User body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserPatchResult();
            this.users = users;
        }

        public UserPatchReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserPatchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserPatchReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<UserPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<User, UserPatchResult> request = Request.newRequest("contact/v3/users/:user_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserCreateReqCall
    extends ReqCaller<User, UserCreateResult> {
        private final Users users;
        private final User body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private UserCreateResult result;

        private UserCreateReqCall(Users users, User body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserCreateResult();
            this.users = users;
        }

        public UserCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserCreateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public UserCreateReqCall setClientToken(String clientToken) {
            this.queryParams.put("client_token", clientToken);
            return this;
        }

        @Override
        public Response<UserCreateResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<User, UserCreateResult> request = Request.newRequest("contact/v3/users", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserUpdateReqCall
    extends ReqCaller<User, UserUpdateResult> {
        private final Users users;
        private final User body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private UserUpdateResult result;

        private UserUpdateReqCall(Users users, User body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserUpdateResult();
            this.users = users;
        }

        public UserUpdateReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserUpdateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<UserUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<User, UserUpdateResult> request = Request.newRequest("contact/v3/users/:user_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserDeleteReqCall
    extends ReqCaller<UserDeleteReqBody, EmptyData> {
        private final Users users;
        private final UserDeleteReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private UserDeleteReqCall(Users users, UserDeleteReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.users = users;
        }

        public UserDeleteReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserDeleteReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<UserDeleteReqBody, EmptyData> request = Request.newRequest("contact/v3/users/:user_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class Users {
        private final ContactService service;

        public Users(ContactService service) {
            this.service = service;
        }

        public UserDeleteReqCall delete(UserDeleteReqBody body, RequestOptFn ... optFns) {
            return new UserDeleteReqCall(this, body, optFns);
        }

        public UserUpdateReqCall update(User body, RequestOptFn ... optFns) {
            return new UserUpdateReqCall(this, body, optFns);
        }

        public UserCreateReqCall create(User body, RequestOptFn ... optFns) {
            return new UserCreateReqCall(this, body, optFns);
        }

        public UserPatchReqCall patch(User body, RequestOptFn ... optFns) {
            return new UserPatchReqCall(this, body, optFns);
        }

        public UserUpdateUserIdReqCall updateUserId(UserUpdateUserIdReqBody body, RequestOptFn ... optFns) {
            return new UserUpdateUserIdReqCall(this, body, optFns);
        }

        public UserGetReqCall get(RequestOptFn ... optFns) {
            return new UserGetReqCall(this, optFns);
        }

        public UserListReqCall list(RequestOptFn ... optFns) {
            return new UserListReqCall(this, optFns);
        }
    }

    public static class DepartmentUnitCreateReqCall
    extends ReqCaller<DepartmentUnit, DepartmentUnitCreateResult> {
        private final DepartmentUnits departmentUnits;
        private final DepartmentUnit body;
        private final List<RequestOptFn> optFns;
        private DepartmentUnitCreateResult result;

        private DepartmentUnitCreateReqCall(DepartmentUnits departmentUnits, DepartmentUnit body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentUnitCreateResult();
            this.departmentUnits = departmentUnits;
        }

        @Override
        public Response<DepartmentUnitCreateResult> execute() throws Exception {
            Request<DepartmentUnit, DepartmentUnitCreateResult> request = Request.newRequest("contact/v3/department_units", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departmentUnits.service.config, request);
        }
    }

    public static class DepartmentUnitPatchReqCall
    extends ReqCaller<DepartmentUnitPatchReqBody, DepartmentUnitPatchResult> {
        private final DepartmentUnits departmentUnits;
        private final DepartmentUnitPatchReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private DepartmentUnitPatchResult result;

        private DepartmentUnitPatchReqCall(DepartmentUnits departmentUnits, DepartmentUnitPatchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentUnitPatchResult();
            this.departmentUnits = departmentUnits;
        }

        public DepartmentUnitPatchReqCall setUnitId(String unitId) {
            this.pathParams.put("unit_id", unitId);
            return this;
        }

        @Override
        public Response<DepartmentUnitPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<DepartmentUnitPatchReqBody, DepartmentUnitPatchResult> request = Request.newRequest("contact/v3/department_units/:unit_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departmentUnits.service.config, request);
        }
    }

    public static class DepartmentUnitDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final DepartmentUnits departmentUnits;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private DepartmentUnitDeleteReqCall(DepartmentUnits departmentUnits, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.departmentUnits = departmentUnits;
        }

        public DepartmentUnitDeleteReqCall setUnitId(String unitId) {
            this.pathParams.put("unit_id", unitId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("contact/v3/department_units/:unit_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departmentUnits.service.config, request);
        }
    }

    public static class DepartmentUnits {
        private final ContactService service;

        public DepartmentUnits(ContactService service) {
            this.service = service;
        }

        public DepartmentUnitDeleteReqCall delete(RequestOptFn ... optFns) {
            return new DepartmentUnitDeleteReqCall(this, optFns);
        }

        public DepartmentUnitPatchReqCall patch(DepartmentUnitPatchReqBody body, RequestOptFn ... optFns) {
            return new DepartmentUnitPatchReqCall(this, body, optFns);
        }

        public DepartmentUnitCreateReqCall create(DepartmentUnit body, RequestOptFn ... optFns) {
            return new DepartmentUnitCreateReqCall(this, body, optFns);
        }
    }
}

