/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.im.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.FormData;
import com.larksuite.oapi.core.api.request.FormDataFile;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.im.v1.model.AnnouncementGetResult;
import com.larksuite.oapi.service.im.v1.model.AnnouncementPatchReqBody;
import com.larksuite.oapi.service.im.v1.model.ChatAnnouncementGetResult;
import com.larksuite.oapi.service.im.v1.model.ChatAnnouncementPatchReqBody;
import com.larksuite.oapi.service.im.v1.model.ChatCreateReqBody;
import com.larksuite.oapi.service.im.v1.model.ChatCreateResult;
import com.larksuite.oapi.service.im.v1.model.ChatDisbandedEvent;
import com.larksuite.oapi.service.im.v1.model.ChatGetResult;
import com.larksuite.oapi.service.im.v1.model.ChatListResult;
import com.larksuite.oapi.service.im.v1.model.ChatMemberBotAddedEvent;
import com.larksuite.oapi.service.im.v1.model.ChatMemberBotDeletedEvent;
import com.larksuite.oapi.service.im.v1.model.ChatMemberUserAddedEvent;
import com.larksuite.oapi.service.im.v1.model.ChatMemberUserDeletedEvent;
import com.larksuite.oapi.service.im.v1.model.ChatMemberUserWithdrawnEvent;
import com.larksuite.oapi.service.im.v1.model.ChatMembersCreateReqBody;
import com.larksuite.oapi.service.im.v1.model.ChatMembersCreateResult;
import com.larksuite.oapi.service.im.v1.model.ChatMembersDeleteReqBody;
import com.larksuite.oapi.service.im.v1.model.ChatMembersDeleteResult;
import com.larksuite.oapi.service.im.v1.model.ChatMembersGetResult;
import com.larksuite.oapi.service.im.v1.model.ChatMembersIsInChatResult;
import com.larksuite.oapi.service.im.v1.model.ChatModerationGetResult;
import com.larksuite.oapi.service.im.v1.model.ChatModerationUpdateReqBody;
import com.larksuite.oapi.service.im.v1.model.ChatSearchResult;
import com.larksuite.oapi.service.im.v1.model.ChatUpdateReqBody;
import com.larksuite.oapi.service.im.v1.model.ChatUpdatedEvent;
import com.larksuite.oapi.service.im.v1.model.FileCreateResult;
import com.larksuite.oapi.service.im.v1.model.ImageCreateResult;
import com.larksuite.oapi.service.im.v1.model.MembersCreateReqBody;
import com.larksuite.oapi.service.im.v1.model.MembersCreateResult;
import com.larksuite.oapi.service.im.v1.model.MembersDeleteReqBody;
import com.larksuite.oapi.service.im.v1.model.MembersDeleteResult;
import com.larksuite.oapi.service.im.v1.model.MembersGetResult;
import com.larksuite.oapi.service.im.v1.model.MembersIsInChatResult;
import com.larksuite.oapi.service.im.v1.model.Message;
import com.larksuite.oapi.service.im.v1.model.MessageAtMessageReadEvent;
import com.larksuite.oapi.service.im.v1.model.MessageCreateReqBody;
import com.larksuite.oapi.service.im.v1.model.MessageGetResult;
import com.larksuite.oapi.service.im.v1.model.MessageListResult;
import com.larksuite.oapi.service.im.v1.model.MessageMessageReadEvent;
import com.larksuite.oapi.service.im.v1.model.MessagePatchReqBody;
import com.larksuite.oapi.service.im.v1.model.MessageReadUsersResult;
import com.larksuite.oapi.service.im.v1.model.MessageReceiveEvent;
import com.larksuite.oapi.service.im.v1.model.MessageReplyReqBody;
import com.larksuite.oapi.service.im.v1.model.MessageUrgentAppResult;
import com.larksuite.oapi.service.im.v1.model.MessageUrgentMessageReadEvent;
import com.larksuite.oapi.service.im.v1.model.MessageUrgentPhoneResult;
import com.larksuite.oapi.service.im.v1.model.MessageUrgentReadUsersResult;
import com.larksuite.oapi.service.im.v1.model.MessageUrgentSmsResult;
import com.larksuite.oapi.service.im.v1.model.UrgentReceivers;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImService {
    private final Config config;
    private final Messages messages;
    private final Resources resources;
    private final Announcements announcements;
    private final Chats chats;
    private final Images images;
    private final Files files;
    private final ChatMemberUsers chatMemberUsers;
    private final ChatMemberBots chatMemberBots;
    private final Memberss memberss;
    private final ChatAnnouncements chatAnnouncements;
    private final ChatMemberss chatMemberss;
    private final ChatModerations chatModerations;
    private final MessageResources messageResources;

    public ImService(Config config) {
        this.config = config;
        this.messages = new Messages(this);
        this.resources = new Resources(this);
        this.announcements = new Announcements(this);
        this.chats = new Chats(this);
        this.images = new Images(this);
        this.files = new Files(this);
        this.chatMemberUsers = new ChatMemberUsers(this);
        this.chatMemberBots = new ChatMemberBots(this);
        this.memberss = new Memberss(this);
        this.chatAnnouncements = new ChatAnnouncements(this);
        this.chatMemberss = new ChatMemberss(this);
        this.chatModerations = new ChatModerations(this);
        this.messageResources = new MessageResources(this);
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Announcements getAnnouncements() {
        return this.announcements;
    }

    public Chats getChats() {
        return this.chats;
    }

    public Images getImages() {
        return this.images;
    }

    public Files getFiles() {
        return this.files;
    }

    public ChatMemberUsers getChatMemberUsers() {
        return this.chatMemberUsers;
    }

    public ChatMemberBots getChatMemberBots() {
        return this.chatMemberBots;
    }

    public Memberss getMemberss() {
        return this.memberss;
    }

    public ChatAnnouncements getChatAnnouncements() {
        return this.chatAnnouncements;
    }

    public ChatMemberss getChatMemberss() {
        return this.chatMemberss;
    }

    public ChatModerations getChatModerations() {
        return this.chatModerations;
    }

    public MessageResources getMessageResources() {
        return this.messageResources;
    }

    public void setMessageReceiveEventHandler(MessageReceiveEventHandler handler) {
        Event.setTypeHandler(this.config, "im.message.receive_v1", handler);
    }

    public void setChatUpdatedEventHandler(ChatUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "im.chat.updated_v1", handler);
    }

    public void setChatDisbandedEventHandler(ChatDisbandedEventHandler handler) {
        Event.setTypeHandler(this.config, "im.chat.disbanded_v1", handler);
    }

    public void setChatMemberBotAddedEventHandler(ChatMemberBotAddedEventHandler handler) {
        Event.setTypeHandler(this.config, "im.chat.member.bot.added_v1", handler);
    }

    public void setChatMemberUserAddedEventHandler(ChatMemberUserAddedEventHandler handler) {
        Event.setTypeHandler(this.config, "im.chat.member.user.added_v1", handler);
    }

    public void setChatMemberBotDeletedEventHandler(ChatMemberBotDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "im.chat.member.bot.deleted_v1", handler);
    }

    public void setChatMemberUserWithdrawnEventHandler(ChatMemberUserWithdrawnEventHandler handler) {
        Event.setTypeHandler(this.config, "im.chat.member.user.withdrawn_v1", handler);
    }

    public void setChatMemberUserDeletedEventHandler(ChatMemberUserDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "im.chat.member.user.deleted_v1", handler);
    }

    public void setMessageAtMessageReadEventHandler(MessageAtMessageReadEventHandler handler) {
        Event.setTypeHandler(this.config, "im.message.at_message_read_v1", handler);
    }

    public void setMessageMessageReadEventHandler(MessageMessageReadEventHandler handler) {
        Event.setTypeHandler(this.config, "im.message.message_read_v1", handler);
    }

    public void setMessageUrgentMessageReadEventHandler(MessageUrgentMessageReadEventHandler handler) {
        Event.setTypeHandler(this.config, "im.message.urgent_message_read_v1", handler);
    }

    public static abstract class MessageUrgentMessageReadEventHandler
    implements IHandler<MessageUrgentMessageReadEvent> {
        @Override
        public MessageUrgentMessageReadEvent getEvent() {
            return new MessageUrgentMessageReadEvent();
        }
    }

    public static abstract class MessageMessageReadEventHandler
    implements IHandler<MessageMessageReadEvent> {
        @Override
        public MessageMessageReadEvent getEvent() {
            return new MessageMessageReadEvent();
        }
    }

    public static abstract class MessageAtMessageReadEventHandler
    implements IHandler<MessageAtMessageReadEvent> {
        @Override
        public MessageAtMessageReadEvent getEvent() {
            return new MessageAtMessageReadEvent();
        }
    }

    public static abstract class ChatMemberUserDeletedEventHandler
    implements IHandler<ChatMemberUserDeletedEvent> {
        @Override
        public ChatMemberUserDeletedEvent getEvent() {
            return new ChatMemberUserDeletedEvent();
        }
    }

    public static abstract class ChatMemberUserWithdrawnEventHandler
    implements IHandler<ChatMemberUserWithdrawnEvent> {
        @Override
        public ChatMemberUserWithdrawnEvent getEvent() {
            return new ChatMemberUserWithdrawnEvent();
        }
    }

    public static abstract class ChatMemberBotDeletedEventHandler
    implements IHandler<ChatMemberBotDeletedEvent> {
        @Override
        public ChatMemberBotDeletedEvent getEvent() {
            return new ChatMemberBotDeletedEvent();
        }
    }

    public static abstract class ChatMemberUserAddedEventHandler
    implements IHandler<ChatMemberUserAddedEvent> {
        @Override
        public ChatMemberUserAddedEvent getEvent() {
            return new ChatMemberUserAddedEvent();
        }
    }

    public static abstract class ChatMemberBotAddedEventHandler
    implements IHandler<ChatMemberBotAddedEvent> {
        @Override
        public ChatMemberBotAddedEvent getEvent() {
            return new ChatMemberBotAddedEvent();
        }
    }

    public static abstract class ChatDisbandedEventHandler
    implements IHandler<ChatDisbandedEvent> {
        @Override
        public ChatDisbandedEvent getEvent() {
            return new ChatDisbandedEvent();
        }
    }

    public static abstract class ChatUpdatedEventHandler
    implements IHandler<ChatUpdatedEvent> {
        @Override
        public ChatUpdatedEvent getEvent() {
            return new ChatUpdatedEvent();
        }
    }

    public static abstract class MessageReceiveEventHandler
    implements IHandler<MessageReceiveEvent> {
        @Override
        public MessageReceiveEvent getEvent() {
            return new MessageReceiveEvent();
        }
    }

    public static class MessageResourceGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final MessageResources messageResources;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private MessageResourceGetReqCall(MessageResources messageResources, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.messageResources = messageResources;
        }

        public MessageResourceGetReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        public MessageResourceGetReqCall setFileKey(String fileKey) {
            this.pathParams.put("file_key", fileKey);
            return this;
        }

        public MessageResourceGetReqCall setType(String type) {
            this.queryParams.put("type", type);
            return this;
        }

        public MessageResourceGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("im/v1/messages/:message_id/resources/:file_key", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messageResources.service.config, request);
        }
    }

    public static class MessageResources {
        private final ImService service;

        public MessageResources(ImService service) {
            this.service = service;
        }

        public MessageResourceGetReqCall get(RequestOptFn ... optFns) {
            return new MessageResourceGetReqCall(this, optFns);
        }
    }

    public static class ChatModerationUpdateReqCall
    extends ReqCaller<ChatModerationUpdateReqBody, EmptyData> {
        private final ChatModerations chatModerations;
        private final ChatModerationUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private ChatModerationUpdateReqCall(ChatModerations chatModerations, ChatModerationUpdateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.chatModerations = chatModerations;
        }

        public ChatModerationUpdateReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatModerationUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ChatModerationUpdateReqBody, EmptyData> request = Request.newRequest("im/v1/chats/:chat_id/moderation", "PUT", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatModerations.service.config, request);
        }
    }

    public static class ChatModerationGetReqCall
    extends ReqCaller<Object, ChatModerationGetResult> {
        private final ChatModerations chatModerations;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ChatModerationGetResult result;

        private ChatModerationGetReqCall(ChatModerations chatModerations, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatModerationGetResult();
            this.chatModerations = chatModerations;
        }

        public ChatModerationGetReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatModerationGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public ChatModerationGetReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public ChatModerationGetReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<ChatModerationGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ChatModerationGetResult> request = Request.newRequest("im/v1/chats/:chat_id/moderation", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatModerations.service.config, request);
        }
    }

    public static class ChatModerations {
        private final ImService service;

        public ChatModerations(ImService service) {
            this.service = service;
        }

        public ChatModerationGetReqCall get(RequestOptFn ... optFns) {
            return new ChatModerationGetReqCall(this, optFns);
        }

        public ChatModerationUpdateReqCall update(ChatModerationUpdateReqBody body, RequestOptFn ... optFns) {
            return new ChatModerationUpdateReqCall(this, body, optFns);
        }
    }

    public static class ChatMembersMeJoinReqCall
    extends ReqCaller<Object, EmptyData> {
        private final ChatMemberss chatMemberss;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private ChatMembersMeJoinReqCall(ChatMemberss chatMemberss, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.chatMemberss = chatMemberss;
        }

        public ChatMembersMeJoinReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("im/v1/chats/:chat_id/members/me_join", "PATCH", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatMemberss.service.config, request);
        }
    }

    public static class ChatMembersIsInChatReqCall
    extends ReqCaller<Object, ChatMembersIsInChatResult> {
        private final ChatMemberss chatMemberss;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ChatMembersIsInChatResult result;

        private ChatMembersIsInChatReqCall(ChatMemberss chatMemberss, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatMembersIsInChatResult();
            this.chatMemberss = chatMemberss;
        }

        public ChatMembersIsInChatReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        @Override
        public Response<ChatMembersIsInChatResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, ChatMembersIsInChatResult> request = Request.newRequest("im/v1/chats/:chat_id/members/is_in_chat", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatMemberss.service.config, request);
        }
    }

    public static class ChatMembersGetReqCall
    extends ReqCaller<Object, ChatMembersGetResult> {
        private final ChatMemberss chatMemberss;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ChatMembersGetResult result;

        private ChatMembersGetReqCall(ChatMemberss chatMemberss, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatMembersGetResult();
            this.chatMemberss = chatMemberss;
        }

        public ChatMembersGetReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatMembersGetReqCall setMemberIdType(String memberIdType) {
            this.queryParams.put("member_id_type", memberIdType);
            return this;
        }

        public ChatMembersGetReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public ChatMembersGetReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<ChatMembersGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ChatMembersGetResult> request = Request.newRequest("im/v1/chats/:chat_id/members", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatMemberss.service.config, request);
        }
    }

    public static class ChatMembersDeleteReqCall
    extends ReqCaller<ChatMembersDeleteReqBody, ChatMembersDeleteResult> {
        private final ChatMemberss chatMemberss;
        private final ChatMembersDeleteReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ChatMembersDeleteResult result;

        private ChatMembersDeleteReqCall(ChatMemberss chatMemberss, ChatMembersDeleteReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatMembersDeleteResult();
            this.chatMemberss = chatMemberss;
        }

        public ChatMembersDeleteReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatMembersDeleteReqCall setMemberIdType(String memberIdType) {
            this.queryParams.put("member_id_type", memberIdType);
            return this;
        }

        @Override
        public Response<ChatMembersDeleteResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ChatMembersDeleteReqBody, ChatMembersDeleteResult> request = Request.newRequest("im/v1/chats/:chat_id/members", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatMemberss.service.config, request);
        }
    }

    public static class ChatMembersCreateReqCall
    extends ReqCaller<ChatMembersCreateReqBody, ChatMembersCreateResult> {
        private final ChatMemberss chatMemberss;
        private final ChatMembersCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ChatMembersCreateResult result;

        private ChatMembersCreateReqCall(ChatMemberss chatMemberss, ChatMembersCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatMembersCreateResult();
            this.chatMemberss = chatMemberss;
        }

        public ChatMembersCreateReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatMembersCreateReqCall setMemberIdType(String memberIdType) {
            this.queryParams.put("member_id_type", memberIdType);
            return this;
        }

        @Override
        public Response<ChatMembersCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ChatMembersCreateReqBody, ChatMembersCreateResult> request = Request.newRequest("im/v1/chats/:chat_id/members", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatMemberss.service.config, request);
        }
    }

    public static class ChatMemberss {
        private final ImService service;

        public ChatMemberss(ImService service) {
            this.service = service;
        }

        public ChatMembersCreateReqCall create(ChatMembersCreateReqBody body, RequestOptFn ... optFns) {
            return new ChatMembersCreateReqCall(this, body, optFns);
        }

        public ChatMembersDeleteReqCall delete(ChatMembersDeleteReqBody body, RequestOptFn ... optFns) {
            return new ChatMembersDeleteReqCall(this, body, optFns);
        }

        public ChatMembersGetReqCall get(RequestOptFn ... optFns) {
            return new ChatMembersGetReqCall(this, optFns);
        }

        public ChatMembersIsInChatReqCall isInChat(RequestOptFn ... optFns) {
            return new ChatMembersIsInChatReqCall(this, optFns);
        }

        public ChatMembersMeJoinReqCall meJoin(RequestOptFn ... optFns) {
            return new ChatMembersMeJoinReqCall(this, optFns);
        }
    }

    public static class ChatAnnouncementPatchReqCall
    extends ReqCaller<ChatAnnouncementPatchReqBody, EmptyData> {
        private final ChatAnnouncements chatAnnouncements;
        private final ChatAnnouncementPatchReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private ChatAnnouncementPatchReqCall(ChatAnnouncements chatAnnouncements, ChatAnnouncementPatchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.chatAnnouncements = chatAnnouncements;
        }

        public ChatAnnouncementPatchReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<ChatAnnouncementPatchReqBody, EmptyData> request = Request.newRequest("im/v1/chats/:chat_id/announcement", "PATCH", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatAnnouncements.service.config, request);
        }
    }

    public static class ChatAnnouncementGetReqCall
    extends ReqCaller<Object, ChatAnnouncementGetResult> {
        private final ChatAnnouncements chatAnnouncements;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ChatAnnouncementGetResult result;

        private ChatAnnouncementGetReqCall(ChatAnnouncements chatAnnouncements, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatAnnouncementGetResult();
            this.chatAnnouncements = chatAnnouncements;
        }

        public ChatAnnouncementGetReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatAnnouncementGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<ChatAnnouncementGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ChatAnnouncementGetResult> request = Request.newRequest("im/v1/chats/:chat_id/announcement", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chatAnnouncements.service.config, request);
        }
    }

    public static class ChatAnnouncements {
        private final ImService service;

        public ChatAnnouncements(ImService service) {
            this.service = service;
        }

        public ChatAnnouncementGetReqCall get(RequestOptFn ... optFns) {
            return new ChatAnnouncementGetReqCall(this, optFns);
        }

        public ChatAnnouncementPatchReqCall patch(ChatAnnouncementPatchReqBody body, RequestOptFn ... optFns) {
            return new ChatAnnouncementPatchReqCall(this, body, optFns);
        }
    }

    public static class MembersIsInChatReqCall
    extends ReqCaller<Object, MembersIsInChatResult> {
        private final Memberss memberss;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MembersIsInChatResult result;

        private MembersIsInChatReqCall(Memberss memberss, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MembersIsInChatResult();
            this.memberss = memberss;
        }

        public MembersIsInChatReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        @Override
        public Response<MembersIsInChatResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, MembersIsInChatResult> request = Request.newRequest("im/v1/chats/:chat_id/members/is_in_chat", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.memberss.service.config, request);
        }
    }

    public static class MembersDeleteReqCall
    extends ReqCaller<MembersDeleteReqBody, MembersDeleteResult> {
        private final Memberss memberss;
        private final MembersDeleteReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MembersDeleteResult result;

        private MembersDeleteReqCall(Memberss memberss, MembersDeleteReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MembersDeleteResult();
            this.memberss = memberss;
        }

        public MembersDeleteReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public MembersDeleteReqCall setMemberIdType(String memberIdType) {
            this.queryParams.put("member_id_type", memberIdType);
            return this;
        }

        @Override
        public Response<MembersDeleteResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MembersDeleteReqBody, MembersDeleteResult> request = Request.newRequest("im/v1/chats/:chat_id/members", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.memberss.service.config, request);
        }
    }

    public static class MembersMeJoinReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Memberss memberss;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MembersMeJoinReqCall(Memberss memberss, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.memberss = memberss;
        }

        public MembersMeJoinReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("im/v1/chats/:chat_id/members/me_join", "PATCH", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.memberss.service.config, request);
        }
    }

    public static class MembersCreateReqCall
    extends ReqCaller<MembersCreateReqBody, MembersCreateResult> {
        private final Memberss memberss;
        private final MembersCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MembersCreateResult result;

        private MembersCreateReqCall(Memberss memberss, MembersCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MembersCreateResult();
            this.memberss = memberss;
        }

        public MembersCreateReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public MembersCreateReqCall setMemberIdType(String memberIdType) {
            this.queryParams.put("member_id_type", memberIdType);
            return this;
        }

        @Override
        public Response<MembersCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MembersCreateReqBody, MembersCreateResult> request = Request.newRequest("im/v1/chats/:chat_id/members", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.memberss.service.config, request);
        }
    }

    public static class MembersGetReqCall
    extends ReqCaller<Object, MembersGetResult> {
        private final Memberss memberss;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MembersGetResult result;

        private MembersGetReqCall(Memberss memberss, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MembersGetResult();
            this.memberss = memberss;
        }

        public MembersGetReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public MembersGetReqCall setMemberIdType(String memberIdType) {
            this.queryParams.put("member_id_type", memberIdType);
            return this;
        }

        public MembersGetReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public MembersGetReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<MembersGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MembersGetResult> request = Request.newRequest("im/v1/chats/:chat_id/members", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.memberss.service.config, request);
        }
    }

    public static class Memberss {
        private final ImService service;

        public Memberss(ImService service) {
            this.service = service;
        }

        public MembersGetReqCall get(RequestOptFn ... optFns) {
            return new MembersGetReqCall(this, optFns);
        }

        public MembersCreateReqCall create(MembersCreateReqBody body, RequestOptFn ... optFns) {
            return new MembersCreateReqCall(this, body, optFns);
        }

        public MembersMeJoinReqCall meJoin(RequestOptFn ... optFns) {
            return new MembersMeJoinReqCall(this, optFns);
        }

        public MembersDeleteReqCall delete(MembersDeleteReqBody body, RequestOptFn ... optFns) {
            return new MembersDeleteReqCall(this, body, optFns);
        }

        public MembersIsInChatReqCall isInChat(RequestOptFn ... optFns) {
            return new MembersIsInChatReqCall(this, optFns);
        }
    }

    public static class ChatMemberBots {
        private final ImService service;

        public ChatMemberBots(ImService service) {
            this.service = service;
        }
    }

    public static class ChatMemberUsers {
        private final ImService service;

        public ChatMemberUsers(ImService service) {
            this.service = service;
        }
    }

    public static class FileGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final Files files;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private FileGetReqCall(Files files, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.files = files;
        }

        public FileGetReqCall setFileKey(String fileKey) {
            this.pathParams.put("file_key", fileKey);
            return this;
        }

        public FileGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("im/v1/files/:file_key", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class FileCreateReqCall
    extends ReqCaller<FormData, FileCreateResult> {
        private final Files files;
        private final FormData body = new FormData();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private FileCreateResult result;

        private FileCreateReqCall(Files files, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileCreateResult();
            this.files = files;
        }

        public FileCreateReqCall setFileType(String fileType) {
            this.body.addField("file_type", fileType);
            return this;
        }

        public FileCreateReqCall setFileName(String fileName) {
            this.body.addField("file_name", fileName);
            return this;
        }

        public FileCreateReqCall setDuration(Integer duration) {
            this.body.addField("duration", duration);
            return this;
        }

        public FileCreateReqCall setFile(FormDataFile file) {
            this.body.addFile("file", file);
            return this;
        }

        @Override
        public Response<FileCreateResult> execute() throws Exception {
            Request<FormData, FileCreateResult> request = Request.newRequest("im/v1/files", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class Files {
        private final ImService service;

        public Files(ImService service) {
            this.service = service;
        }

        public FileCreateReqCall create(RequestOptFn ... optFns) {
            return new FileCreateReqCall(this, optFns);
        }

        public FileGetReqCall get(RequestOptFn ... optFns) {
            return new FileGetReqCall(this, optFns);
        }
    }

    public static class ImageGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final Images images;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private ImageGetReqCall(Images images, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.images = images;
        }

        public ImageGetReqCall setImageKey(String imageKey) {
            this.pathParams.put("image_key", imageKey);
            return this;
        }

        public ImageGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("im/v1/images/:image_key", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.images.service.config, request);
        }
    }

    public static class ImageCreateReqCall
    extends ReqCaller<FormData, ImageCreateResult> {
        private final Images images;
        private final FormData body = new FormData();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ImageCreateResult result;

        private ImageCreateReqCall(Images images, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ImageCreateResult();
            this.images = images;
        }

        public ImageCreateReqCall setImageType(String imageType) {
            this.body.addField("image_type", imageType);
            return this;
        }

        public ImageCreateReqCall setImage(FormDataFile image) {
            this.body.addFile("image", image);
            return this;
        }

        @Override
        public Response<ImageCreateResult> execute() throws Exception {
            Request<FormData, ImageCreateResult> request = Request.newRequest("im/v1/images", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.images.service.config, request);
        }
    }

    public static class Images {
        private final ImService service;

        public Images(ImService service) {
            this.service = service;
        }

        public ImageCreateReqCall create(RequestOptFn ... optFns) {
            return new ImageCreateReqCall(this, optFns);
        }

        public ImageGetReqCall get(RequestOptFn ... optFns) {
            return new ImageGetReqCall(this, optFns);
        }
    }

    public static class ChatSearchReqCall
    extends ReqCaller<Object, ChatSearchResult> {
        private final Chats chats;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ChatSearchResult result;

        private ChatSearchReqCall(Chats chats, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatSearchResult();
            this.chats = chats;
        }

        public ChatSearchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public ChatSearchReqCall setQuery(String query) {
            this.queryParams.put("query", query);
            return this;
        }

        public ChatSearchReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public ChatSearchReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<ChatSearchResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ChatSearchResult> request = Request.newRequest("im/v1/chats/search", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chats.service.config, request);
        }
    }

    public static class ChatCreateReqCall
    extends ReqCaller<ChatCreateReqBody, ChatCreateResult> {
        private final Chats chats;
        private final ChatCreateReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ChatCreateResult result;

        private ChatCreateReqCall(Chats chats, ChatCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatCreateResult();
            this.chats = chats;
        }

        public ChatCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<ChatCreateResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ChatCreateReqBody, ChatCreateResult> request = Request.newRequest("im/v1/chats", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chats.service.config, request);
        }
    }

    public static class ChatGetReqCall
    extends ReqCaller<Object, ChatGetResult> {
        private final Chats chats;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ChatGetResult result;

        private ChatGetReqCall(Chats chats, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatGetResult();
            this.chats = chats;
        }

        public ChatGetReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<ChatGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ChatGetResult> request = Request.newRequest("im/v1/chats/:chat_id", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chats.service.config, request);
        }
    }

    public static class ChatDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Chats chats;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private ChatDeleteReqCall(Chats chats, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.chats = chats;
        }

        public ChatDeleteReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("im/v1/chats/:chat_id", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chats.service.config, request);
        }
    }

    public static class ChatListReqCall
    extends ReqCaller<Object, ChatListResult> {
        private final Chats chats;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ChatListResult result;

        private ChatListReqCall(Chats chats, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ChatListResult();
            this.chats = chats;
        }

        public ChatListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public ChatListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public ChatListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<ChatListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ChatListResult> request = Request.newRequest("im/v1/chats", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chats.service.config, request);
        }
    }

    public static class ChatUpdateReqCall
    extends ReqCaller<ChatUpdateReqBody, EmptyData> {
        private final Chats chats;
        private final ChatUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private ChatUpdateReqCall(Chats chats, ChatUpdateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.chats = chats;
        }

        public ChatUpdateReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public ChatUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ChatUpdateReqBody, EmptyData> request = Request.newRequest("im/v1/chats/:chat_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.chats.service.config, request);
        }
    }

    public static class Chats {
        private final ImService service;

        public Chats(ImService service) {
            this.service = service;
        }

        public ChatUpdateReqCall update(ChatUpdateReqBody body, RequestOptFn ... optFns) {
            return new ChatUpdateReqCall(this, body, optFns);
        }

        public ChatListReqCall list(RequestOptFn ... optFns) {
            return new ChatListReqCall(this, optFns);
        }

        public ChatDeleteReqCall delete(RequestOptFn ... optFns) {
            return new ChatDeleteReqCall(this, optFns);
        }

        public ChatGetReqCall get(RequestOptFn ... optFns) {
            return new ChatGetReqCall(this, optFns);
        }

        public ChatCreateReqCall create(ChatCreateReqBody body, RequestOptFn ... optFns) {
            return new ChatCreateReqCall(this, body, optFns);
        }

        public ChatSearchReqCall search(RequestOptFn ... optFns) {
            return new ChatSearchReqCall(this, optFns);
        }
    }

    public static class AnnouncementPatchReqCall
    extends ReqCaller<AnnouncementPatchReqBody, EmptyData> {
        private final Announcements announcements;
        private final AnnouncementPatchReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private AnnouncementPatchReqCall(Announcements announcements, AnnouncementPatchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.announcements = announcements;
        }

        public AnnouncementPatchReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<AnnouncementPatchReqBody, EmptyData> request = Request.newRequest("im/v1/chats/:chat_id/announcement", "PATCH", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.announcements.service.config, request);
        }
    }

    public static class AnnouncementGetReqCall
    extends ReqCaller<Object, AnnouncementGetResult> {
        private final Announcements announcements;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AnnouncementGetResult result;

        private AnnouncementGetReqCall(Announcements announcements, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AnnouncementGetResult();
            this.announcements = announcements;
        }

        public AnnouncementGetReqCall setChatId(String chatId) {
            this.pathParams.put("chat_id", chatId);
            return this;
        }

        public AnnouncementGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AnnouncementGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AnnouncementGetResult> request = Request.newRequest("im/v1/chats/:chat_id/announcement", "GET", new AccessTokenType[]{AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.announcements.service.config, request);
        }
    }

    public static class Announcements {
        private final ImService service;

        public Announcements(ImService service) {
            this.service = service;
        }

        public AnnouncementGetReqCall get(RequestOptFn ... optFns) {
            return new AnnouncementGetReqCall(this, optFns);
        }

        public AnnouncementPatchReqCall patch(AnnouncementPatchReqBody body, RequestOptFn ... optFns) {
            return new AnnouncementPatchReqCall(this, body, optFns);
        }
    }

    public static class ResourceGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final Resources resources;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private ResourceGetReqCall(Resources resources, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.resources = resources;
        }

        public ResourceGetReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        public ResourceGetReqCall setFileKey(String fileKey) {
            this.pathParams.put("file_key", fileKey);
            return this;
        }

        public ResourceGetReqCall setType(String type) {
            this.queryParams.put("type", type);
            return this;
        }

        public ResourceGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("im/v1/messages/:message_id/resources/:file_key", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.resources.service.config, request);
        }
    }

    public static class Resources {
        private final ImService service;

        public Resources(ImService service) {
            this.service = service;
        }

        public ResourceGetReqCall get(RequestOptFn ... optFns) {
            return new ResourceGetReqCall(this, optFns);
        }
    }

    public static class MessageUrgentReadUsersReqCall
    extends ReqCaller<Object, MessageUrgentReadUsersResult> {
        private final Messages messages;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MessageUrgentReadUsersResult result;

        private MessageUrgentReadUsersReqCall(Messages messages, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MessageUrgentReadUsersResult();
            this.messages = messages;
        }

        public MessageUrgentReadUsersReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        public MessageUrgentReadUsersReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MessageUrgentReadUsersReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public MessageUrgentReadUsersReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<MessageUrgentReadUsersResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MessageUrgentReadUsersResult> request = Request.newRequest("im/v1/messages/:message_id/urgent_read_users", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageGetReqCall
    extends ReqCaller<Object, MessageGetResult> {
        private final Messages messages;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MessageGetResult result;

        private MessageGetReqCall(Messages messages, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MessageGetResult();
            this.messages = messages;
        }

        public MessageGetReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        @Override
        public Response<MessageGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, MessageGetResult> request = Request.newRequest("im/v1/messages/:message_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageReadUsersReqCall
    extends ReqCaller<Object, MessageReadUsersResult> {
        private final Messages messages;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MessageReadUsersResult result;

        private MessageReadUsersReqCall(Messages messages, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MessageReadUsersResult();
            this.messages = messages;
        }

        public MessageReadUsersReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        public MessageReadUsersReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MessageReadUsersReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public MessageReadUsersReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<MessageReadUsersResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MessageReadUsersResult> request = Request.newRequest("im/v1/messages/:message_id/read_users", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Messages messages;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MessageDeleteReqCall(Messages messages, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.messages = messages;
        }

        public MessageDeleteReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("im/v1/messages/:message_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageCreateReqCall
    extends ReqCaller<MessageCreateReqBody, Message> {
        private final Messages messages;
        private final MessageCreateReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private Message result;

        private MessageCreateReqCall(Messages messages, MessageCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Message();
            this.messages = messages;
        }

        public MessageCreateReqCall setReceiveIdType(String receiveIdType) {
            this.queryParams.put("receive_id_type", receiveIdType);
            return this;
        }

        @Override
        public Response<Message> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MessageCreateReqBody, Message> request = Request.newRequest("im/v1/messages", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageReplyReqCall
    extends ReqCaller<MessageReplyReqBody, Message> {
        private final Messages messages;
        private final MessageReplyReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private Message result;

        private MessageReplyReqCall(Messages messages, MessageReplyReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Message();
            this.messages = messages;
        }

        public MessageReplyReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        @Override
        public Response<Message> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<MessageReplyReqBody, Message> request = Request.newRequest("im/v1/messages/:message_id/reply", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessagePatchReqCall
    extends ReqCaller<MessagePatchReqBody, EmptyData> {
        private final Messages messages;
        private final MessagePatchReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private MessagePatchReqCall(Messages messages, MessagePatchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.messages = messages;
        }

        public MessagePatchReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<MessagePatchReqBody, EmptyData> request = Request.newRequest("im/v1/messages/:message_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageUrgentSmsReqCall
    extends ReqCaller<UrgentReceivers, MessageUrgentSmsResult> {
        private final Messages messages;
        private final UrgentReceivers body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MessageUrgentSmsResult result;

        private MessageUrgentSmsReqCall(Messages messages, UrgentReceivers body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MessageUrgentSmsResult();
            this.messages = messages;
        }

        public MessageUrgentSmsReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        public MessageUrgentSmsReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<MessageUrgentSmsResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<UrgentReceivers, MessageUrgentSmsResult> request = Request.newRequest("im/v1/messages/:message_id/urgent_sms", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageUrgentPhoneReqCall
    extends ReqCaller<UrgentReceivers, MessageUrgentPhoneResult> {
        private final Messages messages;
        private final UrgentReceivers body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MessageUrgentPhoneResult result;

        private MessageUrgentPhoneReqCall(Messages messages, UrgentReceivers body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MessageUrgentPhoneResult();
            this.messages = messages;
        }

        public MessageUrgentPhoneReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        public MessageUrgentPhoneReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<MessageUrgentPhoneResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<UrgentReceivers, MessageUrgentPhoneResult> request = Request.newRequest("im/v1/messages/:message_id/urgent_phone", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageUrgentAppReqCall
    extends ReqCaller<UrgentReceivers, MessageUrgentAppResult> {
        private final Messages messages;
        private final UrgentReceivers body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MessageUrgentAppResult result;

        private MessageUrgentAppReqCall(Messages messages, UrgentReceivers body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MessageUrgentAppResult();
            this.messages = messages;
        }

        public MessageUrgentAppReqCall setMessageId(String messageId) {
            this.pathParams.put("message_id", messageId);
            return this;
        }

        public MessageUrgentAppReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<MessageUrgentAppResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<UrgentReceivers, MessageUrgentAppResult> request = Request.newRequest("im/v1/messages/:message_id/urgent_app", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class MessageListReqCall
    extends ReqCaller<Object, MessageListResult> {
        private final Messages messages;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MessageListResult result;

        private MessageListReqCall(Messages messages, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MessageListResult();
            this.messages = messages;
        }

        public MessageListReqCall setContainerIdType(String containerIdType) {
            this.queryParams.put("container_id_type", containerIdType);
            return this;
        }

        public MessageListReqCall setContainerId(String containerId) {
            this.queryParams.put("container_id", containerId);
            return this;
        }

        public MessageListReqCall setStartTime(String startTime) {
            this.queryParams.put("start_time", startTime);
            return this;
        }

        public MessageListReqCall setEndTime(String endTime) {
            this.queryParams.put("end_time", endTime);
            return this;
        }

        public MessageListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public MessageListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<MessageListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MessageListResult> request = Request.newRequest("im/v1/messages", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.messages.service.config, request);
        }
    }

    public static class Messages {
        private final ImService service;

        public Messages(ImService service) {
            this.service = service;
        }

        public MessageListReqCall list(RequestOptFn ... optFns) {
            return new MessageListReqCall(this, optFns);
        }

        public MessageUrgentAppReqCall urgentApp(UrgentReceivers body, RequestOptFn ... optFns) {
            return new MessageUrgentAppReqCall(this, body, optFns);
        }

        public MessageUrgentPhoneReqCall urgentPhone(UrgentReceivers body, RequestOptFn ... optFns) {
            return new MessageUrgentPhoneReqCall(this, body, optFns);
        }

        public MessageUrgentSmsReqCall urgentSms(UrgentReceivers body, RequestOptFn ... optFns) {
            return new MessageUrgentSmsReqCall(this, body, optFns);
        }

        public MessagePatchReqCall patch(MessagePatchReqBody body, RequestOptFn ... optFns) {
            return new MessagePatchReqCall(this, body, optFns);
        }

        public MessageReplyReqCall reply(MessageReplyReqBody body, RequestOptFn ... optFns) {
            return new MessageReplyReqCall(this, body, optFns);
        }

        public MessageCreateReqCall create(MessageCreateReqBody body, RequestOptFn ... optFns) {
            return new MessageCreateReqCall(this, body, optFns);
        }

        public MessageDeleteReqCall delete(RequestOptFn ... optFns) {
            return new MessageDeleteReqCall(this, optFns);
        }

        public MessageReadUsersReqCall readUsers(RequestOptFn ... optFns) {
            return new MessageReadUsersReqCall(this, optFns);
        }

        public MessageGetReqCall get(RequestOptFn ... optFns) {
            return new MessageGetReqCall(this, optFns);
        }

        public MessageUrgentReadUsersReqCall urgentReadUsers(RequestOptFn ... optFns) {
            return new MessageUrgentReadUsersReqCall(this, optFns);
        }
    }
}

