/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core;

import com.larksuite.oapi.core.IStore;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStore
implements IStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultStore.class);
    private ConcurrentMap<String, Value> cm = new ConcurrentHashMap<String, Value>(64);

    @Override
    public String get(String key) {
        log.debug("get key:{}", (Object)key);
        Value v = (Value)this.cm.get(key);
        if (v == null || new Date().after(v.end)) {
            return "";
        }
        return v.value;
    }

    @Override
    public void put(String key, String value, int expire, TimeUnit timeUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, (int)timeUnit.toSeconds(expire));
        Value v = new Value(value, calendar.getTime());
        log.debug("put key:{}, value:{}, expire time:{} ", new Object[]{key, value, calendar.getTime()});
        this.cm.put(key, v);
    }

    static class Value {
        String value;
        Date end;

        public Value(String value, Date time) {
            this.value = value;
            this.end = time;
        }
    }
}

