/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.card.handler.subhandler;

import com.larksuite.oapi.core.Context;
import com.larksuite.oapi.core.card.handler.ISubHandler;
import com.larksuite.oapi.core.card.mode.HTTPCard;
import com.larksuite.oapi.core.card.mode.Header;
import com.larksuite.oapi.core.model.OapiRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSubHandler
implements ISubHandler {
    private static final Logger log = LoggerFactory.getLogger(InitSubHandler.class);

    @Override
    public void handle(Context context, HTTPCard httpCard) throws Exception {
        OapiRequest request = httpCard.getRequest();
        context.set("HTTP_HEADER", request.getHeader());
        String timestamp = request.getHeader().getFirstValue("X-Lark-Request-Timestamp");
        String nonce = request.getHeader().getFirstValue("X-Lark-Request-Nonce");
        String signature = request.getHeader().getFirstValue("X-Lark-Signature");
        String refreshToken = request.getHeader().getFirstValue("X-Refresh-Token");
        Header header = new Header(timestamp, nonce, signature, refreshToken);
        httpCard.setHeader(header);
        httpCard.setInput(httpCard.getRequest().getBody());
        log.debug("[init] header:{}, card: {}", (Object)header, (Object)httpCard.getInput());
    }
}

