/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.vc.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.vc.v1.model.MeetingGetResult;
import com.larksuite.oapi.service.vc.v1.model.MeetingInviteReqBody;
import com.larksuite.oapi.service.vc.v1.model.MeetingInviteResult;
import com.larksuite.oapi.service.vc.v1.model.MeetingJoinMeetingEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingLeaveMeetingEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingListResult;
import com.larksuite.oapi.service.vc.v1.model.MeetingMeetingEndedEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingMeetingStartedEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingRecordingEndedEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingRecordingGetResult;
import com.larksuite.oapi.service.vc.v1.model.MeetingRecordingReadyEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingRecordingSetPermissionReqBody;
import com.larksuite.oapi.service.vc.v1.model.MeetingRecordingStartReqBody;
import com.larksuite.oapi.service.vc.v1.model.MeetingRecordingStartedEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingSendMeetingImEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingSetHostReqBody;
import com.larksuite.oapi.service.vc.v1.model.MeetingSetHostResult;
import com.larksuite.oapi.service.vc.v1.model.MeetingShareEndedEvent;
import com.larksuite.oapi.service.vc.v1.model.MeetingShareStartedEvent;
import com.larksuite.oapi.service.vc.v1.model.ReportGetDailyResult;
import com.larksuite.oapi.service.vc.v1.model.ReportGetTopUserResult;
import com.larksuite.oapi.service.vc.v1.model.ReserveApplyReqBody;
import com.larksuite.oapi.service.vc.v1.model.ReserveApplyResult;
import com.larksuite.oapi.service.vc.v1.model.ReserveGetActiveMeetingResult;
import com.larksuite.oapi.service.vc.v1.model.ReserveGetResult;
import com.larksuite.oapi.service.vc.v1.model.ReserveUpdateReqBody;
import com.larksuite.oapi.service.vc.v1.model.ReserveUpdateResult;
import com.larksuite.oapi.service.vc.v1.model.RoomConfig;
import com.larksuite.oapi.service.vc.v1.model.RoomConfigSetReqBody;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VcService {
    private final Config config;
    private final MeetingRecordings meetingRecordings;
    private final Meetings meetings;
    private final Reports reports;
    private final RoomConfigs roomConfigs;
    private final Reserves reserves;

    public VcService(Config config) {
        this.config = config;
        this.meetingRecordings = new MeetingRecordings(this);
        this.meetings = new Meetings(this);
        this.reports = new Reports(this);
        this.roomConfigs = new RoomConfigs(this);
        this.reserves = new Reserves(this);
    }

    public MeetingRecordings getMeetingRecordings() {
        return this.meetingRecordings;
    }

    public Meetings getMeetings() {
        return this.meetings;
    }

    public Reports getReports() {
        return this.reports;
    }

    public RoomConfigs getRoomConfigs() {
        return this.roomConfigs;
    }

    public Reserves getReserves() {
        return this.reserves;
    }

    public void setMeetingLeaveMeetingEventHandler(MeetingLeaveMeetingEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.leave_meeting_v1", handler);
    }

    public void setMeetingMeetingEndedEventHandler(MeetingMeetingEndedEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.meeting_ended_v1", handler);
    }

    public void setMeetingMeetingStartedEventHandler(MeetingMeetingStartedEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.meeting_started_v1", handler);
    }

    public void setMeetingRecordingEndedEventHandler(MeetingRecordingEndedEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.recording_ended_v1", handler);
    }

    public void setMeetingShareEndedEventHandler(MeetingShareEndedEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.share_ended_v1", handler);
    }

    public void setMeetingJoinMeetingEventHandler(MeetingJoinMeetingEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.join_meeting_v1", handler);
    }

    public void setMeetingRecordingStartedEventHandler(MeetingRecordingStartedEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.recording_started_v1", handler);
    }

    public void setMeetingSendMeetingImEventHandler(MeetingSendMeetingImEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.send_meeting_im_v1", handler);
    }

    public void setMeetingShareStartedEventHandler(MeetingShareStartedEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.share_started_v1", handler);
    }

    public void setMeetingRecordingReadyEventHandler(MeetingRecordingReadyEventHandler handler) {
        Event.setTypeHandler(this.config, "vc.meeting.recording_ready_v1", handler);
    }

    public static abstract class MeetingRecordingReadyEventHandler
    implements IHandler<MeetingRecordingReadyEvent> {
        @Override
        public MeetingRecordingReadyEvent getEvent() {
            return new MeetingRecordingReadyEvent();
        }
    }

    public static abstract class MeetingShareStartedEventHandler
    implements IHandler<MeetingShareStartedEvent> {
        @Override
        public MeetingShareStartedEvent getEvent() {
            return new MeetingShareStartedEvent();
        }
    }

    public static abstract class MeetingSendMeetingImEventHandler
    implements IHandler<MeetingSendMeetingImEvent> {
        @Override
        public MeetingSendMeetingImEvent getEvent() {
            return new MeetingSendMeetingImEvent();
        }
    }

    public static abstract class MeetingRecordingStartedEventHandler
    implements IHandler<MeetingRecordingStartedEvent> {
        @Override
        public MeetingRecordingStartedEvent getEvent() {
            return new MeetingRecordingStartedEvent();
        }
    }

    public static abstract class MeetingJoinMeetingEventHandler
    implements IHandler<MeetingJoinMeetingEvent> {
        @Override
        public MeetingJoinMeetingEvent getEvent() {
            return new MeetingJoinMeetingEvent();
        }
    }

    public static abstract class MeetingShareEndedEventHandler
    implements IHandler<MeetingShareEndedEvent> {
        @Override
        public MeetingShareEndedEvent getEvent() {
            return new MeetingShareEndedEvent();
        }
    }

    public static abstract class MeetingRecordingEndedEventHandler
    implements IHandler<MeetingRecordingEndedEvent> {
        @Override
        public MeetingRecordingEndedEvent getEvent() {
            return new MeetingRecordingEndedEvent();
        }
    }

    public static abstract class MeetingMeetingStartedEventHandler
    implements IHandler<MeetingMeetingStartedEvent> {
        @Override
        public MeetingMeetingStartedEvent getEvent() {
            return new MeetingMeetingStartedEvent();
        }
    }

    public static abstract class MeetingMeetingEndedEventHandler
    implements IHandler<MeetingMeetingEndedEvent> {
        @Override
        public MeetingMeetingEndedEvent getEvent() {
            return new MeetingMeetingEndedEvent();
        }
    }

    public static abstract class MeetingLeaveMeetingEventHandler
    implements IHandler<MeetingLeaveMeetingEvent> {
        @Override
        public MeetingLeaveMeetingEvent getEvent() {
            return new MeetingLeaveMeetingEvent();
        }
    }

    public static class ReserveDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Reserves reserves;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private ReserveDeleteReqCall(Reserves reserves, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.reserves = reserves;
        }

        public ReserveDeleteReqCall setReserveId(Long reserveId) {
            this.pathParams.put("reserve_id", reserveId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("vc/v1/reserves/:reserve_id", "DELETE", new AccessTokenType[]{AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.reserves.service.config, request);
        }
    }

    public static class ReserveGetActiveMeetingReqCall
    extends ReqCaller<Object, ReserveGetActiveMeetingResult> {
        private final Reserves reserves;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ReserveGetActiveMeetingResult result;

        private ReserveGetActiveMeetingReqCall(Reserves reserves, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ReserveGetActiveMeetingResult();
            this.reserves = reserves;
        }

        public ReserveGetActiveMeetingReqCall setReserveId(Long reserveId) {
            this.pathParams.put("reserve_id", reserveId);
            return this;
        }

        public ReserveGetActiveMeetingReqCall setWithParticipants(Boolean withParticipants) {
            this.queryParams.put("with_participants", withParticipants);
            return this;
        }

        @Override
        public Response<ReserveGetActiveMeetingResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ReserveGetActiveMeetingResult> request = Request.newRequest("vc/v1/reserves/:reserve_id/get_active_meeting", "GET", new AccessTokenType[]{AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.reserves.service.config, request);
        }
    }

    public static class ReserveGetReqCall
    extends ReqCaller<Object, ReserveGetResult> {
        private final Reserves reserves;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ReserveGetResult result;

        private ReserveGetReqCall(Reserves reserves, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ReserveGetResult();
            this.reserves = reserves;
        }

        public ReserveGetReqCall setReserveId(Long reserveId) {
            this.pathParams.put("reserve_id", reserveId);
            return this;
        }

        @Override
        public Response<ReserveGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, ReserveGetResult> request = Request.newRequest("vc/v1/reserves/:reserve_id", "GET", new AccessTokenType[]{AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.reserves.service.config, request);
        }
    }

    public static class ReserveApplyReqCall
    extends ReqCaller<ReserveApplyReqBody, ReserveApplyResult> {
        private final Reserves reserves;
        private final ReserveApplyReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ReserveApplyResult result;

        private ReserveApplyReqCall(Reserves reserves, ReserveApplyReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ReserveApplyResult();
            this.reserves = reserves;
        }

        public ReserveApplyReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<ReserveApplyResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ReserveApplyReqBody, ReserveApplyResult> request = Request.newRequest("vc/v1/reserves/apply", "POST", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.reserves.service.config, request);
        }
    }

    public static class ReserveUpdateReqCall
    extends ReqCaller<ReserveUpdateReqBody, ReserveUpdateResult> {
        private final Reserves reserves;
        private final ReserveUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ReserveUpdateResult result;

        private ReserveUpdateReqCall(Reserves reserves, ReserveUpdateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ReserveUpdateResult();
            this.reserves = reserves;
        }

        public ReserveUpdateReqCall setReserveId(Long reserveId) {
            this.pathParams.put("reserve_id", reserveId);
            return this;
        }

        public ReserveUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<ReserveUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ReserveUpdateReqBody, ReserveUpdateResult> request = Request.newRequest("vc/v1/reserves/:reserve_id", "PUT", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.reserves.service.config, request);
        }
    }

    public static class Reserves {
        private final VcService service;

        public Reserves(VcService service) {
            this.service = service;
        }

        public ReserveUpdateReqCall update(ReserveUpdateReqBody body, RequestOptFn ... optFns) {
            return new ReserveUpdateReqCall(this, body, optFns);
        }

        public ReserveApplyReqCall apply(ReserveApplyReqBody body, RequestOptFn ... optFns) {
            return new ReserveApplyReqCall(this, body, optFns);
        }

        public ReserveGetReqCall get(RequestOptFn ... optFns) {
            return new ReserveGetReqCall(this, optFns);
        }

        public ReserveGetActiveMeetingReqCall getActiveMeeting(RequestOptFn ... optFns) {
            return new ReserveGetActiveMeetingReqCall(this, optFns);
        }

        public ReserveDeleteReqCall delete(RequestOptFn ... optFns) {
            return new ReserveDeleteReqCall(this, optFns);
        }
    }

    public static class RoomConfigSetReqCall
    extends ReqCaller<RoomConfigSetReqBody, EmptyData> {
        private final RoomConfigs roomConfigs;
        private final RoomConfigSetReqBody body;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private RoomConfigSetReqCall(RoomConfigs roomConfigs, RoomConfigSetReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.roomConfigs = roomConfigs;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            Request<RoomConfigSetReqBody, EmptyData> request = Request.newRequest("vc/v1/room_configs/set", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.roomConfigs.service.config, request);
        }
    }

    public static class RoomConfigQueryReqCall
    extends ReqCaller<Object, RoomConfig> {
        private final RoomConfigs roomConfigs;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private RoomConfig result;

        private RoomConfigQueryReqCall(RoomConfigs roomConfigs, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new RoomConfig();
            this.roomConfigs = roomConfigs;
        }

        public RoomConfigQueryReqCall setScope(Integer scope) {
            this.queryParams.put("scope", scope);
            return this;
        }

        public RoomConfigQueryReqCall setCountryId(Long countryId) {
            this.queryParams.put("country_id", countryId);
            return this;
        }

        public RoomConfigQueryReqCall setDistrictId(Long districtId) {
            this.queryParams.put("district_id", districtId);
            return this;
        }

        public RoomConfigQueryReqCall setBuildingId(Long buildingId) {
            this.queryParams.put("building_id", buildingId);
            return this;
        }

        public RoomConfigQueryReqCall setFloorName(String floorName) {
            this.queryParams.put("floor_name", floorName);
            return this;
        }

        public RoomConfigQueryReqCall setRoomId(Long roomId) {
            this.queryParams.put("room_id", roomId);
            return this;
        }

        @Override
        public Response<RoomConfig> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, RoomConfig> request = Request.newRequest("vc/v1/room_configs/query", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.roomConfigs.service.config, request);
        }
    }

    public static class RoomConfigs {
        private final VcService service;

        public RoomConfigs(VcService service) {
            this.service = service;
        }

        public RoomConfigQueryReqCall query(RequestOptFn ... optFns) {
            return new RoomConfigQueryReqCall(this, optFns);
        }

        public RoomConfigSetReqCall set(RoomConfigSetReqBody body, RequestOptFn ... optFns) {
            return new RoomConfigSetReqCall(this, body, optFns);
        }
    }

    public static class ReportGetDailyReqCall
    extends ReqCaller<Object, ReportGetDailyResult> {
        private final Reports reports;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ReportGetDailyResult result;

        private ReportGetDailyReqCall(Reports reports, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ReportGetDailyResult();
            this.reports = reports;
        }

        public ReportGetDailyReqCall setStartTime(Long startTime) {
            this.queryParams.put("start_time", startTime);
            return this;
        }

        public ReportGetDailyReqCall setEndTime(Long endTime) {
            this.queryParams.put("end_time", endTime);
            return this;
        }

        @Override
        public Response<ReportGetDailyResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ReportGetDailyResult> request = Request.newRequest("vc/v1/reports/get_daily", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.reports.service.config, request);
        }
    }

    public static class ReportGetTopUserReqCall
    extends ReqCaller<Object, ReportGetTopUserResult> {
        private final Reports reports;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ReportGetTopUserResult result;

        private ReportGetTopUserReqCall(Reports reports, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ReportGetTopUserResult();
            this.reports = reports;
        }

        public ReportGetTopUserReqCall setStartTime(Long startTime) {
            this.queryParams.put("start_time", startTime);
            return this;
        }

        public ReportGetTopUserReqCall setEndTime(Long endTime) {
            this.queryParams.put("end_time", endTime);
            return this;
        }

        public ReportGetTopUserReqCall setLimit(Integer limit) {
            this.queryParams.put("limit", limit);
            return this;
        }

        public ReportGetTopUserReqCall setOrderBy(Integer orderBy) {
            this.queryParams.put("order_by", orderBy);
            return this;
        }

        @Override
        public Response<ReportGetTopUserResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ReportGetTopUserResult> request = Request.newRequest("vc/v1/reports/get_top_user", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.reports.service.config, request);
        }
    }

    public static class Reports {
        private final VcService service;

        public Reports(VcService service) {
            this.service = service;
        }

        public ReportGetTopUserReqCall getTopUser(RequestOptFn ... optFns) {
            return new ReportGetTopUserReqCall(this, optFns);
        }

        public ReportGetDailyReqCall getDaily(RequestOptFn ... optFns) {
            return new ReportGetDailyReqCall(this, optFns);
        }
    }

    public static class MeetingGetReqCall
    extends ReqCaller<Object, MeetingGetResult> {
        private final Meetings meetings;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MeetingGetResult result;

        private MeetingGetReqCall(Meetings meetings, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MeetingGetResult();
            this.meetings = meetings;
        }

        public MeetingGetReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        public MeetingGetReqCall setWithParticipants(Boolean withParticipants) {
            this.queryParams.put("with_participants", withParticipants);
            return this;
        }

        public MeetingGetReqCall setWithMeetingAbility(Boolean withMeetingAbility) {
            this.queryParams.put("with_meeting_ability", withMeetingAbility);
            return this;
        }

        public MeetingGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<MeetingGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MeetingGetResult> request = Request.newRequest("vc/v1/meetings/:meeting_id", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetings.service.config, request);
        }
    }

    public static class MeetingEndReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Meetings meetings;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MeetingEndReqCall(Meetings meetings, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.meetings = meetings;
        }

        public MeetingEndReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("vc/v1/meetings/:meeting_id/end", "PATCH", new AccessTokenType[]{AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetings.service.config, request);
        }
    }

    public static class MeetingSetHostReqCall
    extends ReqCaller<MeetingSetHostReqBody, MeetingSetHostResult> {
        private final Meetings meetings;
        private final MeetingSetHostReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MeetingSetHostResult result;

        private MeetingSetHostReqCall(Meetings meetings, MeetingSetHostReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MeetingSetHostResult();
            this.meetings = meetings;
        }

        public MeetingSetHostReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        public MeetingSetHostReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<MeetingSetHostResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MeetingSetHostReqBody, MeetingSetHostResult> request = Request.newRequest("vc/v1/meetings/:meeting_id/set_host", "PATCH", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetings.service.config, request);
        }
    }

    public static class MeetingListReqCall
    extends ReqCaller<Object, MeetingListResult> {
        private final Meetings meetings;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MeetingListResult result;

        private MeetingListReqCall(Meetings meetings, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MeetingListResult();
            this.meetings = meetings;
        }

        public MeetingListReqCall setRoomId(Long roomId) {
            this.queryParams.put("room_id", roomId);
            return this;
        }

        public MeetingListReqCall setStartTime(Long startTime) {
            this.queryParams.put("start_time", startTime);
            return this;
        }

        public MeetingListReqCall setEndTime(Long endTime) {
            this.queryParams.put("end_time", endTime);
            return this;
        }

        public MeetingListReqCall setStatus(Integer status) {
            this.queryParams.put("status", status);
            return this;
        }

        public MeetingListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public MeetingListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<MeetingListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MeetingListResult> request = Request.newRequest("vc/v1/meetings", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetings.service.config, request);
        }
    }

    public static class MeetingInviteReqCall
    extends ReqCaller<MeetingInviteReqBody, MeetingInviteResult> {
        private final Meetings meetings;
        private final MeetingInviteReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MeetingInviteResult result;

        private MeetingInviteReqCall(Meetings meetings, MeetingInviteReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MeetingInviteResult();
            this.meetings = meetings;
        }

        public MeetingInviteReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        public MeetingInviteReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<MeetingInviteResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MeetingInviteReqBody, MeetingInviteResult> request = Request.newRequest("vc/v1/meetings/:meeting_id/invite", "PATCH", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetings.service.config, request);
        }
    }

    public static class Meetings {
        private final VcService service;

        public Meetings(VcService service) {
            this.service = service;
        }

        public MeetingInviteReqCall invite(MeetingInviteReqBody body, RequestOptFn ... optFns) {
            return new MeetingInviteReqCall(this, body, optFns);
        }

        public MeetingListReqCall list(RequestOptFn ... optFns) {
            return new MeetingListReqCall(this, optFns);
        }

        public MeetingSetHostReqCall setHost(MeetingSetHostReqBody body, RequestOptFn ... optFns) {
            return new MeetingSetHostReqCall(this, body, optFns);
        }

        public MeetingEndReqCall end(RequestOptFn ... optFns) {
            return new MeetingEndReqCall(this, optFns);
        }

        public MeetingGetReqCall get(RequestOptFn ... optFns) {
            return new MeetingGetReqCall(this, optFns);
        }
    }

    public static class MeetingRecordingStartReqCall
    extends ReqCaller<MeetingRecordingStartReqBody, EmptyData> {
        private final MeetingRecordings meetingRecordings;
        private final MeetingRecordingStartReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private MeetingRecordingStartReqCall(MeetingRecordings meetingRecordings, MeetingRecordingStartReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.meetingRecordings = meetingRecordings;
        }

        public MeetingRecordingStartReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<MeetingRecordingStartReqBody, EmptyData> request = Request.newRequest("vc/v1/meetings/:meeting_id/recording/start", "PATCH", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetingRecordings.service.config, request);
        }
    }

    public static class MeetingRecordingSetPermissionReqCall
    extends ReqCaller<MeetingRecordingSetPermissionReqBody, EmptyData> {
        private final MeetingRecordings meetingRecordings;
        private final MeetingRecordingSetPermissionReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private MeetingRecordingSetPermissionReqCall(MeetingRecordings meetingRecordings, MeetingRecordingSetPermissionReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.meetingRecordings = meetingRecordings;
        }

        public MeetingRecordingSetPermissionReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        public MeetingRecordingSetPermissionReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MeetingRecordingSetPermissionReqBody, EmptyData> request = Request.newRequest("vc/v1/meetings/:meeting_id/recording/set_permission", "PATCH", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetingRecordings.service.config, request);
        }
    }

    public static class MeetingRecordingStopReqCall
    extends ReqCaller<Object, EmptyData> {
        private final MeetingRecordings meetingRecordings;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MeetingRecordingStopReqCall(MeetingRecordings meetingRecordings, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.meetingRecordings = meetingRecordings;
        }

        public MeetingRecordingStopReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("vc/v1/meetings/:meeting_id/recording/stop", "PATCH", new AccessTokenType[]{AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetingRecordings.service.config, request);
        }
    }

    public static class MeetingRecordingGetReqCall
    extends ReqCaller<Object, MeetingRecordingGetResult> {
        private final MeetingRecordings meetingRecordings;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MeetingRecordingGetResult result;

        private MeetingRecordingGetReqCall(MeetingRecordings meetingRecordings, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MeetingRecordingGetResult();
            this.meetingRecordings = meetingRecordings;
        }

        public MeetingRecordingGetReqCall setMeetingId(Long meetingId) {
            this.pathParams.put("meeting_id", meetingId);
            return this;
        }

        @Override
        public Response<MeetingRecordingGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, MeetingRecordingGetResult> request = Request.newRequest("vc/v1/meetings/:meeting_id/recording", "GET", new AccessTokenType[]{AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.meetingRecordings.service.config, request);
        }
    }

    public static class MeetingRecordings {
        private final VcService service;

        public MeetingRecordings(VcService service) {
            this.service = service;
        }

        public MeetingRecordingGetReqCall get(RequestOptFn ... optFns) {
            return new MeetingRecordingGetReqCall(this, optFns);
        }

        public MeetingRecordingStopReqCall stop(RequestOptFn ... optFns) {
            return new MeetingRecordingStopReqCall(this, optFns);
        }

        public MeetingRecordingSetPermissionReqCall setPermission(MeetingRecordingSetPermissionReqBody body, RequestOptFn ... optFns) {
            return new MeetingRecordingSetPermissionReqCall(this, body, optFns);
        }

        public MeetingRecordingStartReqCall start(MeetingRecordingStartReqBody body, RequestOptFn ... optFns) {
            return new MeetingRecordingStartReqCall(this, body, optFns);
        }
    }
}

