/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.sdk.servlet.ext;

import com.lark.oapi.core.request.EventReq;
import com.lark.oapi.core.response.EventResp;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpTranslator {
    private String normalizeKey(String name) {
        return name != null ? name.toLowerCase() : null;
    }

    private Map<String, List<String>> toHeaderMap(HttpServletRequest req) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList values = Collections.list(req.getHeaders(name));
            headers.put(this.normalizeKey(name), values);
        }
        return headers;
    }

    public EventReq translate(HttpServletRequest request) throws IOException {
        String bodyStr = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        EventReq req = new EventReq();
        req.setHeaders(this.toHeaderMap(request));
        req.setBody(bodyStr.getBytes(StandardCharsets.UTF_8));
        req.setHttpPath(request.getRequestURI());
        return req;
    }

    public void write(HttpServletResponse response, EventResp eventResp) throws IOException {
        response.setStatus(eventResp.getStatusCode());
        eventResp.getHeaders().entrySet().stream().forEach(keyValues -> {
            String key = (String)keyValues.getKey();
            List values = (List)keyValues.getValue();
            values.stream().forEach(v -> response.addHeader(key, v));
        });
        if (eventResp.getBody() != null) {
            response.getWriter().write(new String(eventResp.getBody()));
        }
    }
}

