// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.acs.v1.model;

import com.google.gson.annotations.SerializedName;

public class AccessRecord {

  @SerializedName("access_record_id")
  private String accessRecordId;
  @SerializedName("user_id")
  private String userId;
  @SerializedName("device_id")
  private String deviceId;
  @SerializedName("is_clock_in")
  private Boolean isClockIn;
  @SerializedName("access_time")
  private String accessTime;
  @SerializedName("access_type")
  private String accessType;
  @SerializedName("access_data")
  private String accessData;
  @SerializedName("is_door_open")
  private Boolean isDoorOpen;

  // builder 开始
  public AccessRecord() {
  }

  public AccessRecord(Builder builder) {
    this.accessRecordId = builder.accessRecordId;
    this.userId = builder.userId;
    this.deviceId = builder.deviceId;
    this.isClockIn = builder.isClockIn;
    this.accessTime = builder.accessTime;
    this.accessType = builder.accessType;
    this.accessData = builder.accessData;
    this.isDoorOpen = builder.isDoorOpen;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getAccessRecordId() {
    return this.accessRecordId;
  }

  public void setAccessRecordId(String accessRecordId) {
    this.accessRecordId = accessRecordId;
  }

  public String getUserId() {
    return this.userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getDeviceId() {
    return this.deviceId;
  }

  public void setDeviceId(String deviceId) {
    this.deviceId = deviceId;
  }

  public Boolean getIsClockIn() {
    return this.isClockIn;
  }

  public void setIsClockIn(Boolean isClockIn) {
    this.isClockIn = isClockIn;
  }

  public String getAccessTime() {
    return this.accessTime;
  }

  public void setAccessTime(String accessTime) {
    this.accessTime = accessTime;
  }

  public String getAccessType() {
    return this.accessType;
  }

  public void setAccessType(String accessType) {
    this.accessType = accessType;
  }

  public String getAccessData() {
    return this.accessData;
  }

  public void setAccessData(String accessData) {
    this.accessData = accessData;
  }

  public Boolean getIsDoorOpen() {
    return this.isDoorOpen;
  }

  public void setIsDoorOpen(Boolean isDoorOpen) {
    this.isDoorOpen = isDoorOpen;
  }

  public static class Builder {

    private String accessRecordId;
    private String userId;
    private String deviceId;
    private Boolean isClockIn;
    private String accessTime;
    private String accessType;
    private String accessData;
    private Boolean isDoorOpen;

    public Builder accessRecordId(String accessRecordId) {
      this.accessRecordId = accessRecordId;
      return this;
    }

    public Builder userId(String userId) {
      this.userId = userId;
      return this;
    }

    public Builder deviceId(String deviceId) {
      this.deviceId = deviceId;
      return this;
    }

    public Builder isClockIn(Boolean isClockIn) {
      this.isClockIn = isClockIn;
      return this;
    }

    public Builder accessTime(String accessTime) {
      this.accessTime = accessTime;
      return this;
    }

    public Builder accessType(String accessType) {
      this.accessType = accessType;
      return this;
    }

    public Builder accessType(com.lark.oapi.service.acs.v1.enums.AccessTypeEnum accessType) {
      this.accessType = accessType.getValue();
      return this;
    }

    public Builder accessData(String accessData) {
      this.accessData = accessData;
      return this;
    }

    public Builder isDoorOpen(Boolean isDoorOpen) {
      this.isDoorOpen = isDoorOpen;
      return this;
    }


    public AccessRecord build() {
      return new AccessRecord(this);
    }
  }
}
