// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.admin.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.admin.v1.model.ListAdminDeptStatReq;
import com.lark.oapi.service.admin.v1.model.ListAdminDeptStatResp;
import com.lark.oapi.service.admin.v1.model.ListAdminUserStatReq;
import com.lark.oapi.service.admin.v1.model.ListAdminUserStatResp;
import com.lark.oapi.service.admin.v1.model.ResetPasswordReq;
import com.lark.oapi.service.admin.v1.model.ResetPasswordResp;

public class AdminService {

  private final AdminDeptStat adminDeptStat;
  private final AdminUserStat adminUserStat;
  private final Password password;

  public AdminService(Config config) {
    this.adminDeptStat = new AdminDeptStat(config);
    this.adminUserStat = new AdminUserStat(config);
    this.password = new Password(config);
  }

  public AdminDeptStat adminDeptStat() {
    return adminDeptStat;
  }

  public AdminUserStat adminUserStat() {
    return adminUserStat;
  }

  public Password password() {
    return password;
  }

  public static class AdminDeptStat {

    private final Config config;

    public AdminDeptStat(Config config) {
      this.config = config;
    }

    public ListAdminDeptStatResp list(ListAdminDeptStatReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_dept_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminDeptStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminDeptStatResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAdminDeptStatResp list(ListAdminDeptStatReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_dept_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminDeptStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminDeptStatResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AdminUserStat {

    private final Config config;

    public AdminUserStat(Config config) {
      this.config = config;
    }

    public ListAdminUserStatResp list(ListAdminUserStatReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_user_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminUserStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminUserStatResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAdminUserStatResp list(ListAdminUserStatReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_user_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminUserStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminUserStatResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Password {

    private final Config config;

    public Password(Config config) {
      this.config = config;
    }

    public ResetPasswordResp reset(ResetPasswordReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/password/reset"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ResetPasswordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ResetPasswordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ResetPasswordResp reset(ResetPasswordReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/password/reset"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ResetPasswordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ResetPasswordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}