// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.admin.v1.model;

import com.google.gson.annotations.SerializedName;

public class AuditContext {

  @SerializedName("terminal_type")
  private Integer terminalType;
  @SerializedName("ios_context")
  private AuditIosContext iosContext;
  @SerializedName("pc_context")
  private AuditPcContext pcContext;
  @SerializedName("web_context")
  private AuditWebContext webContext;
  @SerializedName("android_context")
  private AuditAndroidContext androidContext;

  // builder 开始
  public AuditContext() {
  }

  public AuditContext(Builder builder) {
    this.terminalType = builder.terminalType;
    this.iosContext = builder.iosContext;
    this.pcContext = builder.pcContext;
    this.webContext = builder.webContext;
    this.androidContext = builder.androidContext;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Integer getTerminalType() {
    return this.terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  public AuditIosContext getIosContext() {
    return this.iosContext;
  }

  public void setIosContext(AuditIosContext iosContext) {
    this.iosContext = iosContext;
  }

  public AuditPcContext getPcContext() {
    return this.pcContext;
  }

  public void setPcContext(AuditPcContext pcContext) {
    this.pcContext = pcContext;
  }

  public AuditWebContext getWebContext() {
    return this.webContext;
  }

  public void setWebContext(AuditWebContext webContext) {
    this.webContext = webContext;
  }

  public AuditAndroidContext getAndroidContext() {
    return this.androidContext;
  }

  public void setAndroidContext(AuditAndroidContext androidContext) {
    this.androidContext = androidContext;
  }

  public static class Builder {

    private Integer terminalType;
    private AuditIosContext iosContext;
    private AuditPcContext pcContext;
    private AuditWebContext webContext;
    private AuditAndroidContext androidContext;

    public Builder terminalType(Integer terminalType) {
      this.terminalType = terminalType;
      return this;
    }

    public Builder terminalType(
        com.lark.oapi.service.admin.v1.enums.TerminalTypeEnum terminalType) {
      this.terminalType = terminalType.getValue();
      return this;
    }

    public Builder iosContext(AuditIosContext iosContext) {
      this.iosContext = iosContext;
      return this;
    }

    public Builder pcContext(AuditPcContext pcContext) {
      this.pcContext = pcContext;
      return this;
    }

    public Builder webContext(AuditWebContext webContext) {
      this.webContext = webContext;
      return this;
    }

    public Builder androidContext(AuditAndroidContext androidContext) {
      this.androidContext = androidContext;
      return this;
    }


    public AuditContext build() {
      return new AuditContext(this);
    }
  }
}
