// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.application.v6.model.GetApplicationAppVersionReq;
import com.lark.oapi.service.application.v6.model.GetApplicationAppVersionResp;
import com.lark.oapi.service.application.v6.model.GetApplicationReq;
import com.lark.oapi.service.application.v6.model.GetApplicationResp;
import com.lark.oapi.service.application.v6.model.ListApplicationFeedbackReq;
import com.lark.oapi.service.application.v6.model.ListApplicationFeedbackResp;
import com.lark.oapi.service.application.v6.model.OverviewApplicationAppUsageReq;
import com.lark.oapi.service.application.v6.model.OverviewApplicationAppUsageResp;
import com.lark.oapi.service.application.v6.model.P1AppOpenV6;
import com.lark.oapi.service.application.v6.model.P1AppStatusChangedV6;
import com.lark.oapi.service.application.v6.model.P1AppUninstalledV6;
import com.lark.oapi.service.application.v6.model.P1OrderPaidV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationAppVersionAuditV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationAppVersionPublishApplyV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationAppVersionPublishRevokeV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationCreatedV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationFeedbackCreatedV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationFeedbackUpdatedV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationVisibilityAddedV6;
import com.lark.oapi.service.application.v6.model.PatchApplicationAppVersionReq;
import com.lark.oapi.service.application.v6.model.PatchApplicationAppVersionResp;
import com.lark.oapi.service.application.v6.model.PatchApplicationFeedbackReq;
import com.lark.oapi.service.application.v6.model.PatchApplicationFeedbackResp;
import com.lark.oapi.service.application.v6.model.PatchApplicationReq;
import com.lark.oapi.service.application.v6.model.PatchApplicationResp;
import com.lark.oapi.service.application.v6.model.UnderauditlistApplicationReq;
import com.lark.oapi.service.application.v6.model.UnderauditlistApplicationResp;

public class ApplicationService {

  private final Application application;
  private final ApplicationAppUsage applicationAppUsage;
  private final ApplicationAppVersion applicationAppVersion;
  private final ApplicationFeedback applicationFeedback;
  private final ApplicationVisibility applicationVisibility;

  public ApplicationService(Config config) {
    this.application = new Application(config);
    this.applicationAppUsage = new ApplicationAppUsage(config);
    this.applicationAppVersion = new ApplicationAppVersion(config);
    this.applicationFeedback = new ApplicationFeedback(config);
    this.applicationVisibility = new ApplicationVisibility(config);
  }

  public Application application() {
    return application;
  }

  public ApplicationAppUsage applicationAppUsage() {
    return applicationAppUsage;
  }

  public ApplicationAppVersion applicationAppVersion() {
    return applicationAppVersion;
  }

  public ApplicationFeedback applicationFeedback() {
    return applicationFeedback;
  }

  public ApplicationVisibility applicationVisibility() {
    return applicationVisibility;
  }

  public static class Application {

    private final Config config;

    public Application(Config config) {
      this.config = config;
    }

    public GetApplicationResp get(GetApplicationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/:app_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetApplicationResp get(GetApplicationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/:app_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchApplicationResp patch(PatchApplicationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/application/v6/applications/:app_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchApplicationResp patch(PatchApplicationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/application/v6/applications/:app_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UnderauditlistApplicationResp underauditlist(UnderauditlistApplicationReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/underauditlist"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnderauditlistApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnderauditlistApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UnderauditlistApplicationResp underauditlist(UnderauditlistApplicationReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/underauditlist"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnderauditlistApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnderauditlistApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ApplicationAppUsage {

    private final Config config;

    public ApplicationAppUsage(Config config) {
      this.config = config;
    }

    public OverviewApplicationAppUsageResp overview(OverviewApplicationAppUsageReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/application/v6/applications/:app_id/app_usage/overview"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      OverviewApplicationAppUsageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          OverviewApplicationAppUsageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public OverviewApplicationAppUsageResp overview(OverviewApplicationAppUsageReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/application/v6/applications/:app_id/app_usage/overview"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      OverviewApplicationAppUsageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          OverviewApplicationAppUsageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ApplicationAppVersion {

    private final Config config;

    public ApplicationAppVersion(Config config) {
      this.config = config;
    }

    public GetApplicationAppVersionResp get(GetApplicationAppVersionReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/:app_id/app_versions/:version_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApplicationAppVersionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetApplicationAppVersionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetApplicationAppVersionResp get(GetApplicationAppVersionReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/:app_id/app_versions/:version_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApplicationAppVersionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetApplicationAppVersionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchApplicationAppVersionResp patch(PatchApplicationAppVersionReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/application/v6/applications/:app_id/app_versions/:version_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchApplicationAppVersionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchApplicationAppVersionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchApplicationAppVersionResp patch(PatchApplicationAppVersionReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/application/v6/applications/:app_id/app_versions/:version_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchApplicationAppVersionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchApplicationAppVersionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ApplicationFeedback {

    private final Config config;

    public ApplicationFeedback(Config config) {
      this.config = config;
    }

    public ListApplicationFeedbackResp list(ListApplicationFeedbackReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/:app_id/feedbacks"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListApplicationFeedbackResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListApplicationFeedbackResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListApplicationFeedbackResp list(ListApplicationFeedbackReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/application/v6/applications/:app_id/feedbacks"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListApplicationFeedbackResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListApplicationFeedbackResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchApplicationFeedbackResp patch(PatchApplicationFeedbackReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/application/v6/applications/:app_id/feedbacks/:feedback_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchApplicationFeedbackResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchApplicationFeedbackResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchApplicationFeedbackResp patch(PatchApplicationFeedbackReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/application/v6/applications/:app_id/feedbacks/:feedback_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchApplicationFeedbackResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchApplicationFeedbackResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ApplicationVisibility {

    private final Config config;

    public ApplicationVisibility(Config config) {
      this.config = config;
    }
  }

  public abstract static class P2ApplicationCreatedV6Handler implements
      IEventHandler<P2ApplicationCreatedV6> {

    @Override
    public P2ApplicationCreatedV6 getEvent() {
      return new P2ApplicationCreatedV6();
    }
  }

  public abstract static class P2ApplicationAppVersionAuditV6Handler implements
      IEventHandler<P2ApplicationAppVersionAuditV6> {

    @Override
    public P2ApplicationAppVersionAuditV6 getEvent() {
      return new P2ApplicationAppVersionAuditV6();
    }
  }

  public abstract static class P2ApplicationAppVersionPublishApplyV6Handler implements
      IEventHandler<P2ApplicationAppVersionPublishApplyV6> {

    @Override
    public P2ApplicationAppVersionPublishApplyV6 getEvent() {
      return new P2ApplicationAppVersionPublishApplyV6();
    }
  }

  public abstract static class P2ApplicationAppVersionPublishRevokeV6Handler implements
      IEventHandler<P2ApplicationAppVersionPublishRevokeV6> {

    @Override
    public P2ApplicationAppVersionPublishRevokeV6 getEvent() {
      return new P2ApplicationAppVersionPublishRevokeV6();
    }
  }

  public abstract static class P2ApplicationFeedbackCreatedV6Handler implements
      IEventHandler<P2ApplicationFeedbackCreatedV6> {

    @Override
    public P2ApplicationFeedbackCreatedV6 getEvent() {
      return new P2ApplicationFeedbackCreatedV6();
    }
  }

  public abstract static class P2ApplicationFeedbackUpdatedV6Handler implements
      IEventHandler<P2ApplicationFeedbackUpdatedV6> {

    @Override
    public P2ApplicationFeedbackUpdatedV6 getEvent() {
      return new P2ApplicationFeedbackUpdatedV6();
    }
  }

  public abstract static class P2ApplicationVisibilityAddedV6Handler implements
      IEventHandler<P2ApplicationVisibilityAddedV6> {

    @Override
    public P2ApplicationVisibilityAddedV6 getEvent() {
      return new P2ApplicationVisibilityAddedV6();
    }
  }

  public abstract static class P1AppOpenV6Handler implements IEventHandler<P1AppOpenV6> {

    @Override
    public P1AppOpenV6 getEvent() {
      return new P1AppOpenV6();
    }
  }

  public abstract static class P1AppStatusChangedV6Handler implements
      IEventHandler<P1AppStatusChangedV6> {

    @Override
    public P1AppStatusChangedV6 getEvent() {
      return new P1AppStatusChangedV6();
    }
  }

  public abstract static class P1OrderPaidV6Handler implements IEventHandler<P1OrderPaidV6> {

    @Override
    public P1OrderPaidV6 getEvent() {
      return new P1OrderPaidV6();
    }
  }

  public abstract static class P1AppUninstalledV6Handler implements
      IEventHandler<P1AppUninstalledV6> {

    @Override
    public P1AppUninstalledV6 getEvent() {
      return new P1AppUninstalledV6();
    }
  }
}