// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.approval.v4;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.approval.v4.model.AddSignInstanceReq;
import com.lark.oapi.service.approval.v4.model.AddSignInstanceResp;
import com.lark.oapi.service.approval.v4.model.ApproveTaskReq;
import com.lark.oapi.service.approval.v4.model.ApproveTaskResp;
import com.lark.oapi.service.approval.v4.model.CancelInstanceReq;
import com.lark.oapi.service.approval.v4.model.CancelInstanceResp;
import com.lark.oapi.service.approval.v4.model.CcInstanceReq;
import com.lark.oapi.service.approval.v4.model.CcInstanceResp;
import com.lark.oapi.service.approval.v4.model.CheckExternalInstanceReq;
import com.lark.oapi.service.approval.v4.model.CheckExternalInstanceResp;
import com.lark.oapi.service.approval.v4.model.CreateApprovalReq;
import com.lark.oapi.service.approval.v4.model.CreateApprovalResp;
import com.lark.oapi.service.approval.v4.model.CreateExternalApprovalReq;
import com.lark.oapi.service.approval.v4.model.CreateExternalApprovalResp;
import com.lark.oapi.service.approval.v4.model.CreateExternalInstanceReq;
import com.lark.oapi.service.approval.v4.model.CreateExternalInstanceResp;
import com.lark.oapi.service.approval.v4.model.CreateInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.CreateInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.CreateInstanceReq;
import com.lark.oapi.service.approval.v4.model.CreateInstanceResp;
import com.lark.oapi.service.approval.v4.model.DeleteInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.DeleteInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.GetApprovalReq;
import com.lark.oapi.service.approval.v4.model.GetApprovalResp;
import com.lark.oapi.service.approval.v4.model.GetInstanceReq;
import com.lark.oapi.service.approval.v4.model.GetInstanceResp;
import com.lark.oapi.service.approval.v4.model.ListExternalTaskReq;
import com.lark.oapi.service.approval.v4.model.ListExternalTaskResp;
import com.lark.oapi.service.approval.v4.model.ListInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.ListInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.ListInstanceReq;
import com.lark.oapi.service.approval.v4.model.ListInstanceResp;
import com.lark.oapi.service.approval.v4.model.P1LeaveApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1OutApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1RemedyApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1ShiftApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1TripApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1WorkApprovalV4;
import com.lark.oapi.service.approval.v4.model.P2ApprovalUpdatedV4;
import com.lark.oapi.service.approval.v4.model.PreviewInstanceReq;
import com.lark.oapi.service.approval.v4.model.PreviewInstanceResp;
import com.lark.oapi.service.approval.v4.model.QueryInstanceReq;
import com.lark.oapi.service.approval.v4.model.QueryInstanceResp;
import com.lark.oapi.service.approval.v4.model.QueryTaskReq;
import com.lark.oapi.service.approval.v4.model.QueryTaskResp;
import com.lark.oapi.service.approval.v4.model.RejectTaskReq;
import com.lark.oapi.service.approval.v4.model.RejectTaskResp;
import com.lark.oapi.service.approval.v4.model.RemoveInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.RemoveInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.SearchCcInstanceReq;
import com.lark.oapi.service.approval.v4.model.SearchCcInstanceResp;
import com.lark.oapi.service.approval.v4.model.SearchTaskReq;
import com.lark.oapi.service.approval.v4.model.SearchTaskResp;
import com.lark.oapi.service.approval.v4.model.SpecifiedRollbackInstanceReq;
import com.lark.oapi.service.approval.v4.model.SpecifiedRollbackInstanceResp;
import com.lark.oapi.service.approval.v4.model.SubscribeApprovalReq;
import com.lark.oapi.service.approval.v4.model.SubscribeApprovalResp;
import com.lark.oapi.service.approval.v4.model.TransferTaskReq;
import com.lark.oapi.service.approval.v4.model.TransferTaskResp;
import com.lark.oapi.service.approval.v4.model.UnsubscribeApprovalReq;
import com.lark.oapi.service.approval.v4.model.UnsubscribeApprovalResp;

public class ApprovalService {

  private final Approval approval;
  private final ExternalApproval externalApproval;
  private final ExternalInstance externalInstance;
  private final ExternalTask externalTask;
  private final Instance instance;
  private final InstanceComment instanceComment;
  private final Task task;

  public ApprovalService(Config config) {
    this.approval = new Approval(config);
    this.externalApproval = new ExternalApproval(config);
    this.externalInstance = new ExternalInstance(config);
    this.externalTask = new ExternalTask(config);
    this.instance = new Instance(config);
    this.instanceComment = new InstanceComment(config);
    this.task = new Task(config);
  }

  public Approval approval() {
    return approval;
  }

  public ExternalApproval externalApproval() {
    return externalApproval;
  }

  public ExternalInstance externalInstance() {
    return externalInstance;
  }

  public ExternalTask externalTask() {
    return externalTask;
  }

  public Instance instance() {
    return instance;
  }

  public InstanceComment instanceComment() {
    return instanceComment;
  }

  public Task task() {
    return task;
  }

  public static class Approval {

    private final Config config;

    public Approval(Config config) {
      this.config = config;
    }

    public CreateApprovalResp create(CreateApprovalReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/approvals"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateApprovalResp create(CreateApprovalReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/approvals"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetApprovalResp get(GetApprovalReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/approvals/:approval_code"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetApprovalResp get(GetApprovalReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/approvals/:approval_code"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscribeApprovalResp subscribe(SubscribeApprovalReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/approvals/:approval_code/subscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SubscribeApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscribeApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscribeApprovalResp subscribe(SubscribeApprovalReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/approvals/:approval_code/subscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SubscribeApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscribeApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UnsubscribeApprovalResp unsubscribe(UnsubscribeApprovalReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/approvals/:approval_code/unsubscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnsubscribeApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnsubscribeApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UnsubscribeApprovalResp unsubscribe(UnsubscribeApprovalReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/approvals/:approval_code/unsubscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnsubscribeApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnsubscribeApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ExternalApproval {

    private final Config config;

    public ExternalApproval(Config config) {
      this.config = config;
    }

    public CreateExternalApprovalResp create(CreateExternalApprovalReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/external_approvals"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateExternalApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateExternalApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateExternalApprovalResp create(CreateExternalApprovalReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/external_approvals"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateExternalApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateExternalApprovalResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ExternalInstance {

    private final Config config;

    public ExternalInstance(Config config) {
      this.config = config;
    }

    public CheckExternalInstanceResp check(CheckExternalInstanceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/external_instances/check"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CheckExternalInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CheckExternalInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CheckExternalInstanceResp check(CheckExternalInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/external_instances/check"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CheckExternalInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CheckExternalInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateExternalInstanceResp create(CreateExternalInstanceReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/external_instances"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateExternalInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateExternalInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateExternalInstanceResp create(CreateExternalInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/external_instances"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateExternalInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateExternalInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ExternalTask {

    private final Config config;

    public ExternalTask(Config config) {
      this.config = config;
    }

    public ListExternalTaskResp list(ListExternalTaskReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/external_tasks"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListExternalTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListExternalTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListExternalTaskResp list(ListExternalTaskReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/external_tasks"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListExternalTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListExternalTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Instance {

    private final Config config;

    public Instance(Config config) {
      this.config = config;
    }

    public AddSignInstanceResp addSign(AddSignInstanceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/add_sign"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      AddSignInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          AddSignInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public AddSignInstanceResp addSign(AddSignInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/add_sign"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      AddSignInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          AddSignInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CancelInstanceResp cancel(CancelInstanceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/cancel"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CancelInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CancelInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CancelInstanceResp cancel(CancelInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/cancel"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CancelInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CancelInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CcInstanceResp cc(CcInstanceReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/cc"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CcInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CcInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CcInstanceResp cc(CcInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/cc"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CcInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CcInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateInstanceResp create(CreateInstanceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateInstanceResp create(CreateInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetInstanceResp get(GetInstanceReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/instances/:instance_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetInstanceResp get(GetInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/instances/:instance_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListInstanceResp list(ListInstanceReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/instances"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListInstanceResp list(ListInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/instances"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PreviewInstanceResp preview(PreviewInstanceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/preview"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PreviewInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PreviewInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PreviewInstanceResp preview(PreviewInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/preview"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PreviewInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PreviewInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QueryInstanceResp query(QueryInstanceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      QueryInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QueryInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QueryInstanceResp query(QueryInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      QueryInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QueryInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchCcInstanceResp searchCc(SearchCcInstanceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/search_cc"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchCcInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SearchCcInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchCcInstanceResp searchCc(SearchCcInstanceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/search_cc"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchCcInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SearchCcInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SpecifiedRollbackInstanceResp specifiedRollback(SpecifiedRollbackInstanceReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/specified_rollback"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SpecifiedRollbackInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SpecifiedRollbackInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SpecifiedRollbackInstanceResp specifiedRollback(SpecifiedRollbackInstanceReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/specified_rollback"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SpecifiedRollbackInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SpecifiedRollbackInstanceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class InstanceComment {

    private final Config config;

    public InstanceComment(Config config) {
      this.config = config;
    }

    public CreateInstanceCommentResp create(CreateInstanceCommentReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/:instance_id/comments"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateInstanceCommentResp create(CreateInstanceCommentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/:instance_id/comments"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteInstanceCommentResp delete(DeleteInstanceCommentReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/approval/v4/instances/:instance_id/comments/:comment_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteInstanceCommentResp delete(DeleteInstanceCommentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/approval/v4/instances/:instance_id/comments/:comment_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListInstanceCommentResp list(ListInstanceCommentReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/instances/:instance_id/comments"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListInstanceCommentResp list(ListInstanceCommentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/instances/:instance_id/comments"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public RemoveInstanceCommentResp remove(RemoveInstanceCommentReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/:instance_id/comments/remove"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      RemoveInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          RemoveInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public RemoveInstanceCommentResp remove(RemoveInstanceCommentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/instances/:instance_id/comments/remove"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      RemoveInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          RemoveInstanceCommentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Task {

    private final Config config;

    public Task(Config config) {
      this.config = config;
    }

    public ApproveTaskResp approve(ApproveTaskReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/approve"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ApproveTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ApproveTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ApproveTaskResp approve(ApproveTaskReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/approve"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ApproveTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ApproveTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QueryTaskResp query(QueryTaskReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/tasks/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QueryTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QueryTaskResp query(QueryTaskReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/approval/v4/tasks/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QueryTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public RejectTaskResp reject(RejectTaskReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/reject"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      RejectTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RejectTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public RejectTaskResp reject(RejectTaskReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/reject"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      RejectTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RejectTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchTaskResp search(SearchTaskReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/search"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchTaskResp search(SearchTaskReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/search"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public TransferTaskResp transfer(TransferTaskReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/transfer"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TransferTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TransferTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public TransferTaskResp transfer(TransferTaskReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/approval/v4/tasks/transfer"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TransferTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TransferTaskResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public abstract static class P2ApprovalUpdatedV4Handler implements
      IEventHandler<P2ApprovalUpdatedV4> {

    @Override
    public P2ApprovalUpdatedV4 getEvent() {
      return new P2ApprovalUpdatedV4();
    }
  }

  public abstract static class P1LeaveApprovalV4Handler implements
      IEventHandler<P1LeaveApprovalV4> {

    @Override
    public P1LeaveApprovalV4 getEvent() {
      return new P1LeaveApprovalV4();
    }
  }

  public abstract static class P1WorkApprovalV4Handler implements IEventHandler<P1WorkApprovalV4> {

    @Override
    public P1WorkApprovalV4 getEvent() {
      return new P1WorkApprovalV4();
    }
  }

  public abstract static class P1ShiftApprovalV4Handler implements
      IEventHandler<P1ShiftApprovalV4> {

    @Override
    public P1ShiftApprovalV4 getEvent() {
      return new P1ShiftApprovalV4();
    }
  }

  public abstract static class P1RemedyApprovalV4Handler implements
      IEventHandler<P1RemedyApprovalV4> {

    @Override
    public P1RemedyApprovalV4 getEvent() {
      return new P1RemedyApprovalV4();
    }
  }

  public abstract static class P1TripApprovalV4Handler implements IEventHandler<P1TripApprovalV4> {

    @Override
    public P1TripApprovalV4 getEvent() {
      return new P1TripApprovalV4();
    }
  }


  public abstract static class P1OutApprovalV4Handler implements IEventHandler<P1OutApprovalV4> {

    @Override
    public P1OutApprovalV4 getEvent() {
      return new P1OutApprovalV4();
    }
  }
}