// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.approval.v4.model;

import com.google.gson.annotations.SerializedName;

public class ApprovalCreate {

  @SerializedName("approval_name")
  private String approvalName;
  @SerializedName("approval_code")
  private String approvalCode;
  @SerializedName("description")
  private String description;
  @SerializedName("viewers")
  private ApprovalCreateViewers[] viewers;
  @SerializedName("form")
  private ApprovalForm form;
  @SerializedName("node_list")
  private ApprovalNode[] nodeList;
  @SerializedName("settings")
  private ApprovalSetting settings;
  @SerializedName("config")
  private ApprovalConfig config;
  @SerializedName("icon")
  private Integer icon;
  @SerializedName("i18n_resources")
  private I18nResource[] i18nResources;

  // builder 开始
  public ApprovalCreate() {
  }

  public ApprovalCreate(Builder builder) {
    this.approvalName = builder.approvalName;
    this.approvalCode = builder.approvalCode;
    this.description = builder.description;
    this.viewers = builder.viewers;
    this.form = builder.form;
    this.nodeList = builder.nodeList;
    this.settings = builder.settings;
    this.config = builder.config;
    this.icon = builder.icon;
    this.i18nResources = builder.i18nResources;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getApprovalName() {
    return this.approvalName;
  }

  public void setApprovalName(String approvalName) {
    this.approvalName = approvalName;
  }

  public String getApprovalCode() {
    return this.approvalCode;
  }

  public void setApprovalCode(String approvalCode) {
    this.approvalCode = approvalCode;
  }

  public String getDescription() {
    return this.description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ApprovalCreateViewers[] getViewers() {
    return this.viewers;
  }

  public void setViewers(ApprovalCreateViewers[] viewers) {
    this.viewers = viewers;
  }

  public ApprovalForm getForm() {
    return this.form;
  }

  public void setForm(ApprovalForm form) {
    this.form = form;
  }

  public ApprovalNode[] getNodeList() {
    return this.nodeList;
  }

  public void setNodeList(ApprovalNode[] nodeList) {
    this.nodeList = nodeList;
  }

  public ApprovalSetting getSettings() {
    return this.settings;
  }

  public void setSettings(ApprovalSetting settings) {
    this.settings = settings;
  }

  public ApprovalConfig getConfig() {
    return this.config;
  }

  public void setConfig(ApprovalConfig config) {
    this.config = config;
  }

  public Integer getIcon() {
    return this.icon;
  }

  public void setIcon(Integer icon) {
    this.icon = icon;
  }

  public I18nResource[] getI18nResources() {
    return this.i18nResources;
  }

  public void setI18nResources(I18nResource[] i18nResources) {
    this.i18nResources = i18nResources;
  }

  public static class Builder {

    private String approvalName;
    private String approvalCode;
    private String description;
    private ApprovalCreateViewers[] viewers;
    private ApprovalForm form;
    private ApprovalNode[] nodeList;
    private ApprovalSetting settings;
    private ApprovalConfig config;
    private Integer icon;
    private I18nResource[] i18nResources;

    public Builder approvalName(String approvalName) {
      this.approvalName = approvalName;
      return this;
    }

    public Builder approvalCode(String approvalCode) {
      this.approvalCode = approvalCode;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder viewers(ApprovalCreateViewers[] viewers) {
      this.viewers = viewers;
      return this;
    }

    public Builder form(ApprovalForm form) {
      this.form = form;
      return this;
    }

    public Builder nodeList(ApprovalNode[] nodeList) {
      this.nodeList = nodeList;
      return this;
    }

    public Builder settings(ApprovalSetting settings) {
      this.settings = settings;
      return this;
    }

    public Builder config(ApprovalConfig config) {
      this.config = config;
      return this;
    }

    public Builder icon(Integer icon) {
      this.icon = icon;
      return this;
    }

    public Builder i18nResources(I18nResource[] i18nResources) {
      this.i18nResources = i18nResources;
      return this;
    }


    public ApprovalCreate build() {
      return new ApprovalCreate(this);
    }
  }
}
