// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.approval.v4.model;

import com.google.gson.annotations.SerializedName;

public class ApprovalNode {

  @SerializedName("id")
  private String id;
  @SerializedName("name")
  private String name;
  @SerializedName("node_type")
  private String nodeType;
  @SerializedName("approver")
  private ApprovalApproverCcer[] approver;
  @SerializedName("ccer")
  private ApprovalApproverCcer[] ccer;
  @SerializedName("privilege_field")
  private FieldGroup privilegeField;

  // builder 开始
  public ApprovalNode() {
  }

  public ApprovalNode(Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.nodeType = builder.nodeType;
    this.approver = builder.approver;
    this.ccer = builder.ccer;
    this.privilegeField = builder.privilegeField;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getId() {
    return this.id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getNodeType() {
    return this.nodeType;
  }

  public void setNodeType(String nodeType) {
    this.nodeType = nodeType;
  }

  public ApprovalApproverCcer[] getApprover() {
    return this.approver;
  }

  public void setApprover(ApprovalApproverCcer[] approver) {
    this.approver = approver;
  }

  public ApprovalApproverCcer[] getCcer() {
    return this.ccer;
  }

  public void setCcer(ApprovalApproverCcer[] ccer) {
    this.ccer = ccer;
  }

  public FieldGroup getPrivilegeField() {
    return this.privilegeField;
  }

  public void setPrivilegeField(FieldGroup privilegeField) {
    this.privilegeField = privilegeField;
  }

  public static class Builder {

    private String id;
    private String name;
    private String nodeType;
    private ApprovalApproverCcer[] approver;
    private ApprovalApproverCcer[] ccer;
    private FieldGroup privilegeField;

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nodeType(String nodeType) {
      this.nodeType = nodeType;
      return this;
    }

    public Builder nodeType(com.lark.oapi.service.approval.v4.enums.NodeTypeEnum nodeType) {
      this.nodeType = nodeType.getValue();
      return this;
    }

    public Builder approver(ApprovalApproverCcer[] approver) {
      this.approver = approver;
      return this;
    }

    public Builder ccer(ApprovalApproverCcer[] ccer) {
      this.ccer = ccer;
      return this;
    }

    public Builder privilegeField(FieldGroup privilegeField) {
      this.privilegeField = privilegeField;
      return this;
    }


    public ApprovalNode build() {
      return new ApprovalNode(this);
    }
  }
}
