// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.approval.v4.model;

import com.google.gson.annotations.SerializedName;

public class CommentRequest {

  @SerializedName("content")
  private String content;
  @SerializedName("at_info_list")
  private CommentAtInfo[] atInfoList;
  @SerializedName("parent_comment_id")
  private String parentCommentId;
  @SerializedName("comment_id")
  private String commentId;
  @SerializedName("disable_bot")
  private Boolean disableBot;
  @SerializedName("extra")
  private String extra;

  // builder 开始
  public CommentRequest() {
  }

  public CommentRequest(Builder builder) {
    this.content = builder.content;
    this.atInfoList = builder.atInfoList;
    this.parentCommentId = builder.parentCommentId;
    this.commentId = builder.commentId;
    this.disableBot = builder.disableBot;
    this.extra = builder.extra;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getContent() {
    return this.content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public CommentAtInfo[] getAtInfoList() {
    return this.atInfoList;
  }

  public void setAtInfoList(CommentAtInfo[] atInfoList) {
    this.atInfoList = atInfoList;
  }

  public String getParentCommentId() {
    return this.parentCommentId;
  }

  public void setParentCommentId(String parentCommentId) {
    this.parentCommentId = parentCommentId;
  }

  public String getCommentId() {
    return this.commentId;
  }

  public void setCommentId(String commentId) {
    this.commentId = commentId;
  }

  public Boolean getDisableBot() {
    return this.disableBot;
  }

  public void setDisableBot(Boolean disableBot) {
    this.disableBot = disableBot;
  }

  public String getExtra() {
    return this.extra;
  }

  public void setExtra(String extra) {
    this.extra = extra;
  }

  public static class Builder {

    private String content;
    private CommentAtInfo[] atInfoList;
    private String parentCommentId;
    private String commentId;
    private Boolean disableBot;
    private String extra;

    public Builder content(String content) {
      this.content = content;
      return this;
    }

    public Builder atInfoList(CommentAtInfo[] atInfoList) {
      this.atInfoList = atInfoList;
      return this;
    }

    public Builder parentCommentId(String parentCommentId) {
      this.parentCommentId = parentCommentId;
      return this;
    }

    public Builder commentId(String commentId) {
      this.commentId = commentId;
      return this;
    }

    public Builder disableBot(Boolean disableBot) {
      this.disableBot = disableBot;
      return this;
    }

    public Builder extra(String extra) {
      this.extra = extra;
      return this;
    }


    public CommentRequest build() {
      return new CommentRequest(this);
    }
  }
}
