// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.google.gson.annotations.SerializedName;

public class UserApproval {

  @SerializedName("user_id")
  private String userId;
  @SerializedName("date")
  private String date;
  @SerializedName("outs")
  private UserOut[] outs;
  @SerializedName("leaves")
  private UserLeave[] leaves;
  @SerializedName("overtime_works")
  private UserOvertimeWork[] overtimeWorks;
  @SerializedName("trips")
  private UserTrip[] trips;

  // builder 开始
  public UserApproval() {
  }

  public UserApproval(Builder builder) {
    this.userId = builder.userId;
    this.date = builder.date;
    this.outs = builder.outs;
    this.leaves = builder.leaves;
    this.overtimeWorks = builder.overtimeWorks;
    this.trips = builder.trips;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getUserId() {
    return this.userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getDate() {
    return this.date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public UserOut[] getOuts() {
    return this.outs;
  }

  public void setOuts(UserOut[] outs) {
    this.outs = outs;
  }

  public UserLeave[] getLeaves() {
    return this.leaves;
  }

  public void setLeaves(UserLeave[] leaves) {
    this.leaves = leaves;
  }

  public UserOvertimeWork[] getOvertimeWorks() {
    return this.overtimeWorks;
  }

  public void setOvertimeWorks(UserOvertimeWork[] overtimeWorks) {
    this.overtimeWorks = overtimeWorks;
  }

  public UserTrip[] getTrips() {
    return this.trips;
  }

  public void setTrips(UserTrip[] trips) {
    this.trips = trips;
  }

  public static class Builder {

    private String userId;
    private String date;
    private UserOut[] outs;
    private UserLeave[] leaves;
    private UserOvertimeWork[] overtimeWorks;
    private UserTrip[] trips;

    public Builder userId(String userId) {
      this.userId = userId;
      return this;
    }

    public Builder date(String date) {
      this.date = date;
      return this;
    }

    public Builder outs(UserOut[] outs) {
      this.outs = outs;
      return this;
    }

    public Builder leaves(UserLeave[] leaves) {
      this.leaves = leaves;
      return this;
    }

    public Builder overtimeWorks(UserOvertimeWork[] overtimeWorks) {
      this.overtimeWorks = overtimeWorks;
      return this;
    }

    public Builder trips(UserTrip[] trips) {
      this.trips = trips;
      return this;
    }


    public UserApproval build() {
      return new UserApproval(this);
    }
  }
}
