// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.baike.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.baike.v1.model.CreateDraftReq;
import com.lark.oapi.service.baike.v1.model.CreateDraftResp;
import com.lark.oapi.service.baike.v1.model.CreateEntityReq;
import com.lark.oapi.service.baike.v1.model.CreateEntityResp;
import com.lark.oapi.service.baike.v1.model.GetEntityReq;
import com.lark.oapi.service.baike.v1.model.GetEntityResp;
import com.lark.oapi.service.baike.v1.model.HighlightEntityReq;
import com.lark.oapi.service.baike.v1.model.HighlightEntityResp;
import com.lark.oapi.service.baike.v1.model.ListClassificationReq;
import com.lark.oapi.service.baike.v1.model.ListClassificationResp;
import com.lark.oapi.service.baike.v1.model.ListEntityReq;
import com.lark.oapi.service.baike.v1.model.ListEntityResp;
import com.lark.oapi.service.baike.v1.model.MatchEntityReq;
import com.lark.oapi.service.baike.v1.model.MatchEntityResp;
import com.lark.oapi.service.baike.v1.model.SearchEntityReq;
import com.lark.oapi.service.baike.v1.model.SearchEntityResp;
import com.lark.oapi.service.baike.v1.model.UpdateDraftReq;
import com.lark.oapi.service.baike.v1.model.UpdateDraftResp;
import com.lark.oapi.service.baike.v1.model.UpdateEntityReq;
import com.lark.oapi.service.baike.v1.model.UpdateEntityResp;

public class BaikeService {

  private final Classification classification;
  private final Draft draft;
  private final Entity entity;

  public BaikeService(Config config) {
    this.classification = new Classification(config);
    this.draft = new Draft(config);
    this.entity = new Entity(config);
  }

  public Classification classification() {
    return classification;
  }

  public Draft draft() {
    return draft;
  }

  public Entity entity() {
    return entity;
  }

  public static class Classification {

    private final Config config;

    public Classification(Config config) {
      this.config = config;
    }

    public ListClassificationResp list(ListClassificationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/baike/v1/classifications"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListClassificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListClassificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListClassificationResp list(ListClassificationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/baike/v1/classifications"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListClassificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListClassificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Draft {

    private final Config config;

    public Draft(Config config) {
      this.config = config;
    }

    public CreateDraftResp create(CreateDraftReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/drafts"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateDraftResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateDraftResp create(CreateDraftReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/drafts"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateDraftResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateDraftResp update(UpdateDraftReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/baike/v1/drafts/:draft_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateDraftResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateDraftResp update(UpdateDraftReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/baike/v1/drafts/:draft_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateDraftResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Entity {

    private final Config config;

    public Entity(Config config) {
      this.config = config;
    }

    public CreateEntityResp create(CreateEntityReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateEntityResp create(CreateEntityReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetEntityResp get(GetEntityReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/baike/v1/entities/:entity_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetEntityResp get(GetEntityReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/baike/v1/entities/:entity_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public HighlightEntityResp highlight(HighlightEntityReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities/highlight"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      HighlightEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          HighlightEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public HighlightEntityResp highlight(HighlightEntityReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities/highlight"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      HighlightEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          HighlightEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListEntityResp list(ListEntityReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/baike/v1/entities"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListEntityResp list(ListEntityReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/baike/v1/entities"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public MatchEntityResp match(MatchEntityReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities/match"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      MatchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MatchEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public MatchEntityResp match(MatchEntityReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities/match"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      MatchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MatchEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchEntityResp search(SearchEntityReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities/search"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      SearchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchEntityResp search(SearchEntityReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/baike/v1/entities/search"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      SearchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateEntityResp update(UpdateEntityReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/baike/v1/entities/:entity_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      UpdateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateEntityResp update(UpdateEntityReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/baike/v1/entities/:entity_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      UpdateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateEntityResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}