// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppRoleMemberReq;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppRoleMemberResp;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppTableReq;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppTableResp;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppRoleMemberReq;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppRoleMemberResp;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppTableReq;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppTableResp;
import com.lark.oapi.service.bitable.v1.model.BatchUpdateAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.BatchUpdateAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.CreateAppRoleMemberReq;
import com.lark.oapi.service.bitable.v1.model.CreateAppRoleMemberResp;
import com.lark.oapi.service.bitable.v1.model.CreateAppRoleReq;
import com.lark.oapi.service.bitable.v1.model.CreateAppRoleResp;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableFieldReq;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableFieldResp;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableReq;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableResp;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableViewReq;
import com.lark.oapi.service.bitable.v1.model.CreateAppTableViewResp;
import com.lark.oapi.service.bitable.v1.model.DeleteAppRoleMemberReq;
import com.lark.oapi.service.bitable.v1.model.DeleteAppRoleMemberResp;
import com.lark.oapi.service.bitable.v1.model.DeleteAppRoleReq;
import com.lark.oapi.service.bitable.v1.model.DeleteAppRoleResp;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableFieldReq;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableFieldResp;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableReq;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableResp;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableViewReq;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableViewResp;
import com.lark.oapi.service.bitable.v1.model.GetAppReq;
import com.lark.oapi.service.bitable.v1.model.GetAppResp;
import com.lark.oapi.service.bitable.v1.model.GetAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.GetAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.ListAppRoleMemberReq;
import com.lark.oapi.service.bitable.v1.model.ListAppRoleMemberResp;
import com.lark.oapi.service.bitable.v1.model.ListAppRoleReq;
import com.lark.oapi.service.bitable.v1.model.ListAppRoleResp;
import com.lark.oapi.service.bitable.v1.model.ListAppTableFieldReq;
import com.lark.oapi.service.bitable.v1.model.ListAppTableFieldResp;
import com.lark.oapi.service.bitable.v1.model.ListAppTableFormFieldReq;
import com.lark.oapi.service.bitable.v1.model.ListAppTableFormFieldResp;
import com.lark.oapi.service.bitable.v1.model.ListAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.ListAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.ListAppTableReq;
import com.lark.oapi.service.bitable.v1.model.ListAppTableResp;
import com.lark.oapi.service.bitable.v1.model.ListAppTableViewReq;
import com.lark.oapi.service.bitable.v1.model.ListAppTableViewResp;
import com.lark.oapi.service.bitable.v1.model.PatchAppTableFormFieldReq;
import com.lark.oapi.service.bitable.v1.model.PatchAppTableFormFieldResp;
import com.lark.oapi.service.bitable.v1.model.UpdateAppReq;
import com.lark.oapi.service.bitable.v1.model.UpdateAppResp;
import com.lark.oapi.service.bitable.v1.model.UpdateAppRoleReq;
import com.lark.oapi.service.bitable.v1.model.UpdateAppRoleResp;
import com.lark.oapi.service.bitable.v1.model.UpdateAppTableFieldReq;
import com.lark.oapi.service.bitable.v1.model.UpdateAppTableFieldResp;
import com.lark.oapi.service.bitable.v1.model.UpdateAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.UpdateAppTableRecordResp;

public class BitableService {

  private final App app;
  private final AppRole appRole;
  private final AppRoleMember appRoleMember;
  private final AppTable appTable;
  private final AppTableField appTableField;
  private final AppTableFormField appTableFormField;
  private final AppTableRecord appTableRecord;
  private final AppTableView appTableView;

  public BitableService(Config config) {
    this.app = new App(config);
    this.appRole = new AppRole(config);
    this.appRoleMember = new AppRoleMember(config);
    this.appTable = new AppTable(config);
    this.appTableField = new AppTableField(config);
    this.appTableFormField = new AppTableFormField(config);
    this.appTableRecord = new AppTableRecord(config);
    this.appTableView = new AppTableView(config);
  }

  public App app() {
    return app;
  }

  public AppRole appRole() {
    return appRole;
  }

  public AppRoleMember appRoleMember() {
    return appRoleMember;
  }

  public AppTable appTable() {
    return appTable;
  }

  public AppTableField appTableField() {
    return appTableField;
  }

  public AppTableFormField appTableFormField() {
    return appTableFormField;
  }

  public AppTableRecord appTableRecord() {
    return appTableRecord;
  }

  public AppTableView appTableView() {
    return appTableView;
  }

  public static class App {

    private final Config config;

    public App(Config config) {
      this.config = config;
    }

    public GetAppResp get(GetAppReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAppResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAppResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetAppResp get(GetAppReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAppResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAppResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppResp update(UpdateAppReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateAppResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppResp update(UpdateAppReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateAppResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AppRole {

    private final Config config;

    public AppRole(Config config) {
      this.config = config;
    }

    public CreateAppRoleResp create(CreateAppRoleReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppRoleResp create(CreateAppRoleReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppRoleResp delete(DeleteAppRoleReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppRoleResp delete(DeleteAppRoleReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppRoleResp list(ListAppRoleReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/roles"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppRoleResp list(ListAppRoleReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/roles"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppRoleResp update(UpdateAppRoleReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppRoleResp update(UpdateAppRoleReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppRoleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateAppRoleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AppRoleMember {

    private final Config config;

    public AppRoleMember(Config config) {
      this.config = config;
    }

    public BatchCreateAppRoleMemberResp batchCreate(BatchCreateAppRoleMemberReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members/batch_create"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchCreateAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchCreateAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchCreateAppRoleMemberResp batchCreate(BatchCreateAppRoleMemberReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members/batch_create"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchCreateAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchCreateAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchDeleteAppRoleMemberResp batchDelete(BatchDeleteAppRoleMemberReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members/batch_delete"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchDeleteAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchDeleteAppRoleMemberResp batchDelete(BatchDeleteAppRoleMemberReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members/batch_delete"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchDeleteAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppRoleMemberResp create(CreateAppRoleMemberReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppRoleMemberResp create(CreateAppRoleMemberReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppRoleMemberResp delete(DeleteAppRoleMemberReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members/:member_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppRoleMemberResp delete(DeleteAppRoleMemberReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members/:member_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppRoleMemberResp list(ListAppRoleMemberReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppRoleMemberResp list(ListAppRoleMemberReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/roles/:role_id/members"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppRoleMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppRoleMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AppTable {

    private final Config config;

    public AppTable(Config config) {
      this.config = config;
    }

    public BatchCreateAppTableResp batchCreate(BatchCreateAppTableReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/batch_create"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchCreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchCreateAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchCreateAppTableResp batchCreate(BatchCreateAppTableReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/batch_create"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchCreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchCreateAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchDeleteAppTableResp batchDelete(BatchDeleteAppTableReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/batch_delete"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchDeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchDeleteAppTableResp batchDelete(BatchDeleteAppTableReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/batch_delete"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchDeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppTableResp create(CreateAppTableReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppTableResp create(CreateAppTableReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableResp delete(DeleteAppTableReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableResp delete(DeleteAppTableReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableResp list(ListAppTableReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableResp list(ListAppTableReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAppTableResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AppTableField {

    private final Config config;

    public AppTableField(Config config) {
      this.config = config;
    }

    public CreateAppTableFieldResp create(CreateAppTableFieldReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppTableFieldResp create(CreateAppTableFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableFieldResp delete(DeleteAppTableFieldReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields/:field_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableFieldResp delete(DeleteAppTableFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields/:field_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableFieldResp list(ListAppTableFieldReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableFieldResp list(ListAppTableFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppTableFieldResp update(UpdateAppTableFieldReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields/:field_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppTableFieldResp update(UpdateAppTableFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields/:field_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppTableFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateAppTableFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AppTableFormField {

    private final Config config;

    public AppTableFormField(Config config) {
      this.config = config;
    }

    public ListAppTableFormFieldResp list(ListAppTableFormFieldReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/forms/:form_id/fields"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListAppTableFormFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableFormFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableFormFieldResp list(ListAppTableFormFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/forms/:form_id/fields"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListAppTableFormFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableFormFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchAppTableFormFieldResp patch(PatchAppTableFormFieldReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/forms/:form_id/fields/:field_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchAppTableFormFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchAppTableFormFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchAppTableFormFieldResp patch(PatchAppTableFormFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/forms/:form_id/fields/:field_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchAppTableFormFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchAppTableFormFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AppTableRecord {

    private final Config config;

    public AppTableRecord(Config config) {
      this.config = config;
    }

    public BatchCreateAppTableRecordResp batchCreate(BatchCreateAppTableRecordReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_create"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchCreateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchCreateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchCreateAppTableRecordResp batchCreate(BatchCreateAppTableRecordReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_create"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchCreateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchCreateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchDeleteAppTableRecordResp batchDelete(BatchDeleteAppTableRecordReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_delete"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchDeleteAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchDeleteAppTableRecordResp batchDelete(BatchDeleteAppTableRecordReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_delete"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchDeleteAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchUpdateAppTableRecordResp batchUpdate(BatchUpdateAppTableRecordReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_update"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchUpdateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchUpdateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchUpdateAppTableRecordResp batchUpdate(BatchUpdateAppTableRecordReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_update"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      BatchUpdateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchUpdateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppTableRecordResp create(CreateAppTableRecordReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppTableRecordResp create(CreateAppTableRecordReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableRecordResp delete(DeleteAppTableRecordReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableRecordResp delete(DeleteAppTableRecordReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetAppTableRecordResp get(GetAppTableRecordReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetAppTableRecordResp get(GetAppTableRecordReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableRecordResp list(ListAppTableRecordReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableRecordResp list(ListAppTableRecordReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppTableRecordResp update(UpdateAppTableRecordReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateAppTableRecordResp update(UpdateAppTableRecordReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateAppTableRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateAppTableRecordResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AppTableView {

    private final Config config;

    public AppTableView(Config config) {
      this.config = config;
    }

    public CreateAppTableViewResp create(CreateAppTableViewReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAppTableViewResp create(CreateAppTableViewReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateAppTableViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAppTableViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableViewResp delete(DeleteAppTableViewReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views/:view_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAppTableViewResp delete(DeleteAppTableViewReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views/:view_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteAppTableViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAppTableViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableViewResp list(ListAppTableViewReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAppTableViewResp list(ListAppTableViewReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAppTableViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAppTableViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}