// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.calendar.v4;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.calendar.v4.model.BatchDeleteCalendarEventAttendeeReq;
import com.lark.oapi.service.calendar.v4.model.BatchDeleteCalendarEventAttendeeResp;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarAclReq;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarAclResp;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarEventAttendeeReq;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarEventAttendeeResp;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarEventReq;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarEventResp;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarReq;
import com.lark.oapi.service.calendar.v4.model.CreateCalendarResp;
import com.lark.oapi.service.calendar.v4.model.CreateExchangeBindingReq;
import com.lark.oapi.service.calendar.v4.model.CreateExchangeBindingResp;
import com.lark.oapi.service.calendar.v4.model.CreateTimeoffEventReq;
import com.lark.oapi.service.calendar.v4.model.CreateTimeoffEventResp;
import com.lark.oapi.service.calendar.v4.model.DeleteCalendarAclReq;
import com.lark.oapi.service.calendar.v4.model.DeleteCalendarAclResp;
import com.lark.oapi.service.calendar.v4.model.DeleteCalendarEventReq;
import com.lark.oapi.service.calendar.v4.model.DeleteCalendarEventResp;
import com.lark.oapi.service.calendar.v4.model.DeleteCalendarReq;
import com.lark.oapi.service.calendar.v4.model.DeleteCalendarResp;
import com.lark.oapi.service.calendar.v4.model.DeleteExchangeBindingReq;
import com.lark.oapi.service.calendar.v4.model.DeleteExchangeBindingResp;
import com.lark.oapi.service.calendar.v4.model.DeleteTimeoffEventReq;
import com.lark.oapi.service.calendar.v4.model.DeleteTimeoffEventResp;
import com.lark.oapi.service.calendar.v4.model.GenerateCaldavConfSettingReq;
import com.lark.oapi.service.calendar.v4.model.GenerateCaldavConfSettingResp;
import com.lark.oapi.service.calendar.v4.model.GetCalendarEventReq;
import com.lark.oapi.service.calendar.v4.model.GetCalendarEventResp;
import com.lark.oapi.service.calendar.v4.model.GetCalendarReq;
import com.lark.oapi.service.calendar.v4.model.GetCalendarResp;
import com.lark.oapi.service.calendar.v4.model.GetExchangeBindingReq;
import com.lark.oapi.service.calendar.v4.model.GetExchangeBindingResp;
import com.lark.oapi.service.calendar.v4.model.ListCalendarAclReq;
import com.lark.oapi.service.calendar.v4.model.ListCalendarAclResp;
import com.lark.oapi.service.calendar.v4.model.ListCalendarEventAttendeeChatMemberReq;
import com.lark.oapi.service.calendar.v4.model.ListCalendarEventAttendeeChatMemberResp;
import com.lark.oapi.service.calendar.v4.model.ListCalendarEventAttendeeReq;
import com.lark.oapi.service.calendar.v4.model.ListCalendarEventAttendeeResp;
import com.lark.oapi.service.calendar.v4.model.ListCalendarEventReq;
import com.lark.oapi.service.calendar.v4.model.ListCalendarEventResp;
import com.lark.oapi.service.calendar.v4.model.ListCalendarReq;
import com.lark.oapi.service.calendar.v4.model.ListCalendarResp;
import com.lark.oapi.service.calendar.v4.model.ListFreebusyReq;
import com.lark.oapi.service.calendar.v4.model.ListFreebusyResp;
import com.lark.oapi.service.calendar.v4.model.P2CalendarAclCreatedV4;
import com.lark.oapi.service.calendar.v4.model.P2CalendarAclDeletedV4;
import com.lark.oapi.service.calendar.v4.model.P2CalendarChangedV4;
import com.lark.oapi.service.calendar.v4.model.P2CalendarEventChangedV4;
import com.lark.oapi.service.calendar.v4.model.PatchCalendarEventReq;
import com.lark.oapi.service.calendar.v4.model.PatchCalendarEventResp;
import com.lark.oapi.service.calendar.v4.model.PatchCalendarReq;
import com.lark.oapi.service.calendar.v4.model.PatchCalendarResp;
import com.lark.oapi.service.calendar.v4.model.PrimaryCalendarReq;
import com.lark.oapi.service.calendar.v4.model.PrimaryCalendarResp;
import com.lark.oapi.service.calendar.v4.model.SearchCalendarEventReq;
import com.lark.oapi.service.calendar.v4.model.SearchCalendarEventResp;
import com.lark.oapi.service.calendar.v4.model.SearchCalendarReq;
import com.lark.oapi.service.calendar.v4.model.SearchCalendarResp;
import com.lark.oapi.service.calendar.v4.model.SubscribeCalendarReq;
import com.lark.oapi.service.calendar.v4.model.SubscribeCalendarResp;
import com.lark.oapi.service.calendar.v4.model.SubscriptionCalendarAclReq;
import com.lark.oapi.service.calendar.v4.model.SubscriptionCalendarAclResp;
import com.lark.oapi.service.calendar.v4.model.SubscriptionCalendarEventReq;
import com.lark.oapi.service.calendar.v4.model.SubscriptionCalendarEventResp;
import com.lark.oapi.service.calendar.v4.model.SubscriptionCalendarResp;
import com.lark.oapi.service.calendar.v4.model.UnsubscribeCalendarReq;
import com.lark.oapi.service.calendar.v4.model.UnsubscribeCalendarResp;

public class CalendarService {

  private final Calendar calendar;
  private final CalendarAcl calendarAcl;
  private final CalendarEvent calendarEvent;
  private final CalendarEventAttendee calendarEventAttendee;
  private final CalendarEventAttendeeChatMember calendarEventAttendeeChatMember;
  private final ExchangeBinding exchangeBinding;
  private final Freebusy freebusy;
  private final Setting setting;
  private final TimeoffEvent timeoffEvent;

  public CalendarService(Config config) {
    this.calendar = new Calendar(config);
    this.calendarAcl = new CalendarAcl(config);
    this.calendarEvent = new CalendarEvent(config);
    this.calendarEventAttendee = new CalendarEventAttendee(config);
    this.calendarEventAttendeeChatMember = new CalendarEventAttendeeChatMember(config);
    this.exchangeBinding = new ExchangeBinding(config);
    this.freebusy = new Freebusy(config);
    this.setting = new Setting(config);
    this.timeoffEvent = new TimeoffEvent(config);
  }

  public Calendar calendar() {
    return calendar;
  }

  public CalendarAcl calendarAcl() {
    return calendarAcl;
  }

  public CalendarEvent calendarEvent() {
    return calendarEvent;
  }

  public CalendarEventAttendee calendarEventAttendee() {
    return calendarEventAttendee;
  }

  public CalendarEventAttendeeChatMember calendarEventAttendeeChatMember() {
    return calendarEventAttendeeChatMember;
  }

  public ExchangeBinding exchangeBinding() {
    return exchangeBinding;
  }

  public Freebusy freebusy() {
    return freebusy;
  }

  public Setting setting() {
    return setting;
  }

  public TimeoffEvent timeoffEvent() {
    return timeoffEvent;
  }

  public static class Calendar {

    private final Config config;

    public Calendar(Config config) {
      this.config = config;
    }

    public CreateCalendarResp create(CreateCalendarReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateCalendarResp create(CreateCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCalendarResp delete(DeleteCalendarReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/calendars/:calendar_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCalendarResp delete(DeleteCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/calendars/:calendar_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetCalendarResp get(GetCalendarReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetCalendarResp get(GetCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarResp list(ListCalendarReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarResp list(ListCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchCalendarResp patch(PatchCalendarReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/calendar/v4/calendars/:calendar_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchCalendarResp patch(PatchCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/calendar/v4/calendars/:calendar_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PrimaryCalendarResp primary(PrimaryCalendarReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/primary"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PrimaryCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PrimaryCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PrimaryCalendarResp primary(PrimaryCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/primary"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PrimaryCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PrimaryCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchCalendarResp search(SearchCalendarReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/search"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SearchCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchCalendarResp search(SearchCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/search"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SearchCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscribeCalendarResp subscribe(SubscribeCalendarReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/subscribe"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      SubscribeCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscribeCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscribeCalendarResp subscribe(SubscribeCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/subscribe"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      SubscribeCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscribeCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscriptionCalendarResp subscription(RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/subscription"
          , Sets.newHashSet(AccessTokenType.User)
          , null);

      // 反序列化
      SubscriptionCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscriptionCalendarResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }

    public SubscriptionCalendarResp subscription() throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/subscription"
          , Sets.newHashSet(AccessTokenType.User)
          , null);

      // 反序列化
      SubscriptionCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscriptionCalendarResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }

    public UnsubscribeCalendarResp unsubscribe(UnsubscribeCalendarReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/unsubscribe"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnsubscribeCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnsubscribeCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UnsubscribeCalendarResp unsubscribe(UnsubscribeCalendarReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/unsubscribe"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnsubscribeCalendarResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnsubscribeCalendarResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class CalendarAcl {

    private final Config config;

    public CalendarAcl(Config config) {
      this.config = config;
    }

    public CreateCalendarAclResp create(CreateCalendarAclReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateCalendarAclResp create(CreateCalendarAclReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCalendarAclResp delete(DeleteCalendarAclReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls/:acl_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCalendarAclResp delete(DeleteCalendarAclReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls/:acl_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarAclResp list(ListCalendarAclReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarAclResp list(ListCalendarAclReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscriptionCalendarAclResp subscription(SubscriptionCalendarAclReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls/subscription"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SubscriptionCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscriptionCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscriptionCalendarAclResp subscription(SubscriptionCalendarAclReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/acls/subscription"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SubscriptionCalendarAclResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscriptionCalendarAclResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class CalendarEvent {

    private final Config config;

    public CalendarEvent(Config config) {
      this.config = config;
    }

    public CreateCalendarEventResp create(CreateCalendarEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateCalendarEventResp create(CreateCalendarEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCalendarEventResp delete(DeleteCalendarEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCalendarEventResp delete(DeleteCalendarEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetCalendarEventResp get(GetCalendarEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetCalendarEventResp get(GetCalendarEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarEventResp list(ListCalendarEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarEventResp list(ListCalendarEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchCalendarEventResp patch(PatchCalendarEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchCalendarEventResp patch(PatchCalendarEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchCalendarEventResp search(SearchCalendarEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/search"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SearchCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SearchCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchCalendarEventResp search(SearchCalendarEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/search"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SearchCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SearchCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscriptionCalendarEventResp subscription(SubscriptionCalendarEventReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/subscription"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SubscriptionCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscriptionCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscriptionCalendarEventResp subscription(SubscriptionCalendarEventReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/subscription"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SubscriptionCalendarEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscriptionCalendarEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class CalendarEventAttendee {

    private final Config config;

    public CalendarEventAttendee(Config config) {
      this.config = config;
    }

    public BatchDeleteCalendarEventAttendeeResp batchDelete(BatchDeleteCalendarEventAttendeeReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees/batch_delete"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchDeleteCalendarEventAttendeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteCalendarEventAttendeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public BatchDeleteCalendarEventAttendeeResp batchDelete(BatchDeleteCalendarEventAttendeeReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees/batch_delete"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchDeleteCalendarEventAttendeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteCalendarEventAttendeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateCalendarEventAttendeeResp create(CreateCalendarEventAttendeeReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarEventAttendeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarEventAttendeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateCalendarEventAttendeeResp create(CreateCalendarEventAttendeeReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateCalendarEventAttendeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCalendarEventAttendeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarEventAttendeeResp list(ListCalendarEventAttendeeReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarEventAttendeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarEventAttendeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarEventAttendeeResp list(ListCalendarEventAttendeeReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarEventAttendeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarEventAttendeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class CalendarEventAttendeeChatMember {

    private final Config config;

    public CalendarEventAttendeeChatMember(Config config) {
      this.config = config;
    }

    public ListCalendarEventAttendeeChatMemberResp list(ListCalendarEventAttendeeChatMemberReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees/:attendee_id/chat_members"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarEventAttendeeChatMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarEventAttendeeChatMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCalendarEventAttendeeChatMemberResp list(ListCalendarEventAttendeeChatMemberReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/calendar/v4/calendars/:calendar_id/events/:event_id/attendees/:attendee_id/chat_members"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListCalendarEventAttendeeChatMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListCalendarEventAttendeeChatMemberResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ExchangeBinding {

    private final Config config;

    public ExchangeBinding(Config config) {
      this.config = config;
    }

    public CreateExchangeBindingResp create(CreateExchangeBindingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/exchange_bindings"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateExchangeBindingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateExchangeBindingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateExchangeBindingResp create(CreateExchangeBindingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/exchange_bindings"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateExchangeBindingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateExchangeBindingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteExchangeBindingResp delete(DeleteExchangeBindingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/exchange_bindings/:exchange_binding_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteExchangeBindingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteExchangeBindingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteExchangeBindingResp delete(DeleteExchangeBindingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/exchange_bindings/:exchange_binding_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteExchangeBindingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteExchangeBindingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetExchangeBindingResp get(GetExchangeBindingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/exchange_bindings/:exchange_binding_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetExchangeBindingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetExchangeBindingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetExchangeBindingResp get(GetExchangeBindingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/calendar/v4/exchange_bindings/:exchange_binding_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetExchangeBindingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetExchangeBindingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Freebusy {

    private final Config config;

    public Freebusy(Config config) {
      this.config = config;
    }

    public ListFreebusyResp list(ListFreebusyReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/freebusy/list"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListFreebusyResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFreebusyResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListFreebusyResp list(ListFreebusyReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/freebusy/list"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListFreebusyResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFreebusyResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Setting {

    private final Config config;

    public Setting(Config config) {
      this.config = config;
    }

    public GenerateCaldavConfSettingResp generateCaldavConf(GenerateCaldavConfSettingReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/settings/generate_caldav_conf"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GenerateCaldavConfSettingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GenerateCaldavConfSettingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GenerateCaldavConfSettingResp generateCaldavConf(GenerateCaldavConfSettingReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/settings/generate_caldav_conf"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GenerateCaldavConfSettingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GenerateCaldavConfSettingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class TimeoffEvent {

    private final Config config;

    public TimeoffEvent(Config config) {
      this.config = config;
    }

    public CreateTimeoffEventResp create(CreateTimeoffEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/timeoff_events"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateTimeoffEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateTimeoffEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateTimeoffEventResp create(CreateTimeoffEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/calendar/v4/timeoff_events"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateTimeoffEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateTimeoffEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteTimeoffEventResp delete(DeleteTimeoffEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/timeoff_events/:timeoff_event_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteTimeoffEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteTimeoffEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteTimeoffEventResp delete(DeleteTimeoffEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/calendar/v4/timeoff_events/:timeoff_event_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteTimeoffEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteTimeoffEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public abstract static class P2CalendarChangedV4Handler implements
      IEventHandler<P2CalendarChangedV4> {

    @Override
    public P2CalendarChangedV4 getEvent() {
      return new P2CalendarChangedV4();
    }
  }

  public abstract static class P2CalendarAclCreatedV4Handler implements
      IEventHandler<P2CalendarAclCreatedV4> {

    @Override
    public P2CalendarAclCreatedV4 getEvent() {
      return new P2CalendarAclCreatedV4();
    }
  }

  public abstract static class P2CalendarAclDeletedV4Handler implements
      IEventHandler<P2CalendarAclDeletedV4> {

    @Override
    public P2CalendarAclDeletedV4 getEvent() {
      return new P2CalendarAclDeletedV4();
    }
  }

  public abstract static class P2CalendarEventChangedV4Handler implements
      IEventHandler<P2CalendarEventChangedV4> {

    @Override
    public P2CalendarEventChangedV4 getEvent() {
      return new P2CalendarEventChangedV4();
    }
  }
}