// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.calendar.v4.model;

import com.google.gson.annotations.SerializedName;

public class EventSearchFilter {

  @SerializedName("start_time")
  private TimeInfo startTime;
  @SerializedName("end_time")
  private TimeInfo endTime;
  @SerializedName("user_ids")
  private String[] userIds;
  @SerializedName("room_ids")
  private String[] roomIds;
  @SerializedName("chat_ids")
  private String[] chatIds;

  // builder 开始
  public EventSearchFilter() {
  }

  public EventSearchFilter(Builder builder) {
    this.startTime = builder.startTime;
    this.endTime = builder.endTime;
    this.userIds = builder.userIds;
    this.roomIds = builder.roomIds;
    this.chatIds = builder.chatIds;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public TimeInfo getStartTime() {
    return this.startTime;
  }

  public void setStartTime(TimeInfo startTime) {
    this.startTime = startTime;
  }

  public TimeInfo getEndTime() {
    return this.endTime;
  }

  public void setEndTime(TimeInfo endTime) {
    this.endTime = endTime;
  }

  public String[] getUserIds() {
    return this.userIds;
  }

  public void setUserIds(String[] userIds) {
    this.userIds = userIds;
  }

  public String[] getRoomIds() {
    return this.roomIds;
  }

  public void setRoomIds(String[] roomIds) {
    this.roomIds = roomIds;
  }

  public String[] getChatIds() {
    return this.chatIds;
  }

  public void setChatIds(String[] chatIds) {
    this.chatIds = chatIds;
  }

  public static class Builder {

    private TimeInfo startTime;
    private TimeInfo endTime;
    private String[] userIds;
    private String[] roomIds;
    private String[] chatIds;

    public Builder startTime(TimeInfo startTime) {
      this.startTime = startTime;
      return this;
    }

    public Builder endTime(TimeInfo endTime) {
      this.endTime = endTime;
      return this;
    }

    public Builder userIds(String[] userIds) {
      this.userIds = userIds;
      return this;
    }

    public Builder roomIds(String[] roomIds) {
      this.roomIds = roomIds;
      return this;
    }

    public Builder chatIds(String[] chatIds) {
      this.chatIds = chatIds;
      return this;
    }


    public EventSearchFilter build() {
      return new EventSearchFilter(this);
    }
  }
}
