// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

public class GetDocumentBlockChildrenReq {

  @Query
  @SerializedName("document_revision_id")
  private Integer documentRevisionId;
  @Query
  @SerializedName("page_token")
  private String pageToken;
  @Query
  @SerializedName("page_size")
  private Integer pageSize;
  @Query
  @SerializedName("user_id_type")
  private String userIdType;
  @Path
  @SerializedName("document_id")
  private String documentId;
  @Path
  @SerializedName("block_id")
  private String blockId;

  // builder 开始
  public GetDocumentBlockChildrenReq() {
  }

  public GetDocumentBlockChildrenReq(Builder builder) {
    this.documentRevisionId = builder.documentRevisionId;
    this.pageToken = builder.pageToken;
    this.pageSize = builder.pageSize;
    this.userIdType = builder.userIdType;
    this.documentId = builder.documentId;
    this.blockId = builder.blockId;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Integer getDocumentRevisionId() {
    return this.documentRevisionId;
  }

  public void setDocumentRevisionId(Integer documentRevisionId) {
    this.documentRevisionId = documentRevisionId;
  }

  public String getPageToken() {
    return this.pageToken;
  }

  public void setPageToken(String pageToken) {
    this.pageToken = pageToken;
  }

  public Integer getPageSize() {
    return this.pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public String getUserIdType() {
    return this.userIdType;
  }

  public void setUserIdType(String userIdType) {
    this.userIdType = userIdType;
  }

  public String getDocumentId() {
    return this.documentId;
  }

  public void setDocumentId(String documentId) {
    this.documentId = documentId;
  }

  public String getBlockId() {
    return this.blockId;
  }

  public void setBlockId(String blockId) {
    this.blockId = blockId;
  }

  public static class Builder {

    private Integer documentRevisionId;
    private String pageToken;
    private Integer pageSize;
    private String userIdType;
    private String documentId;
    private String blockId;

    public Builder documentRevisionId(Integer documentRevisionId) {
      this.documentRevisionId = documentRevisionId;
      return this;
    }

    public Builder pageToken(String pageToken) {
      this.pageToken = pageToken;
      return this;
    }

    public Builder pageSize(Integer pageSize) {
      this.pageSize = pageSize;
      return this;
    }

    public Builder userIdType(String userIdType) {
      this.userIdType = userIdType;
      return this;
    }

    public Builder userIdType(com.lark.oapi.service.docx.v1.enums.UserIdTypeEnum userIdType) {
      this.userIdType = userIdType.getValue();
      return this;
    }

    public Builder documentId(String documentId) {
      this.documentId = documentId;
      return this;
    }

    public Builder blockId(String blockId) {
      this.blockId = blockId;
      return this;
    }

    public GetDocumentBlockChildrenReq build() {
      return new GetDocumentBlockChildrenReq(this);
    }
  }
}
