// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;

import com.google.gson.annotations.SerializedName;

public class TextElement {

  @SerializedName("text_run")
  private TextRun textRun;
  @SerializedName("mention_user")
  private MentionUser mentionUser;
  @SerializedName("mention_doc")
  private MentionDoc mentionDoc;
  @SerializedName("reminder")
  private Reminder reminder;
  @SerializedName("file")
  private InlineFile file;
  @SerializedName("undefined")
  private UndefinedElement undefined;
  @SerializedName("inline_block")
  private InlineBlock inlineBlock;
  @SerializedName("equation")
  private Equation equation;

  // builder 开始
  public TextElement() {
  }

  public TextElement(Builder builder) {
    this.textRun = builder.textRun;
    this.mentionUser = builder.mentionUser;
    this.mentionDoc = builder.mentionDoc;
    this.reminder = builder.reminder;
    this.file = builder.file;
    this.undefined = builder.undefined;
    this.inlineBlock = builder.inlineBlock;
    this.equation = builder.equation;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public TextRun getTextRun() {
    return this.textRun;
  }

  public void setTextRun(TextRun textRun) {
    this.textRun = textRun;
  }

  public MentionUser getMentionUser() {
    return this.mentionUser;
  }

  public void setMentionUser(MentionUser mentionUser) {
    this.mentionUser = mentionUser;
  }

  public MentionDoc getMentionDoc() {
    return this.mentionDoc;
  }

  public void setMentionDoc(MentionDoc mentionDoc) {
    this.mentionDoc = mentionDoc;
  }

  public Reminder getReminder() {
    return this.reminder;
  }

  public void setReminder(Reminder reminder) {
    this.reminder = reminder;
  }

  public InlineFile getFile() {
    return this.file;
  }

  public void setFile(InlineFile file) {
    this.file = file;
  }

  public UndefinedElement getUndefined() {
    return this.undefined;
  }

  public void setUndefined(UndefinedElement undefined) {
    this.undefined = undefined;
  }

  public InlineBlock getInlineBlock() {
    return this.inlineBlock;
  }

  public void setInlineBlock(InlineBlock inlineBlock) {
    this.inlineBlock = inlineBlock;
  }

  public Equation getEquation() {
    return this.equation;
  }

  public void setEquation(Equation equation) {
    this.equation = equation;
  }

  public static class Builder {

    private TextRun textRun;
    private MentionUser mentionUser;
    private MentionDoc mentionDoc;
    private Reminder reminder;
    private InlineFile file;
    private UndefinedElement undefined;
    private InlineBlock inlineBlock;
    private Equation equation;

    public Builder textRun(TextRun textRun) {
      this.textRun = textRun;
      return this;
    }

    public Builder mentionUser(MentionUser mentionUser) {
      this.mentionUser = mentionUser;
      return this;
    }

    public Builder mentionDoc(MentionDoc mentionDoc) {
      this.mentionDoc = mentionDoc;
      return this;
    }

    public Builder reminder(Reminder reminder) {
      this.reminder = reminder;
      return this;
    }

    public Builder file(InlineFile file) {
      this.file = file;
      return this;
    }

    public Builder undefined(UndefinedElement undefined) {
      this.undefined = undefined;
      return this;
    }

    public Builder inlineBlock(InlineBlock inlineBlock) {
      this.inlineBlock = inlineBlock;
      return this;
    }

    public Builder equation(Equation equation) {
      this.equation = equation;
      return this;
    }


    public TextElement build() {
      return new TextElement(this);
    }
  }
}
