// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.face_detection.v1.model;

import com.google.gson.annotations.SerializedName;

public class FaceAttribute {

  @SerializedName("gender")
  private AttributeItem gender;
  @SerializedName("age")
  private Integer age;
  @SerializedName("emotion")
  private AttributeItem emotion;
  @SerializedName("beauty")
  private Integer beauty;
  @SerializedName("pose")
  private FacePose pose;
  @SerializedName("hat")
  private AttributeItem hat;
  @SerializedName("glass")
  private AttributeItem glass;
  @SerializedName("mask")
  private AttributeItem mask;

  // builder 开始
  public FaceAttribute() {
  }

  public FaceAttribute(Builder builder) {
    this.gender = builder.gender;
    this.age = builder.age;
    this.emotion = builder.emotion;
    this.beauty = builder.beauty;
    this.pose = builder.pose;
    this.hat = builder.hat;
    this.glass = builder.glass;
    this.mask = builder.mask;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public AttributeItem getGender() {
    return this.gender;
  }

  public void setGender(AttributeItem gender) {
    this.gender = gender;
  }

  public Integer getAge() {
    return this.age;
  }

  public void setAge(Integer age) {
    this.age = age;
  }

  public AttributeItem getEmotion() {
    return this.emotion;
  }

  public void setEmotion(AttributeItem emotion) {
    this.emotion = emotion;
  }

  public Integer getBeauty() {
    return this.beauty;
  }

  public void setBeauty(Integer beauty) {
    this.beauty = beauty;
  }

  public FacePose getPose() {
    return this.pose;
  }

  public void setPose(FacePose pose) {
    this.pose = pose;
  }

  public AttributeItem getHat() {
    return this.hat;
  }

  public void setHat(AttributeItem hat) {
    this.hat = hat;
  }

  public AttributeItem getGlass() {
    return this.glass;
  }

  public void setGlass(AttributeItem glass) {
    this.glass = glass;
  }

  public AttributeItem getMask() {
    return this.mask;
  }

  public void setMask(AttributeItem mask) {
    this.mask = mask;
  }

  public static class Builder {

    private AttributeItem gender;
    private Integer age;
    private AttributeItem emotion;
    private Integer beauty;
    private FacePose pose;
    private AttributeItem hat;
    private AttributeItem glass;
    private AttributeItem mask;

    public Builder gender(AttributeItem gender) {
      this.gender = gender;
      return this;
    }

    public Builder age(Integer age) {
      this.age = age;
      return this;
    }

    public Builder emotion(AttributeItem emotion) {
      this.emotion = emotion;
      return this;
    }

    public Builder beauty(Integer beauty) {
      this.beauty = beauty;
      return this;
    }

    public Builder pose(FacePose pose) {
      this.pose = pose;
      return this;
    }

    public Builder hat(AttributeItem hat) {
      this.hat = hat;
      return this;
    }

    public Builder glass(AttributeItem glass) {
      this.glass = glass;
      return this;
    }

    public Builder mask(AttributeItem mask) {
      this.mask = mask;
      return this;
    }


    public FaceAttribute build() {
      return new FaceAttribute(this);
    }
  }
}
