// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.helpdesk.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.helpdesk.v1.model.AgentEmailAgentResp;
import com.lark.oapi.service.helpdesk.v1.model.AnswerUserQueryTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.AnswerUserQueryTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.CancelApproveNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.CancelApproveNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.CancelSendNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.CancelSendNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentScheduleReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentScheduleResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateBotMessageReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateBotMessageResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketMessageReq;
import com.lark.oapi.service.helpdesk.v1.model.CreateTicketMessageResp;
import com.lark.oapi.service.helpdesk.v1.model.CustomizedFieldsTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.CustomizedFieldsTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.DeleteTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.DeleteTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.ExecuteSendNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.ExecuteSendNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.FaqImageFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.FaqImageFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.GetAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.GetCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.GetCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.GetFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.GetFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.GetNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.GetNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentScheduleReq;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentScheduleResp;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentSkillRuleResp;
import com.lark.oapi.service.helpdesk.v1.model.ListCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.ListCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.ListFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.ListFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketMessageReq;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketMessageResp;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.P2NotificationApproveV1;
import com.lark.oapi.service.helpdesk.v1.model.P2TicketCreatedV1;
import com.lark.oapi.service.helpdesk.v1.model.P2TicketUpdatedV1;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSchedulesReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSchedulesResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSkillReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentSkillResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchCategoryReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchCategoryResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchTicketCustomizedFieldReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchTicketCustomizedFieldResp;
import com.lark.oapi.service.helpdesk.v1.model.PreviewNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.PreviewNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.SearchFaqReq;
import com.lark.oapi.service.helpdesk.v1.model.SearchFaqResp;
import com.lark.oapi.service.helpdesk.v1.model.StartServiceTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.StartServiceTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.SubmitApproveNotificationReq;
import com.lark.oapi.service.helpdesk.v1.model.SubmitApproveNotificationResp;
import com.lark.oapi.service.helpdesk.v1.model.SubscribeEventReq;
import com.lark.oapi.service.helpdesk.v1.model.SubscribeEventResp;
import com.lark.oapi.service.helpdesk.v1.model.TicketImageTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.TicketImageTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.UnsubscribeEventReq;
import com.lark.oapi.service.helpdesk.v1.model.UnsubscribeEventResp;
import com.lark.oapi.service.helpdesk.v1.model.UpdateTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.UpdateTicketResp;
import java.io.ByteArrayOutputStream;

public class HelpdeskService {

  private final Agent agent;
  private final AgentSchedules agentSchedules;
  private final AgentSchedule agentSchedule;
  private final AgentSkill agentSkill;
  private final AgentSkillRule agentSkillRule;
  private final BotMessage botMessage;
  private final Category category;
  private final Event event;
  private final Faq faq;
  private final Notification notification;
  private final Ticket ticket;
  private final TicketMessage ticketMessage;
  private final TicketCustomizedField ticketCustomizedField;

  public HelpdeskService(Config config) {
    this.agent = new Agent(config);
    this.agentSchedules = new AgentSchedules(config);
    this.agentSchedule = new AgentSchedule(config);
    this.agentSkill = new AgentSkill(config);
    this.agentSkillRule = new AgentSkillRule(config);
    this.botMessage = new BotMessage(config);
    this.category = new Category(config);
    this.event = new Event(config);
    this.faq = new Faq(config);
    this.notification = new Notification(config);
    this.ticket = new Ticket(config);
    this.ticketMessage = new TicketMessage(config);
    this.ticketCustomizedField = new TicketCustomizedField(config);
  }

  public Agent agent() {
    return agent;
  }

  public AgentSchedules agentSchedules() {
    return agentSchedules;
  }

  public AgentSchedule agentSchedule() {
    return agentSchedule;
  }

  public AgentSkill agentSkill() {
    return agentSkill;
  }

  public AgentSkillRule agentSkillRule() {
    return agentSkillRule;
  }

  public BotMessage botMessage() {
    return botMessage;
  }

  public Category category() {
    return category;
  }

  public Event event() {
    return event;
  }

  public Faq faq() {
    return faq;
  }

  public Notification notification() {
    return notification;
  }

  public Ticket ticket() {
    return ticket;
  }

  public TicketMessage ticketMessage() {
    return ticketMessage;
  }

  public TicketCustomizedField ticketCustomizedField() {
    return ticketCustomizedField;
  }

  public static class Agent {

    private final Config config;

    public Agent(Config config) {
      this.config = config;
    }

    public AgentEmailAgentResp agentEmail(RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_emails"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      AgentEmailAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          AgentEmailAgentResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }

    public AgentEmailAgentResp agentEmail() throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_emails"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      AgentEmailAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          AgentEmailAgentResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }

    public PatchAgentResp patch(PatchAgentReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/agents/:agent_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchAgentResp patch(PatchAgentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/agents/:agent_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AgentSchedules {

    private final Config config;

    public AgentSchedules(Config config) {
      this.config = config;
    }

    public DeleteAgentSchedulesResp delete(DeleteAgentSchedulesReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/agents/:agent_id/schedules"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAgentSchedulesResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAgentSchedulesResp delete(DeleteAgentSchedulesReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/agents/:agent_id/schedules"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAgentSchedulesResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetAgentSchedulesResp get(GetAgentSchedulesReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agents/:agent_id/schedules"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAgentSchedulesResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetAgentSchedulesResp get(GetAgentSchedulesReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agents/:agent_id/schedules"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAgentSchedulesResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchAgentSchedulesResp patch(PatchAgentSchedulesReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/agents/:agent_id/schedules"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchAgentSchedulesResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchAgentSchedulesResp patch(PatchAgentSchedulesReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/agents/:agent_id/schedules"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchAgentSchedulesResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchAgentSchedulesResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AgentSchedule {

    private final Config config;

    public AgentSchedule(Config config) {
      this.config = config;
    }

    public CreateAgentScheduleResp create(CreateAgentScheduleReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/agent_schedules"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateAgentScheduleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAgentScheduleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAgentScheduleResp create(CreateAgentScheduleReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/agent_schedules"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateAgentScheduleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAgentScheduleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAgentScheduleResp list(ListAgentScheduleReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_schedules"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAgentScheduleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAgentScheduleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAgentScheduleResp list(ListAgentScheduleReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_schedules"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAgentScheduleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAgentScheduleResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AgentSkill {

    private final Config config;

    public AgentSkill(Config config) {
      this.config = config;
    }

    public CreateAgentSkillResp create(CreateAgentSkillReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/agent_skills"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateAgentSkillResp create(CreateAgentSkillReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/agent_skills"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAgentSkillResp delete(DeleteAgentSkillReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteAgentSkillResp delete(DeleteAgentSkillReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetAgentSkillResp get(GetAgentSkillReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetAgentSkillResp get(GetAgentSkillReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListAgentSkillResp list(RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_skills"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      ListAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }

    public ListAgentSkillResp list() throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_skills"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      ListAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }

    public PatchAgentSkillResp patch(PatchAgentSkillReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchAgentSkillResp patch(PatchAgentSkillReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/agent_skills/:agent_skill_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchAgentSkillResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchAgentSkillResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AgentSkillRule {

    private final Config config;

    public AgentSkillRule(Config config) {
      this.config = config;
    }

    public ListAgentSkillRuleResp list(RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_skill_rules"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      ListAgentSkillRuleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAgentSkillRuleResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }

    public ListAgentSkillRuleResp list() throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/agent_skill_rules"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      ListAgentSkillRuleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAgentSkillRuleResp.class);
      resp.setRawResponse(httpResponse);
      return resp;
    }
  }

  public static class BotMessage {

    private final Config config;

    public BotMessage(Config config) {
      this.config = config;
    }

    public CreateBotMessageResp create(CreateBotMessageReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/message"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBotMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateBotMessageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateBotMessageResp create(CreateBotMessageReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/message"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBotMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateBotMessageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Category {

    private final Config config;

    public Category(Config config) {
      this.config = config;
    }

    public CreateCategoryResp create(CreateCategoryReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/categories"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateCategoryResp create(CreateCategoryReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/categories"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCategoryResp delete(DeleteCategoryReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/categories/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteCategoryResp delete(DeleteCategoryReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/categories/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetCategoryResp get(GetCategoryReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/categories/:id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetCategoryResp get(GetCategoryReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/categories/:id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCategoryResp list(ListCategoryReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/categories"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListCategoryResp list(ListCategoryReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/categories"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchCategoryResp patch(PatchCategoryReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/categories/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchCategoryResp patch(PatchCategoryReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/categories/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchCategoryResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchCategoryResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Event {

    private final Config config;

    public Event(Config config) {
      this.config = config;
    }

    public SubscribeEventResp subscribe(SubscribeEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/events/subscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscribeEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubscribeEventResp subscribe(SubscribeEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/events/subscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubscribeEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UnsubscribeEventResp unsubscribe(UnsubscribeEventReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/events/unsubscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnsubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnsubscribeEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UnsubscribeEventResp unsubscribe(UnsubscribeEventReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/events/unsubscribe"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UnsubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UnsubscribeEventResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Faq {

    private final Config config;

    public Faq(Config config) {
      this.config = config;
    }

    public CreateFaqResp create(CreateFaqReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/faqs"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateFaqResp create(CreateFaqReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/faqs"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteFaqResp delete(DeleteFaqReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/faqs/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteFaqResp delete(DeleteFaqReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/faqs/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public FaqImageFaqResp faqImage(FaqImageFaqReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }
      reqOptions.setSupportDownLoad(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs/:id/image/:image_key"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      if (httpResponse.getStatusCode() == 200) {
        FaqImageFaqResp resp = new FaqImageFaqResp();
        resp.setRawResponse(httpResponse);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(httpResponse.getBody());
        resp.setData(outputStream);
        resp.setFileName(httpResponse.getFileName());
        return resp;
      }
      // 反序列化
      FaqImageFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, FaqImageFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public FaqImageFaqResp faqImage(FaqImageFaqReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();
      reqOptions.setSupportDownLoad(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs/:id/image/:image_key"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 下载请求，返回流
      if (httpResponse.getStatusCode() == 200) {
        FaqImageFaqResp resp = new FaqImageFaqResp();
        resp.setRawResponse(httpResponse);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(httpResponse.getBody());
        resp.setData(outputStream);
        resp.setFileName(httpResponse.getFileName());
        return resp;
      }
      // 反序列化
      FaqImageFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, FaqImageFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetFaqResp get(GetFaqReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs/:id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetFaqResp get(GetFaqReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs/:id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListFaqResp list(ListFaqReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListFaqResp list(ListFaqReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchFaqResp patch(PatchFaqReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/faqs/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchFaqResp patch(PatchFaqReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/faqs/:id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchFaqResp search(SearchFaqReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs/search"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SearchFaqResp search(SearchFaqReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/faqs/search"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SearchFaqResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchFaqResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Notification {

    private final Config config;

    public Notification(Config config) {
      this.config = config;
    }

    public CancelApproveNotificationResp cancelApprove(CancelApproveNotificationReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_approve"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CancelApproveNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CancelApproveNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CancelApproveNotificationResp cancelApprove(CancelApproveNotificationReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_approve"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CancelApproveNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CancelApproveNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CancelSendNotificationResp cancelSend(CancelSendNotificationReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_send"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CancelSendNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CancelSendNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CancelSendNotificationResp cancelSend(CancelSendNotificationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/cancel_send"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CancelSendNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CancelSendNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateNotificationResp create(CreateNotificationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateNotificationResp create(CreateNotificationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ExecuteSendNotificationResp executeSend(ExecuteSendNotificationReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/execute_send"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      ExecuteSendNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ExecuteSendNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ExecuteSendNotificationResp executeSend(ExecuteSendNotificationReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/execute_send"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      ExecuteSendNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ExecuteSendNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetNotificationResp get(GetNotificationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/notifications/:notification_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetNotificationResp get(GetNotificationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/notifications/:notification_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchNotificationResp patch(PatchNotificationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/notifications/:notification_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchNotificationResp patch(PatchNotificationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/notifications/:notification_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PreviewNotificationResp preview(PreviewNotificationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/preview"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PreviewNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PreviewNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PreviewNotificationResp preview(PreviewNotificationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/preview"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PreviewNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PreviewNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubmitApproveNotificationResp submitApprove(SubmitApproveNotificationReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/submit_approve"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SubmitApproveNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubmitApproveNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public SubmitApproveNotificationResp submitApprove(SubmitApproveNotificationReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/notifications/:notification_id/submit_approve"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SubmitApproveNotificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SubmitApproveNotificationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Ticket {

    private final Config config;

    public Ticket(Config config) {
      this.config = config;
    }

    public AnswerUserQueryTicketResp answerUserQuery(AnswerUserQueryTicketReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      AnswerUserQueryTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          AnswerUserQueryTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public AnswerUserQueryTicketResp answerUserQuery(AnswerUserQueryTicketReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      AnswerUserQueryTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          AnswerUserQueryTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CustomizedFieldsTicketResp customizedFields(CustomizedFieldsTicketReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/customized_fields"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CustomizedFieldsTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CustomizedFieldsTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CustomizedFieldsTicketResp customizedFields(CustomizedFieldsTicketReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/customized_fields"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CustomizedFieldsTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CustomizedFieldsTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetTicketResp get(GetTicketReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetTicketResp get(GetTicketReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListTicketResp list(ListTicketReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/tickets"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListTicketResp list(ListTicketReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/tickets"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public StartServiceTicketResp startService(StartServiceTicketReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/start_service"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      StartServiceTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          StartServiceTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public StartServiceTicketResp startService(StartServiceTicketReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/start_service"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      StartServiceTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          StartServiceTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public TicketImageTicketResp ticketImage(TicketImageTicketReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }
      reqOptions.setSupportDownLoad(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/ticket_images"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      if (httpResponse.getStatusCode() == 200) {
        TicketImageTicketResp resp = new TicketImageTicketResp();
        resp.setRawResponse(httpResponse);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(httpResponse.getBody());
        resp.setData(outputStream);
        resp.setFileName(httpResponse.getFileName());
        return resp;
      }
      // 反序列化
      TicketImageTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TicketImageTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public TicketImageTicketResp ticketImage(TicketImageTicketReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();
      reqOptions.setSupportDownLoad(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/ticket_images"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 下载请求，返回流
      if (httpResponse.getStatusCode() == 200) {
        TicketImageTicketResp resp = new TicketImageTicketResp();
        resp.setRawResponse(httpResponse);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(httpResponse.getBody());
        resp.setData(outputStream);
        resp.setFileName(httpResponse.getFileName());
        return resp;
      }
      // 反序列化
      TicketImageTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TicketImageTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateTicketResp update(UpdateTicketReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      UpdateTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateTicketResp update(UpdateTicketReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      UpdateTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTicketResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class TicketMessage {

    private final Config config;

    public TicketMessage(Config config) {
      this.config = config;
    }

    public CreateTicketMessageResp create(CreateTicketMessageReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id/messages"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateTicketMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateTicketMessageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateTicketMessageResp create(CreateTicketMessageReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id/messages"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateTicketMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateTicketMessageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListTicketMessageResp list(ListTicketMessageReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id/messages"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListTicketMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListTicketMessageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListTicketMessageResp list(ListTicketMessageReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/tickets/:ticket_id/messages"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListTicketMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListTicketMessageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class TicketCustomizedField {

    private final Config config;

    public TicketCustomizedField(Config config) {
      this.config = config;
    }

    public CreateTicketCustomizedFieldResp create(CreateTicketCustomizedFieldReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/ticket_customized_fields"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateTicketCustomizedFieldResp create(CreateTicketCustomizedFieldReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/helpdesk/v1/ticket_customized_fields"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      CreateTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteTicketCustomizedFieldResp delete(DeleteTicketCustomizedFieldReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteTicketCustomizedFieldResp delete(DeleteTicketCustomizedFieldReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetTicketCustomizedFieldResp get(GetTicketCustomizedFieldReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetTicketCustomizedFieldResp get(GetTicketCustomizedFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListTicketCustomizedFieldResp list(ListTicketCustomizedFieldReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/ticket_customized_fields"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ListTicketCustomizedFieldResp list(ListTicketCustomizedFieldReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/helpdesk/v1/ticket_customized_fields"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchTicketCustomizedFieldResp patch(PatchTicketCustomizedFieldReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchTicketCustomizedFieldResp patch(PatchTicketCustomizedFieldReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/helpdesk/v1/ticket_customized_fields/:ticket_customized_field_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      PatchTicketCustomizedFieldResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchTicketCustomizedFieldResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public abstract static class P2NotificationApproveV1Handler implements
      IEventHandler<P2NotificationApproveV1> {

    @Override
    public P2NotificationApproveV1 getEvent() {
      return new P2NotificationApproveV1();
    }
  }

  public abstract static class P2TicketCreatedV1Handler implements
      IEventHandler<P2TicketCreatedV1> {

    @Override
    public P2TicketCreatedV1 getEvent() {
      return new P2TicketCreatedV1();
    }
  }

  public abstract static class P2TicketUpdatedV1Handler implements
      IEventHandler<P2TicketUpdatedV1> {

    @Override
    public P2TicketUpdatedV1 getEvent() {
      return new P2TicketUpdatedV1();
    }
  }
}