// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.helpdesk.v1.model;

import com.google.gson.annotations.SerializedName;

public class AgentSkill {

  @SerializedName("id")
  private String id;
  @SerializedName("helpdesk_id")
  private String helpdeskId;
  @SerializedName("name")
  private String name;
  @SerializedName("rules")
  private AgentSkillRule[] rules;
  @SerializedName("agent_ids")
  private String[] agentIds;
  @SerializedName("is_default")
  private Boolean isDefault;
  @SerializedName("agents")
  private Agent[] agents;

  // builder 开始
  public AgentSkill() {
  }

  public AgentSkill(Builder builder) {
    this.id = builder.id;
    this.helpdeskId = builder.helpdeskId;
    this.name = builder.name;
    this.rules = builder.rules;
    this.agentIds = builder.agentIds;
    this.isDefault = builder.isDefault;
    this.agents = builder.agents;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getId() {
    return this.id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getHelpdeskId() {
    return this.helpdeskId;
  }

  public void setHelpdeskId(String helpdeskId) {
    this.helpdeskId = helpdeskId;
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AgentSkillRule[] getRules() {
    return this.rules;
  }

  public void setRules(AgentSkillRule[] rules) {
    this.rules = rules;
  }

  public String[] getAgentIds() {
    return this.agentIds;
  }

  public void setAgentIds(String[] agentIds) {
    this.agentIds = agentIds;
  }

  public Boolean getIsDefault() {
    return this.isDefault;
  }

  public void setIsDefault(Boolean isDefault) {
    this.isDefault = isDefault;
  }

  public Agent[] getAgents() {
    return this.agents;
  }

  public void setAgents(Agent[] agents) {
    this.agents = agents;
  }

  public static class Builder {

    private String id;
    private String helpdeskId;
    private String name;
    private AgentSkillRule[] rules;
    private String[] agentIds;
    private Boolean isDefault;
    private Agent[] agents;

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder helpdeskId(String helpdeskId) {
      this.helpdeskId = helpdeskId;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder rules(AgentSkillRule[] rules) {
      this.rules = rules;
      return this;
    }

    public Builder agentIds(String[] agentIds) {
      this.agentIds = agentIds;
      return this;
    }

    public Builder isDefault(Boolean isDefault) {
      this.isDefault = isDefault;
      return this;
    }

    public Builder agents(Agent[] agents) {
      this.agents = agents;
      return this;
    }


    public AgentSkill build() {
      return new AgentSkill(this);
    }
  }
}
