// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.search.v2.model;

import com.google.gson.annotations.SerializedName;

public class SchemaProperty {

  @SerializedName("name")
  private String name;
  @SerializedName("type")
  private String type;
  @SerializedName("is_searchable")
  private Boolean isSearchable;
  @SerializedName("is_sortable")
  private Boolean isSortable;
  @SerializedName("is_returnable")
  private Boolean isReturnable;
  @SerializedName("sort_options")
  private SchemaSortOptions sortOptions;
  @SerializedName("type_definitions")
  private SchemaTypeDefinitions typeDefinitions;
  @SerializedName("search_options")
  private SchemaSearchOptions searchOptions;

  // builder 开始
  public SchemaProperty() {
  }

  public SchemaProperty(Builder builder) {
    this.name = builder.name;
    this.type = builder.type;
    this.isSearchable = builder.isSearchable;
    this.isSortable = builder.isSortable;
    this.isReturnable = builder.isReturnable;
    this.sortOptions = builder.sortOptions;
    this.typeDefinitions = builder.typeDefinitions;
    this.searchOptions = builder.searchOptions;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getType() {
    return this.type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Boolean getIsSearchable() {
    return this.isSearchable;
  }

  public void setIsSearchable(Boolean isSearchable) {
    this.isSearchable = isSearchable;
  }

  public Boolean getIsSortable() {
    return this.isSortable;
  }

  public void setIsSortable(Boolean isSortable) {
    this.isSortable = isSortable;
  }

  public Boolean getIsReturnable() {
    return this.isReturnable;
  }

  public void setIsReturnable(Boolean isReturnable) {
    this.isReturnable = isReturnable;
  }

  public SchemaSortOptions getSortOptions() {
    return this.sortOptions;
  }

  public void setSortOptions(SchemaSortOptions sortOptions) {
    this.sortOptions = sortOptions;
  }

  public SchemaTypeDefinitions getTypeDefinitions() {
    return this.typeDefinitions;
  }

  public void setTypeDefinitions(SchemaTypeDefinitions typeDefinitions) {
    this.typeDefinitions = typeDefinitions;
  }

  public SchemaSearchOptions getSearchOptions() {
    return this.searchOptions;
  }

  public void setSearchOptions(SchemaSearchOptions searchOptions) {
    this.searchOptions = searchOptions;
  }

  public static class Builder {

    private String name;
    private String type;
    private Boolean isSearchable;
    private Boolean isSortable;
    private Boolean isReturnable;
    private SchemaSortOptions sortOptions;
    private SchemaTypeDefinitions typeDefinitions;
    private SchemaSearchOptions searchOptions;

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder type(com.lark.oapi.service.search.v2.enums.SchemaPropertyTypeEnum type) {
      this.type = type.getValue();
      return this;
    }

    public Builder isSearchable(Boolean isSearchable) {
      this.isSearchable = isSearchable;
      return this;
    }

    public Builder isSortable(Boolean isSortable) {
      this.isSortable = isSortable;
      return this;
    }

    public Builder isReturnable(Boolean isReturnable) {
      this.isReturnable = isReturnable;
      return this;
    }

    public Builder sortOptions(SchemaSortOptions sortOptions) {
      this.sortOptions = sortOptions;
      return this;
    }

    public Builder typeDefinitions(SchemaTypeDefinitions typeDefinitions) {
      this.typeDefinitions = typeDefinitions;
      return this;
    }

    public Builder searchOptions(SchemaSearchOptions searchOptions) {
      this.searchOptions = searchOptions;
      return this;
    }


    public SchemaProperty build() {
      return new SchemaProperty(this);
    }
  }
}
