// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.sheets.v3;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetReq;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetResp;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFilterReq;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFilterResp;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFilterViewConditionReq;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFilterViewConditionResp;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFilterViewReq;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFilterViewResp;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFloatImageReq;
import com.lark.oapi.service.sheets.v3.model.CreateSpreadsheetSheetFloatImageResp;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFilterReq;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFilterResp;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFilterViewConditionReq;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFilterViewConditionResp;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFilterViewReq;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFilterViewResp;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFloatImageReq;
import com.lark.oapi.service.sheets.v3.model.DeleteSpreadsheetSheetFloatImageResp;
import com.lark.oapi.service.sheets.v3.model.FindSpreadsheetSheetReq;
import com.lark.oapi.service.sheets.v3.model.FindSpreadsheetSheetResp;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFilterReq;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFilterResp;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFilterViewConditionReq;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFilterViewConditionResp;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFilterViewReq;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFilterViewResp;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFloatImageReq;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetSheetFloatImageResp;
import com.lark.oapi.service.sheets.v3.model.MoveDimensionSpreadsheetSheetReq;
import com.lark.oapi.service.sheets.v3.model.MoveDimensionSpreadsheetSheetResp;
import com.lark.oapi.service.sheets.v3.model.PatchSpreadsheetSheetFilterViewReq;
import com.lark.oapi.service.sheets.v3.model.PatchSpreadsheetSheetFilterViewResp;
import com.lark.oapi.service.sheets.v3.model.PatchSpreadsheetSheetFloatImageReq;
import com.lark.oapi.service.sheets.v3.model.PatchSpreadsheetSheetFloatImageResp;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetFilterViewConditionReq;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetFilterViewConditionResp;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetFilterViewReq;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetFilterViewResp;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetFloatImageReq;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetFloatImageResp;
import com.lark.oapi.service.sheets.v3.model.ReplaceSpreadsheetSheetReq;
import com.lark.oapi.service.sheets.v3.model.ReplaceSpreadsheetSheetResp;
import com.lark.oapi.service.sheets.v3.model.UpdateSpreadsheetSheetFilterReq;
import com.lark.oapi.service.sheets.v3.model.UpdateSpreadsheetSheetFilterResp;
import com.lark.oapi.service.sheets.v3.model.UpdateSpreadsheetSheetFilterViewConditionReq;
import com.lark.oapi.service.sheets.v3.model.UpdateSpreadsheetSheetFilterViewConditionResp;

public class SheetsService {

  private final Spreadsheet spreadsheet;
  private final SpreadsheetSheet spreadsheetSheet;
  private final SpreadsheetSheetFilter spreadsheetSheetFilter;
  private final SpreadsheetSheetFilterView spreadsheetSheetFilterView;
  private final SpreadsheetSheetFilterViewCondition spreadsheetSheetFilterViewCondition;
  private final SpreadsheetSheetFloatImage spreadsheetSheetFloatImage;

  public SheetsService(Config config) {
    this.spreadsheet = new Spreadsheet(config);
    this.spreadsheetSheet = new SpreadsheetSheet(config);
    this.spreadsheetSheetFilter = new SpreadsheetSheetFilter(config);
    this.spreadsheetSheetFilterView = new SpreadsheetSheetFilterView(config);
    this.spreadsheetSheetFilterViewCondition = new SpreadsheetSheetFilterViewCondition(config);
    this.spreadsheetSheetFloatImage = new SpreadsheetSheetFloatImage(config);
  }

  public Spreadsheet spreadsheet() {
    return spreadsheet;
  }

  public SpreadsheetSheet spreadsheetSheet() {
    return spreadsheetSheet;
  }

  public SpreadsheetSheetFilter spreadsheetSheetFilter() {
    return spreadsheetSheetFilter;
  }

  public SpreadsheetSheetFilterView spreadsheetSheetFilterView() {
    return spreadsheetSheetFilterView;
  }

  public SpreadsheetSheetFilterViewCondition spreadsheetSheetFilterViewCondition() {
    return spreadsheetSheetFilterViewCondition;
  }

  public SpreadsheetSheetFloatImage spreadsheetSheetFloatImage() {
    return spreadsheetSheetFloatImage;
  }

  public static class Spreadsheet {

    private final Config config;

    public Spreadsheet(Config config) {
      this.config = config;
    }

    public CreateSpreadsheetResp create(CreateSpreadsheetReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateSpreadsheetResp create(CreateSpreadsheetReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class SpreadsheetSheet {

    private final Config config;

    public SpreadsheetSheet(Config config) {
      this.config = config;
    }

    public FindSpreadsheetSheetResp find(FindSpreadsheetSheetReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/find"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      FindSpreadsheetSheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          FindSpreadsheetSheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public FindSpreadsheetSheetResp find(FindSpreadsheetSheetReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/find"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      FindSpreadsheetSheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          FindSpreadsheetSheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public MoveDimensionSpreadsheetSheetResp moveDimension(MoveDimensionSpreadsheetSheetReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/move_dimension"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      MoveDimensionSpreadsheetSheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          MoveDimensionSpreadsheetSheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public MoveDimensionSpreadsheetSheetResp moveDimension(MoveDimensionSpreadsheetSheetReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/move_dimension"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      MoveDimensionSpreadsheetSheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          MoveDimensionSpreadsheetSheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ReplaceSpreadsheetSheetResp replace(ReplaceSpreadsheetSheetReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/replace"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ReplaceSpreadsheetSheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ReplaceSpreadsheetSheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public ReplaceSpreadsheetSheetResp replace(ReplaceSpreadsheetSheetReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/replace"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ReplaceSpreadsheetSheetResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ReplaceSpreadsheetSheetResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class SpreadsheetSheetFilter {

    private final Config config;

    public SpreadsheetSheetFilter(Config config) {
      this.config = config;
    }

    public CreateSpreadsheetSheetFilterResp create(CreateSpreadsheetSheetFilterReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateSpreadsheetSheetFilterResp create(CreateSpreadsheetSheetFilterReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFilterResp delete(DeleteSpreadsheetSheetFilterReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFilterResp delete(DeleteSpreadsheetSheetFilterReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFilterResp get(GetSpreadsheetSheetFilterReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFilterResp get(GetSpreadsheetSheetFilterReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateSpreadsheetSheetFilterResp update(UpdateSpreadsheetSheetFilterReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      UpdateSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateSpreadsheetSheetFilterResp update(UpdateSpreadsheetSheetFilterReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      UpdateSpreadsheetSheetFilterResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateSpreadsheetSheetFilterResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class SpreadsheetSheetFilterView {

    private final Config config;

    public SpreadsheetSheetFilterView(Config config) {
      this.config = config;
    }

    public CreateSpreadsheetSheetFilterViewResp create(CreateSpreadsheetSheetFilterViewReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateSpreadsheetSheetFilterViewResp create(CreateSpreadsheetSheetFilterViewReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFilterViewResp delete(DeleteSpreadsheetSheetFilterViewReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFilterViewResp delete(DeleteSpreadsheetSheetFilterViewReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFilterViewResp get(GetSpreadsheetSheetFilterViewReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFilterViewResp get(GetSpreadsheetSheetFilterViewReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchSpreadsheetSheetFilterViewResp patch(PatchSpreadsheetSheetFilterViewReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchSpreadsheetSheetFilterViewResp patch(PatchSpreadsheetSheetFilterViewReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchSpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchSpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QuerySpreadsheetSheetFilterViewResp query(QuerySpreadsheetSheetFilterViewReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QuerySpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QuerySpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QuerySpreadsheetSheetFilterViewResp query(QuerySpreadsheetSheetFilterViewReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QuerySpreadsheetSheetFilterViewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QuerySpreadsheetSheetFilterViewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class SpreadsheetSheetFilterViewCondition {

    private final Config config;

    public SpreadsheetSheetFilterViewCondition(Config config) {
      this.config = config;
    }

    public CreateSpreadsheetSheetFilterViewConditionResp create(
        CreateSpreadsheetSheetFilterViewConditionReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, CreateSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateSpreadsheetSheetFilterViewConditionResp create(
        CreateSpreadsheetSheetFilterViewConditionReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, CreateSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFilterViewConditionResp delete(
        DeleteSpreadsheetSheetFilterViewConditionReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/:condition_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, DeleteSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFilterViewConditionResp delete(
        DeleteSpreadsheetSheetFilterViewConditionReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/:condition_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, DeleteSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFilterViewConditionResp get(
        GetSpreadsheetSheetFilterViewConditionReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/:condition_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, GetSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFilterViewConditionResp get(
        GetSpreadsheetSheetFilterViewConditionReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/:condition_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, GetSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QuerySpreadsheetSheetFilterViewConditionResp query(
        QuerySpreadsheetSheetFilterViewConditionReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QuerySpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, QuerySpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QuerySpreadsheetSheetFilterViewConditionResp query(
        QuerySpreadsheetSheetFilterViewConditionReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QuerySpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, QuerySpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateSpreadsheetSheetFilterViewConditionResp update(
        UpdateSpreadsheetSheetFilterViewConditionReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/:condition_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      UpdateSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, UpdateSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public UpdateSpreadsheetSheetFilterViewConditionResp update(
        UpdateSpreadsheetSheetFilterViewConditionReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter_views/:filter_view_id/conditions/:condition_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      UpdateSpreadsheetSheetFilterViewConditionResp resp = UnmarshalRespUtil.unmarshalResp(
          httpResponse, UpdateSpreadsheetSheetFilterViewConditionResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class SpreadsheetSheetFloatImage {

    private final Config config;

    public SpreadsheetSheetFloatImage(Config config) {
      this.config = config;
    }

    public CreateSpreadsheetSheetFloatImageResp create(CreateSpreadsheetSheetFloatImageReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public CreateSpreadsheetSheetFloatImageResp create(CreateSpreadsheetSheetFloatImageReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFloatImageResp delete(DeleteSpreadsheetSheetFloatImageReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/:float_image_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DeleteSpreadsheetSheetFloatImageResp delete(DeleteSpreadsheetSheetFloatImageReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/:float_image_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      DeleteSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFloatImageResp get(GetSpreadsheetSheetFloatImageReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/:float_image_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public GetSpreadsheetSheetFloatImageResp get(GetSpreadsheetSheetFloatImageReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/:float_image_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchSpreadsheetSheetFloatImageResp patch(PatchSpreadsheetSheetFloatImageReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/:float_image_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public PatchSpreadsheetSheetFloatImageResp patch(PatchSpreadsheetSheetFloatImageReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/:float_image_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchSpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchSpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QuerySpreadsheetSheetFloatImageResp query(QuerySpreadsheetSheetFloatImageReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QuerySpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QuerySpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public QuerySpreadsheetSheetFloatImageResp query(QuerySpreadsheetSheetFloatImageReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          ,
          "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/query"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      QuerySpreadsheetSheetFloatImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QuerySpreadsheetSheetFloatImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}