// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v1.model;

import com.google.gson.annotations.SerializedName;

public class Task {

  @SerializedName("id")
  private String id;
  @SerializedName("summary")
  private String summary;
  @SerializedName("description")
  private String description;
  @SerializedName("complete_time")
  private String completeTime;
  @SerializedName("creator_id")
  private String creatorId;
  @SerializedName("extra")
  private String extra;
  @SerializedName("create_time")
  private String createTime;
  @SerializedName("update_time")
  private String updateTime;
  @SerializedName("due")
  private Due due;
  @SerializedName("origin")
  private Origin origin;
  @SerializedName("can_edit")
  private Boolean canEdit;
  @SerializedName("custom")
  private String custom;
  @SerializedName("source")
  private Integer source;
  @SerializedName("followers")
  private Follower[] followers;
  @SerializedName("collaborators")
  private Collaborator[] collaborators;

  // builder 开始
  public Task() {
  }

  public Task(Builder builder) {
    this.id = builder.id;
    this.summary = builder.summary;
    this.description = builder.description;
    this.completeTime = builder.completeTime;
    this.creatorId = builder.creatorId;
    this.extra = builder.extra;
    this.createTime = builder.createTime;
    this.updateTime = builder.updateTime;
    this.due = builder.due;
    this.origin = builder.origin;
    this.canEdit = builder.canEdit;
    this.custom = builder.custom;
    this.source = builder.source;
    this.followers = builder.followers;
    this.collaborators = builder.collaborators;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getId() {
    return this.id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getSummary() {
    return this.summary;
  }

  public void setSummary(String summary) {
    this.summary = summary;
  }

  public String getDescription() {
    return this.description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getCompleteTime() {
    return this.completeTime;
  }

  public void setCompleteTime(String completeTime) {
    this.completeTime = completeTime;
  }

  public String getCreatorId() {
    return this.creatorId;
  }

  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  public String getExtra() {
    return this.extra;
  }

  public void setExtra(String extra) {
    this.extra = extra;
  }

  public String getCreateTime() {
    return this.createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public String getUpdateTime() {
    return this.updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public Due getDue() {
    return this.due;
  }

  public void setDue(Due due) {
    this.due = due;
  }

  public Origin getOrigin() {
    return this.origin;
  }

  public void setOrigin(Origin origin) {
    this.origin = origin;
  }

  public Boolean getCanEdit() {
    return this.canEdit;
  }

  public void setCanEdit(Boolean canEdit) {
    this.canEdit = canEdit;
  }

  public String getCustom() {
    return this.custom;
  }

  public void setCustom(String custom) {
    this.custom = custom;
  }

  public Integer getSource() {
    return this.source;
  }

  public void setSource(Integer source) {
    this.source = source;
  }

  public Follower[] getFollowers() {
    return this.followers;
  }

  public void setFollowers(Follower[] followers) {
    this.followers = followers;
  }

  public Collaborator[] getCollaborators() {
    return this.collaborators;
  }

  public void setCollaborators(Collaborator[] collaborators) {
    this.collaborators = collaborators;
  }

  public static class Builder {

    private String id;
    private String summary;
    private String description;
    private String completeTime;
    private String creatorId;
    private String extra;
    private String createTime;
    private String updateTime;
    private Due due;
    private Origin origin;
    private Boolean canEdit;
    private String custom;
    private Integer source;
    private Follower[] followers;
    private Collaborator[] collaborators;

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder summary(String summary) {
      this.summary = summary;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder completeTime(String completeTime) {
      this.completeTime = completeTime;
      return this;
    }

    public Builder creatorId(String creatorId) {
      this.creatorId = creatorId;
      return this;
    }

    public Builder extra(String extra) {
      this.extra = extra;
      return this;
    }

    public Builder createTime(String createTime) {
      this.createTime = createTime;
      return this;
    }

    public Builder updateTime(String updateTime) {
      this.updateTime = updateTime;
      return this;
    }

    public Builder due(Due due) {
      this.due = due;
      return this;
    }

    public Builder origin(Origin origin) {
      this.origin = origin;
      return this;
    }

    public Builder canEdit(Boolean canEdit) {
      this.canEdit = canEdit;
      return this;
    }

    public Builder custom(String custom) {
      this.custom = custom;
      return this;
    }

    public Builder source(Integer source) {
      this.source = source;
      return this;
    }

    public Builder source(com.lark.oapi.service.task.v1.enums.SourceEnum source) {
      this.source = source.getValue();
      return this;
    }

    public Builder followers(Follower[] followers) {
      this.followers = followers;
      return this;
    }

    public Builder collaborators(Collaborator[] collaborators) {
      this.collaborators = collaborators;
      return this;
    }


    public Task build() {
      return new Task(this);
    }
  }
}
