// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.translation.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.translation.v1.model.DetectTextReq;
import com.lark.oapi.service.translation.v1.model.DetectTextResp;
import com.lark.oapi.service.translation.v1.model.TranslateTextReq;
import com.lark.oapi.service.translation.v1.model.TranslateTextResp;

public class TranslationService {

  private final Text text;

  public TranslationService(Config config) {
    this.text = new Text(config);
  }

  public Text text() {
    return text;
  }

  public static class Text {

    private final Config config;

    public Text(Config config) {
      this.config = config;
    }

    public DetectTextResp detect(DetectTextReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/translation/v1/text/detect"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DetectTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DetectTextResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public DetectTextResp detect(DetectTextReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/translation/v1/text/detect"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DetectTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DetectTextResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public TranslateTextResp translate(TranslateTextReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/translation/v1/text/translate"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TranslateTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TranslateTextResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    public TranslateTextResp translate(TranslateTextReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/translation/v1/text/translate"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TranslateTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TranslateTextResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}