/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.core.request;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.Config;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import com.lark.oapi.core.exception.IllegalAccessTokenTypeException;
import com.lark.oapi.core.request.FormData;
import com.lark.oapi.core.request.FormDataFile;
import com.lark.oapi.core.request.RawRequest;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.token.GlobalTokenManager;
import com.lark.oapi.core.utils.Lists;
import com.lark.oapi.core.utils.Strings;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReqTranslator {
    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public RawRequest translate(Object req, AccessTokenType accessTokenType, Config config, String httpMethod, String httpPath, RequestOptions requestOptions) throws Exception {
        ParsedReq parsedReq = this.parseInput(req, requestOptions);
        String reqUrl = this.getFullReqUrl(config.getBaseUrl(), httpPath, parsedReq.pathMap, parsedReq.queryMap);
        Map<String, List<String>> headers = requestOptions.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
        }
        headers.put("User-Agent", Lists.newArrayList("oapi-sdk-java/v2.0.0"));
        if (Strings.isNotEmpty(requestOptions.getRequestId())) {
            headers.put("Oapi-Sdk-Request-Id", Lists.newArrayList(requestOptions.getRequestId()));
        }
        if (accessTokenType != AccessTokenType.None) {
            String token = this.getToken(requestOptions.getTenantKey(), accessTokenType, config, requestOptions);
            headers.put("Authorization", Lists.newArrayList(String.format("Bearer %s", token)));
        }
        RawRequest rawRequest = new RawRequest();
        rawRequest.setBody(parsedReq.body);
        rawRequest.setReqUrl(reqUrl);
        rawRequest.setHeaders(headers);
        rawRequest.setHttpMethod(httpMethod);
        rawRequest.setConfig(config);
        rawRequest.setSupportDownLoad(requestOptions.isSupportUpload());
        rawRequest.setSupportLong2String(requestOptions.isSupportLong2String() == null ? false : requestOptions.isSupportLong2String());
        return rawRequest;
    }

    private String getToken(String tenantKey, AccessTokenType accessTokenType, Config config, RequestOptions requestOptions) throws Exception {
        switch (accessTokenType) {
            case App: {
                if (config.isDisableTokenCache()) {
                    return requestOptions.getAppAccessToken();
                }
                return GlobalTokenManager.getTokenManager().getAppAccessToken(config);
            }
            case Tenant: {
                if (config.isDisableTokenCache()) {
                    return requestOptions.getTenantAccessToken();
                }
                return GlobalTokenManager.getTokenManager().getTenantAccessToken(config, tenantKey);
            }
            case User: {
                return requestOptions.getUserAccessToken();
            }
        }
        throw new IllegalAccessTokenTypeException();
    }

    private ParsedReq parseInput(Object req, RequestOptions requestOptions) throws IllegalAccessException {
        ParsedReq parsedReq = new ParsedReq();
        if (req == null) {
            return parsedReq;
        }
        Field[] fields = req.getClass().getDeclaredFields();
        boolean hasHttpAnnotation = false;
        if (fields != null) {
            for (Field field : fields) {
                Query query;
                Path path;
                field.setAccessible(true);
                Body body = field.getAnnotation(Body.class);
                if (body != null) {
                    hasHttpAnnotation = true;
                    parsedReq.body = field.get(req);
                }
                if ((path = field.getAnnotation(Path.class)) != null) {
                    hasHttpAnnotation = true;
                    SerializedName serializedName = field.getAnnotation(SerializedName.class);
                    if (null != field.get(req)) {
                        parsedReq.pathMap.put(serializedName.value(), field.get(req));
                    }
                }
                if ((query = field.getAnnotation(Query.class)) == null) continue;
                hasHttpAnnotation = true;
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (null == field.get(req)) continue;
                parsedReq.queryMap.put(serializedName.value(), field.get(req));
            }
        }
        if (!hasHttpAnnotation) {
            parsedReq.body = req;
        }
        if (parsedReq.body != null && requestOptions.isSupportUpload()) {
            parsedReq.body = this.buildFormData(parsedReq.body);
        }
        return parsedReq;
    }

    private FormData buildFormData(Object body) throws IllegalAccessException {
        FormData formData = new FormData();
        Field[] fields = body.getClass().getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                SerializedName serializedName;
                field.setAccessible(true);
                if (field.getType() == File.class) {
                    serializedName = field.getAnnotation(SerializedName.class);
                    FormDataFile formDataFile = new FormDataFile();
                    formDataFile.setFile((File)field.get(body));
                    formDataFile.setFieldName(serializedName.value().trim());
                    formData.addFile(serializedName.value().trim(), formDataFile);
                    continue;
                }
                serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName == null || field.get(body) == null) continue;
                formData.addField(serializedName.value().trim(), field.get(body));
            }
        }
        return formData;
    }

    private String getFullReqUrl(String domain, String httpPath, Map<String, Object> pathMap, Map<String, Object> queryMap) {
        String reqUrl = this.joinPathParam(httpPath, pathMap);
        if (!reqUrl.startsWith("http")) {
            reqUrl = domain + reqUrl;
        }
        if (queryMap.size() > 0) {
            reqUrl = reqUrl + "?" + this.buildQuery(queryMap);
        }
        return reqUrl;
    }

    private String joinPathParam(String path, Map<String, Object> pathMap) {
        if (pathMap.size() == 0) {
            return path;
        }
        String tmpPath = path;
        StringBuilder newPath = new StringBuilder();
        while (true) {
            String varName;
            int i;
            if ((i = tmpPath.indexOf(":")) == -1) {
                newPath.append(tmpPath);
                break;
            }
            newPath.append(tmpPath, 0, i);
            String subPath = tmpPath.substring(i);
            int j = subPath.indexOf("/");
            if (j == -1) {
                j = subPath.length();
            }
            if ((varName = subPath.substring(1, j)).equals("")) {
                newPath.append(subPath.substring(0, j));
            } else {
                Object v = pathMap.get(varName);
                if (v == null) {
                    throw new IllegalArgumentException("path:" + path + ", param name:" + varName + " not found value");
                }
                newPath.append(v.toString());
            }
            if (j == subPath.length()) break;
            tmpPath = subPath.substring(j);
        }
        return newPath.toString();
    }

    private String buildQuery(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : entries) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof List) {
                for (Object o : (List)value) {
                    list.add(name + "=" + ReqTranslator.encode(o.toString()));
                }
                continue;
            }
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                for (int i = 0; i < len; ++i) {
                    list.add(name + "=" + ReqTranslator.encode(Array.get(value, i).toString()));
                }
                continue;
            }
            list.add(name + "=" + ReqTranslator.encode(value.toString()));
        }
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        for (String s : list) {
            query.append(s).append("&");
        }
        return query.deleteCharAt(query.length() - 1).toString();
    }

    private class ParsedReq {
        private HashMap<String, Object> pathMap = new HashMap();
        private HashMap<String, Object> queryMap = new HashMap();
        private Object body;

        private ParsedReq() {
        }
    }
}

