/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.admin.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.admin.v1.model.ListAdminDeptStatReq;
import com.lark.oapi.service.admin.v1.model.ListAdminDeptStatResp;
import com.lark.oapi.service.admin.v1.model.ListAdminUserStatReq;
import com.lark.oapi.service.admin.v1.model.ListAdminUserStatResp;
import com.lark.oapi.service.admin.v1.model.ResetPasswordReq;
import com.lark.oapi.service.admin.v1.model.ResetPasswordResp;

public class AdminService {
    private final AdminDeptStat adminDeptStat;
    private final AdminUserStat adminUserStat;
    private final Password password;

    public AdminService(Config config) {
        this.adminDeptStat = new AdminDeptStat(config);
        this.adminUserStat = new AdminUserStat(config);
        this.password = new Password(config);
    }

    public AdminDeptStat adminDeptStat() {
        return this.adminDeptStat;
    }

    public AdminUserStat adminUserStat() {
        return this.adminUserStat;
    }

    public Password password() {
        return this.password;
    }

    public static class Password {
        private final Config config;

        public Password(Config config) {
            this.config = config;
        }

        public ResetPasswordResp reset(ResetPasswordReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/admin/v1/password/reset", Sets.newHashSet(AccessTokenType.Tenant), req);
            ResetPasswordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ResetPasswordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ResetPasswordResp reset(ResetPasswordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/admin/v1/password/reset", Sets.newHashSet(AccessTokenType.Tenant), req);
            ResetPasswordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ResetPasswordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AdminUserStat {
        private final Config config;

        public AdminUserStat(Config config) {
            this.config = config;
        }

        public ListAdminUserStatResp list(ListAdminUserStatReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/admin/v1/admin_user_stats", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListAdminUserStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAdminUserStatResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListAdminUserStatResp list(ListAdminUserStatReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/admin/v1/admin_user_stats", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListAdminUserStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAdminUserStatResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AdminDeptStat {
        private final Config config;

        public AdminDeptStat(Config config) {
            this.config = config;
        }

        public ListAdminDeptStatResp list(ListAdminDeptStatReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/admin/v1/admin_dept_stats", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListAdminDeptStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAdminDeptStatResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListAdminDeptStatResp list(ListAdminDeptStatReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/admin/v1/admin_dept_stats", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListAdminDeptStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAdminDeptStatResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

