/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.baike.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.baike.v1.model.CreateDraftReq;
import com.lark.oapi.service.baike.v1.model.CreateDraftResp;
import com.lark.oapi.service.baike.v1.model.CreateEntityReq;
import com.lark.oapi.service.baike.v1.model.CreateEntityResp;
import com.lark.oapi.service.baike.v1.model.GetEntityReq;
import com.lark.oapi.service.baike.v1.model.GetEntityResp;
import com.lark.oapi.service.baike.v1.model.HighlightEntityReq;
import com.lark.oapi.service.baike.v1.model.HighlightEntityResp;
import com.lark.oapi.service.baike.v1.model.ListClassificationReq;
import com.lark.oapi.service.baike.v1.model.ListClassificationResp;
import com.lark.oapi.service.baike.v1.model.ListEntityReq;
import com.lark.oapi.service.baike.v1.model.ListEntityResp;
import com.lark.oapi.service.baike.v1.model.MatchEntityReq;
import com.lark.oapi.service.baike.v1.model.MatchEntityResp;
import com.lark.oapi.service.baike.v1.model.SearchEntityReq;
import com.lark.oapi.service.baike.v1.model.SearchEntityResp;
import com.lark.oapi.service.baike.v1.model.UpdateDraftReq;
import com.lark.oapi.service.baike.v1.model.UpdateDraftResp;
import com.lark.oapi.service.baike.v1.model.UpdateEntityReq;
import com.lark.oapi.service.baike.v1.model.UpdateEntityResp;

public class BaikeService {
    private final Classification classification;
    private final Draft draft;
    private final Entity entity;

    public BaikeService(Config config) {
        this.classification = new Classification(config);
        this.draft = new Draft(config);
        this.entity = new Entity(config);
    }

    public Classification classification() {
        return this.classification;
    }

    public Draft draft() {
        return this.draft;
    }

    public Entity entity() {
        return this.entity;
    }

    public static class Entity {
        private final Config config;

        public Entity(Config config) {
            this.config = config;
        }

        public CreateEntityResp create(CreateEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateEntityResp create(CreateEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetEntityResp get(GetEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/entities/:entity_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetEntityResp get(GetEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/entities/:entity_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public HighlightEntityResp highlight(HighlightEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities/highlight", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            HighlightEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, HighlightEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public HighlightEntityResp highlight(HighlightEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities/highlight", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            HighlightEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, HighlightEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListEntityResp list(ListEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/entities", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListEntityResp list(ListEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/entities", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MatchEntityResp match(MatchEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities/match", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            MatchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MatchEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MatchEntityResp match(MatchEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities/match", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            MatchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MatchEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchEntityResp search(SearchEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities/search", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            SearchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchEntityResp search(SearchEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/entities/search", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            SearchEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateEntityResp update(UpdateEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/baike/v1/entities/:entity_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateEntityResp update(UpdateEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/baike/v1/entities/:entity_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Draft {
        private final Config config;

        public Draft(Config config) {
            this.config = config;
        }

        public CreateDraftResp create(CreateDraftReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/drafts", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateDraftResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateDraftResp create(CreateDraftReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/drafts", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateDraftResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateDraftResp update(UpdateDraftReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/baike/v1/drafts/:draft_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UpdateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateDraftResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateDraftResp update(UpdateDraftReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/baike/v1/drafts/:draft_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UpdateDraftResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateDraftResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Classification {
        private final Config config;

        public Classification(Config config) {
            this.config = config;
        }

        public ListClassificationResp list(ListClassificationReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/classifications", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListClassificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListClassificationResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListClassificationResp list(ListClassificationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/classifications", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListClassificationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListClassificationResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

