/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.application.v6;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.application.v6.model.GetApplicationAppVersionReq;
import com.lark.oapi.service.application.v6.model.GetApplicationAppVersionResp;
import com.lark.oapi.service.application.v6.model.GetApplicationReq;
import com.lark.oapi.service.application.v6.model.GetApplicationResp;
import com.lark.oapi.service.application.v6.model.ListAppRecommendRuleReq;
import com.lark.oapi.service.application.v6.model.ListAppRecommendRuleResp;
import com.lark.oapi.service.application.v6.model.ListApplicationAppVersionReq;
import com.lark.oapi.service.application.v6.model.ListApplicationAppVersionResp;
import com.lark.oapi.service.application.v6.model.ListApplicationFeedbackReq;
import com.lark.oapi.service.application.v6.model.ListApplicationFeedbackResp;
import com.lark.oapi.service.application.v6.model.OverviewApplicationAppUsageReq;
import com.lark.oapi.service.application.v6.model.OverviewApplicationAppUsageResp;
import com.lark.oapi.service.application.v6.model.P1AppOpenV6;
import com.lark.oapi.service.application.v6.model.P1AppStatusChangedV6;
import com.lark.oapi.service.application.v6.model.P1AppUninstalledV6;
import com.lark.oapi.service.application.v6.model.P1OrderPaidV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationAppVersionAuditV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationAppVersionPublishApplyV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationAppVersionPublishRevokeV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationCreatedV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationFeedbackCreatedV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationFeedbackUpdatedV6;
import com.lark.oapi.service.application.v6.model.P2ApplicationVisibilityAddedV6;
import com.lark.oapi.service.application.v6.model.PatchApplicationAppVersionReq;
import com.lark.oapi.service.application.v6.model.PatchApplicationAppVersionResp;
import com.lark.oapi.service.application.v6.model.PatchApplicationFeedbackReq;
import com.lark.oapi.service.application.v6.model.PatchApplicationFeedbackResp;
import com.lark.oapi.service.application.v6.model.PatchApplicationReq;
import com.lark.oapi.service.application.v6.model.PatchApplicationResp;
import com.lark.oapi.service.application.v6.model.UnderauditlistApplicationReq;
import com.lark.oapi.service.application.v6.model.UnderauditlistApplicationResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationService.class);
    private final AppRecommendRule appRecommendRule;
    private final Application application;
    private final ApplicationAppUsage applicationAppUsage;
    private final ApplicationAppVersion applicationAppVersion;
    private final ApplicationFeedback applicationFeedback;
    private final ApplicationVisibility applicationVisibility;

    public ApplicationService(Config config) {
        this.appRecommendRule = new AppRecommendRule(config);
        this.application = new Application(config);
        this.applicationAppUsage = new ApplicationAppUsage(config);
        this.applicationAppVersion = new ApplicationAppVersion(config);
        this.applicationFeedback = new ApplicationFeedback(config);
        this.applicationVisibility = new ApplicationVisibility(config);
    }

    public AppRecommendRule appRecommendRule() {
        return this.appRecommendRule;
    }

    public Application application() {
        return this.application;
    }

    public ApplicationAppUsage applicationAppUsage() {
        return this.applicationAppUsage;
    }

    public ApplicationAppVersion applicationAppVersion() {
        return this.applicationAppVersion;
    }

    public ApplicationFeedback applicationFeedback() {
        return this.applicationFeedback;
    }

    public ApplicationVisibility applicationVisibility() {
        return this.applicationVisibility;
    }

    public static class AppRecommendRule {
        private final Config config;

        public AppRecommendRule(Config config) {
            this.config = config;
        }

        public ListAppRecommendRuleResp list(ListAppRecommendRuleReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListAppRecommendRuleResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/app_recommend_rules", Sets.newHashSet(AccessTokenType.Tenant), req), ListAppRecommendRuleResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/app_recommend_rules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListAppRecommendRuleResp list(ListAppRecommendRuleReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/app_recommend_rules", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListAppRecommendRuleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAppRecommendRuleResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/app_recommend_rules", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Application {
        private final Config config;

        public Application(Config config) {
            this.config = config;
        }

        public GetApplicationResp get(GetApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetApplicationResp get(GetApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchApplicationResp patch(PatchApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/application/v6/applications/:app_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchApplicationResp patch(PatchApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/application/v6/applications/:app_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UnderauditlistApplicationResp underauditlist(UnderauditlistApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            UnderauditlistApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/underauditlist", Sets.newHashSet(AccessTokenType.Tenant), req), UnderauditlistApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/underauditlist", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UnderauditlistApplicationResp underauditlist(UnderauditlistApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/underauditlist", Sets.newHashSet(AccessTokenType.Tenant), req);
            UnderauditlistApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UnderauditlistApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/underauditlist", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ApplicationAppUsage {
        private final Config config;

        public ApplicationAppUsage(Config config) {
            this.config = config;
        }

        public OverviewApplicationAppUsageResp overview(OverviewApplicationAppUsageReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            OverviewApplicationAppUsageResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/application/v6/applications/:app_id/app_usage/overview", Sets.newHashSet(AccessTokenType.Tenant), req), OverviewApplicationAppUsageResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_usage/overview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public OverviewApplicationAppUsageResp overview(OverviewApplicationAppUsageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/application/v6/applications/:app_id/app_usage/overview", Sets.newHashSet(AccessTokenType.Tenant), req);
            OverviewApplicationAppUsageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, OverviewApplicationAppUsageResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_usage/overview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ApplicationAppVersion {
        private final Config config;

        public ApplicationAppVersion(Config config) {
            this.config = config;
        }

        public GetApplicationAppVersionResp get(GetApplicationAppVersionReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetApplicationAppVersionResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetApplicationAppVersionResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetApplicationAppVersionResp get(GetApplicationAppVersionReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetApplicationAppVersionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetApplicationAppVersionResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListApplicationAppVersionResp list(ListApplicationAppVersionReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListApplicationAppVersionResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id/app_versions", Sets.newHashSet(AccessTokenType.Tenant), req), ListApplicationAppVersionResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_versions", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListApplicationAppVersionResp list(ListApplicationAppVersionReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id/app_versions", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListApplicationAppVersionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListApplicationAppVersionResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_versions", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchApplicationAppVersionResp patch(PatchApplicationAppVersionReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchApplicationAppVersionResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchApplicationAppVersionResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchApplicationAppVersionResp patch(PatchApplicationAppVersionReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchApplicationAppVersionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchApplicationAppVersionResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/app_versions/:version_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ApplicationFeedback {
        private final Config config;

        public ApplicationFeedback(Config config) {
            this.config = config;
        }

        public ListApplicationFeedbackResp list(ListApplicationFeedbackReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListApplicationFeedbackResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id/feedbacks", Sets.newHashSet(AccessTokenType.Tenant), req), ListApplicationFeedbackResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/feedbacks", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListApplicationFeedbackResp list(ListApplicationFeedbackReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/application/v6/applications/:app_id/feedbacks", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListApplicationFeedbackResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListApplicationFeedbackResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/feedbacks", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchApplicationFeedbackResp patch(PatchApplicationFeedbackReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchApplicationFeedbackResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/application/v6/applications/:app_id/feedbacks/:feedback_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchApplicationFeedbackResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/feedbacks/:feedback_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchApplicationFeedbackResp patch(PatchApplicationFeedbackReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/application/v6/applications/:app_id/feedbacks/:feedback_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchApplicationFeedbackResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchApplicationFeedbackResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/application/v6/applications/:app_id/feedbacks/:feedback_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ApplicationVisibility {
        private final Config config;

        public ApplicationVisibility(Config config) {
            this.config = config;
        }
    }

    public static abstract class P1AppUninstalledV6Handler
    implements IEventHandler<P1AppUninstalledV6> {
        @Override
        public P1AppUninstalledV6 getEvent() {
            return new P1AppUninstalledV6();
        }
    }

    public static abstract class P1OrderPaidV6Handler
    implements IEventHandler<P1OrderPaidV6> {
        @Override
        public P1OrderPaidV6 getEvent() {
            return new P1OrderPaidV6();
        }
    }

    public static abstract class P1AppStatusChangedV6Handler
    implements IEventHandler<P1AppStatusChangedV6> {
        @Override
        public P1AppStatusChangedV6 getEvent() {
            return new P1AppStatusChangedV6();
        }
    }

    public static abstract class P1AppOpenV6Handler
    implements IEventHandler<P1AppOpenV6> {
        @Override
        public P1AppOpenV6 getEvent() {
            return new P1AppOpenV6();
        }
    }

    public static abstract class P2ApplicationVisibilityAddedV6Handler
    implements IEventHandler<P2ApplicationVisibilityAddedV6> {
        @Override
        public P2ApplicationVisibilityAddedV6 getEvent() {
            return new P2ApplicationVisibilityAddedV6();
        }
    }

    public static abstract class P2ApplicationFeedbackUpdatedV6Handler
    implements IEventHandler<P2ApplicationFeedbackUpdatedV6> {
        @Override
        public P2ApplicationFeedbackUpdatedV6 getEvent() {
            return new P2ApplicationFeedbackUpdatedV6();
        }
    }

    public static abstract class P2ApplicationFeedbackCreatedV6Handler
    implements IEventHandler<P2ApplicationFeedbackCreatedV6> {
        @Override
        public P2ApplicationFeedbackCreatedV6 getEvent() {
            return new P2ApplicationFeedbackCreatedV6();
        }
    }

    public static abstract class P2ApplicationAppVersionPublishRevokeV6Handler
    implements IEventHandler<P2ApplicationAppVersionPublishRevokeV6> {
        @Override
        public P2ApplicationAppVersionPublishRevokeV6 getEvent() {
            return new P2ApplicationAppVersionPublishRevokeV6();
        }
    }

    public static abstract class P2ApplicationAppVersionPublishApplyV6Handler
    implements IEventHandler<P2ApplicationAppVersionPublishApplyV6> {
        @Override
        public P2ApplicationAppVersionPublishApplyV6 getEvent() {
            return new P2ApplicationAppVersionPublishApplyV6();
        }
    }

    public static abstract class P2ApplicationAppVersionAuditV6Handler
    implements IEventHandler<P2ApplicationAppVersionAuditV6> {
        @Override
        public P2ApplicationAppVersionAuditV6 getEvent() {
            return new P2ApplicationAppVersionAuditV6();
        }
    }

    public static abstract class P2ApplicationCreatedV6Handler
    implements IEventHandler<P2ApplicationCreatedV6> {
        @Override
        public P2ApplicationCreatedV6 getEvent() {
            return new P2ApplicationCreatedV6();
        }
    }
}

