// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.approval.v4.model;

import com.google.gson.annotations.SerializedName;

public class TaskSearchNode {
    /**
     * 审批任务审批人 id
     * <p> 示例值：lwiu098wj
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 审批任务开始时间
     * <p> 示例值：1547654251506
     */
    @SerializedName("start_time")
    private String startTime;
    /**
     * 审批任务结束时间
     * <p> 示例值：1547654251506
     */
    @SerializedName("end_time")
    private String endTime;
    /**
     * 审批任务状态
     * <p> 示例值：pending
     */
    @SerializedName("status")
    private String status;
    /**
     * 审批任务名称（只有第三方审批有）
     * <p> 示例值：test
     */
    @SerializedName("title")
    private String title;
    /**
     * 审批任务扩展字段，string型json
     * <p> 示例值：{}
     */
    @SerializedName("extra")
    private String extra;
    /**
     * 审批任务链接（只有第三方审批有）
     * <p> 示例值：
     */
    @SerializedName("link")
    private InstanceSearchLink link;
    /**
     * 任务id
     * <p> 示例值：7110153401253494803
     */
    @SerializedName("task_id")
    private String taskId;
    /**
     * 审批任务更新时间
     * <p> 示例值：1547654251506
     */
    @SerializedName("update_time")
    private String updateTime;

    // builder 开始
    public TaskSearchNode() {
    }

    public TaskSearchNode(Builder builder) {
        /**
         * 审批任务审批人 id
         * <p> 示例值：lwiu098wj
         */
        this.userId = builder.userId;
        /**
         * 审批任务开始时间
         * <p> 示例值：1547654251506
         */
        this.startTime = builder.startTime;
        /**
         * 审批任务结束时间
         * <p> 示例值：1547654251506
         */
        this.endTime = builder.endTime;
        /**
         * 审批任务状态
         * <p> 示例值：pending
         */
        this.status = builder.status;
        /**
         * 审批任务名称（只有第三方审批有）
         * <p> 示例值：test
         */
        this.title = builder.title;
        /**
         * 审批任务扩展字段，string型json
         * <p> 示例值：{}
         */
        this.extra = builder.extra;
        /**
         * 审批任务链接（只有第三方审批有）
         * <p> 示例值：
         */
        this.link = builder.link;
        /**
         * 任务id
         * <p> 示例值：7110153401253494803
         */
        this.taskId = builder.taskId;
        /**
         * 审批任务更新时间
         * <p> 示例值：1547654251506
         */
        this.updateTime = builder.updateTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public InstanceSearchLink getLink() {
        return this.link;
    }

    public void setLink(InstanceSearchLink link) {
        this.link = link;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public static class Builder {
        /**
         * 审批任务审批人 id
         * <p> 示例值：lwiu098wj
         */
        private String userId;
        /**
         * 审批任务开始时间
         * <p> 示例值：1547654251506
         */
        private String startTime;
        /**
         * 审批任务结束时间
         * <p> 示例值：1547654251506
         */
        private String endTime;
        /**
         * 审批任务状态
         * <p> 示例值：pending
         */
        private String status;
        /**
         * 审批任务名称（只有第三方审批有）
         * <p> 示例值：test
         */
        private String title;
        /**
         * 审批任务扩展字段，string型json
         * <p> 示例值：{}
         */
        private String extra;
        /**
         * 审批任务链接（只有第三方审批有）
         * <p> 示例值：
         */
        private InstanceSearchLink link;
        /**
         * 任务id
         * <p> 示例值：7110153401253494803
         */
        private String taskId;
        /**
         * 审批任务更新时间
         * <p> 示例值：1547654251506
         */
        private String updateTime;

        /**
         * 审批任务审批人 id
         * <p> 示例值：lwiu098wj
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 审批任务开始时间
         * <p> 示例值：1547654251506
         *
         * @param startTime
         * @return
         */
        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }


        /**
         * 审批任务结束时间
         * <p> 示例值：1547654251506
         *
         * @param endTime
         * @return
         */
        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }


        /**
         * 审批任务状态
         * <p> 示例值：pending
         *
         * @param status
         * @return
         */
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        /**
         * 审批任务状态
         * <p> 示例值：pending
         *
         * @param status {@link com.lark.oapi.service.approval.v4.enums.TaskSearchNodeStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.approval.v4.enums.TaskSearchNodeStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        /**
         * 审批任务名称（只有第三方审批有）
         * <p> 示例值：test
         *
         * @param title
         * @return
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }


        /**
         * 审批任务扩展字段，string型json
         * <p> 示例值：{}
         *
         * @param extra
         * @return
         */
        public Builder extra(String extra) {
            this.extra = extra;
            return this;
        }


        /**
         * 审批任务链接（只有第三方审批有）
         * <p> 示例值：
         *
         * @param link
         * @return
         */
        public Builder link(InstanceSearchLink link) {
            this.link = link;
            return this;
        }


        /**
         * 任务id
         * <p> 示例值：7110153401253494803
         *
         * @param taskId
         * @return
         */
        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }


        /**
         * 审批任务更新时间
         * <p> 示例值：1547654251506
         *
         * @param updateTime
         * @return
         */
        public Builder updateTime(String updateTime) {
            this.updateTime = updateTime;
            return this;
        }


        public TaskSearchNode build() {
            return new TaskSearchNode(this);
        }
    }
}
