// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1.model;

import com.google.gson.annotations.SerializedName;

public class Person {
    /**
     * 用户id，id类型等于user_id_type所指定的类型。
     * <p> 示例值：testesttest
     */
    @SerializedName("id")
    private String id;
    /**
     * 用户的中文名称
     * <p> 示例值：黄泡泡
     */
    @SerializedName("name")
    private String name;
    /**
     * 用户的英文名称
     * <p> 示例值：Paopao Huang
     */
    @SerializedName("en_name")
    private String enName;
    /**
     * 用户的邮箱
     * <p> 示例值：huangpaopao@feishu.cn
     */
    @SerializedName("email")
    private String email;

    // builder 开始
    public Person() {
    }

    public Person(Builder builder) {
        /**
         * 用户id，id类型等于user_id_type所指定的类型。
         * <p> 示例值：testesttest
         */
        this.id = builder.id;
        /**
         * 用户的中文名称
         * <p> 示例值：黄泡泡
         */
        this.name = builder.name;
        /**
         * 用户的英文名称
         * <p> 示例值：Paopao Huang
         */
        this.enName = builder.enName;
        /**
         * 用户的邮箱
         * <p> 示例值：huangpaopao@feishu.cn
         */
        this.email = builder.email;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public static class Builder {
        /**
         * 用户id，id类型等于user_id_type所指定的类型。
         * <p> 示例值：testesttest
         */
        private String id;
        /**
         * 用户的中文名称
         * <p> 示例值：黄泡泡
         */
        private String name;
        /**
         * 用户的英文名称
         * <p> 示例值：Paopao Huang
         */
        private String enName;
        /**
         * 用户的邮箱
         * <p> 示例值：huangpaopao@feishu.cn
         */
        private String email;

        /**
         * 用户id，id类型等于user_id_type所指定的类型。
         * <p> 示例值：testesttest
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 用户的中文名称
         * <p> 示例值：黄泡泡
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 用户的英文名称
         * <p> 示例值：Paopao Huang
         *
         * @param enName
         * @return
         */
        public Builder enName(String enName) {
            this.enName = enName;
            return this;
        }


        /**
         * 用户的邮箱
         * <p> 示例值：huangpaopao@feishu.cn
         *
         * @param email
         * @return
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }


        public Person build() {
            return new Person(this);
        }
    }
}
