// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;

public class CustomList {
    /**
     * 问题类型
     * <p> 示例值：1
     */
    @SerializedName("custom_type")
    private Integer customType;
    /**
     * 自定义题目的key，用于设置显示条件
     * <p> 示例值：238281272
     */
    @SerializedName("key")
    private String key;
    /**
     * 题目是否必填
     * <p> 示例值：false
     */
    @SerializedName("need_fill")
    private Boolean needFill;
    /**
     * 题目标题
     * <p> 示例值：第一题
     */
    @SerializedName("title")
    private String title;
    /**
     * 文本框题目对应的输入提示
     * <p> 示例值：请输入
     */
    @SerializedName("placeholder")
    private String placeholder;
    /**
     * 选项配置，单选多选时使用
     * <p> 示例值：
     */
    @SerializedName("options")
    private Options[] options;
    /**
     * 条件设置，满足某条件才显示某问题
     * <p> 示例值：
     */
    @SerializedName("conditions")
    private Conditions[] conditions;

    // builder 开始
    public CustomList() {
    }

    public CustomList(Builder builder) {
        /**
         * 问题类型
         * <p> 示例值：1
         */
        this.customType = builder.customType;
        /**
         * 自定义题目的key，用于设置显示条件
         * <p> 示例值：238281272
         */
        this.key = builder.key;
        /**
         * 题目是否必填
         * <p> 示例值：false
         */
        this.needFill = builder.needFill;
        /**
         * 题目标题
         * <p> 示例值：第一题
         */
        this.title = builder.title;
        /**
         * 文本框题目对应的输入提示
         * <p> 示例值：请输入
         */
        this.placeholder = builder.placeholder;
        /**
         * 选项配置，单选多选时使用
         * <p> 示例值：
         */
        this.options = builder.options;
        /**
         * 条件设置，满足某条件才显示某问题
         * <p> 示例值：
         */
        this.conditions = builder.conditions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getCustomType() {
        return this.customType;
    }

    public void setCustomType(Integer customType) {
        this.customType = customType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Boolean getNeedFill() {
        return this.needFill;
    }

    public void setNeedFill(Boolean needFill) {
        this.needFill = needFill;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public Options[] getOptions() {
        return this.options;
    }

    public void setOptions(Options[] options) {
        this.options = options;
    }

    public Conditions[] getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions[] conditions) {
        this.conditions = conditions;
    }

    public static class Builder {
        /**
         * 问题类型
         * <p> 示例值：1
         */
        private Integer customType;
        /**
         * 自定义题目的key，用于设置显示条件
         * <p> 示例值：238281272
         */
        private String key;
        /**
         * 题目是否必填
         * <p> 示例值：false
         */
        private Boolean needFill;
        /**
         * 题目标题
         * <p> 示例值：第一题
         */
        private String title;
        /**
         * 文本框题目对应的输入提示
         * <p> 示例值：请输入
         */
        private String placeholder;
        /**
         * 选项配置，单选多选时使用
         * <p> 示例值：
         */
        private Options[] options;
        /**
         * 条件设置，满足某条件才显示某问题
         * <p> 示例值：
         */
        private Conditions[] conditions;

        /**
         * 问题类型
         * <p> 示例值：1
         *
         * @param customType
         * @return
         */
        public Builder customType(Integer customType) {
            this.customType = customType;
            return this;
        }

        /**
         * 问题类型
         * <p> 示例值：1
         *
         * @param customType {@link com.lark.oapi.service.vc.v1.enums.CustomListCustomTypeEnum}
         * @return
         */
        public Builder customType(com.lark.oapi.service.vc.v1.enums.CustomListCustomTypeEnum customType) {
            this.customType = customType.getValue();
            return this;
        }


        /**
         * 自定义题目的key，用于设置显示条件
         * <p> 示例值：238281272
         *
         * @param key
         * @return
         */
        public Builder key(String key) {
            this.key = key;
            return this;
        }


        /**
         * 题目是否必填
         * <p> 示例值：false
         *
         * @param needFill
         * @return
         */
        public Builder needFill(Boolean needFill) {
            this.needFill = needFill;
            return this;
        }


        /**
         * 题目标题
         * <p> 示例值：第一题
         *
         * @param title
         * @return
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }


        /**
         * 文本框题目对应的输入提示
         * <p> 示例值：请输入
         *
         * @param placeholder
         * @return
         */
        public Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }


        /**
         * 选项配置，单选多选时使用
         * <p> 示例值：
         *
         * @param options
         * @return
         */
        public Builder options(Options[] options) {
            this.options = options;
            return this;
        }


        /**
         * 条件设置，满足某条件才显示某问题
         * <p> 示例值：
         *
         * @param conditions
         * @return
         */
        public Builder conditions(Conditions[] conditions) {
            this.conditions = conditions;
            return this;
        }


        public CustomList build() {
            return new CustomList(this);
        }
    }
}
