// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;

public class LeaveRequest {
    /**
     * 请假记录ID
     * <p> 示例值：4718803945687580505
     */
    @SerializedName("leave_request_id")
    private String leaveRequestId;
    /**
     * 雇佣信息ID
     * <p> 示例值：4718803945687580505
     */
    @SerializedName("employment_id")
    private String employmentId;
    /**
     * 员工姓名
     * <p> 示例值：
     */
    @SerializedName("employment_name")
    private I18n[] employmentName;
    /**
     * 假期类型ID
     * <p> 示例值：0
     */
    @SerializedName("leave_type_id")
    private String leaveTypeId;
    /**
     * 假期类型名称
     * <p> 示例值：
     */
    @SerializedName("leave_type_name")
    private I18n[] leaveTypeName;
    /**
     * 假期开始时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
     * <p> 示例值：2022-07-06 morning
     */
    @SerializedName("start_time")
    private String startTime;
    /**
     * 假期结束时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
     * <p> 示例值：2023-01-05
     */
    @SerializedName("end_time")
    private String endTime;
    /**
     * 假期时长
     * <p> 示例值：2
     */
    @SerializedName("leave_duration")
    private String leaveDuration;
    /**
     * 假期时长单位;;可选值有：;;- 1: 天;;- 2: 小时
     * <p> 示例值：2
     */
    @SerializedName("leave_duration_unit")
    private Integer leaveDurationUnit;
    /**
     * 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;- 4：审批中（取消休假）;- 5：审批中（返岗）;- 6：已返岗;- 7：已拒绝;- 8：已取消;- 9：已撤回
     * <p> 示例值：2
     */
    @SerializedName("leave_request_status")
    private Integer leaveRequestStatus;
    /**
     * 数据来源;;可选值有：;;- "manual"：手动创建;;- "system"：系统创建"
     * <p> 示例值：manual
     */
    @SerializedName("grant_source")
    private String grantSource;
    /**
     * 返岗时间
     * <p> 示例值：1662134400
     */
    @SerializedName("return_time")
    private String returnTime;
    /**
     * 发起时间
     * <p> 示例值：1659080476
     */
    @SerializedName("submitted_at")
    private String submittedAt;
    /**
     * 发起人
     * <p> 示例值：7109664941775241244
     */
    @SerializedName("submitted_by")
    private String submittedBy;
    /**
     * 备注
     * <p> 示例值：备注
     */
    @SerializedName("notes")
    private String notes;

    // builder 开始
    public LeaveRequest() {
    }

    public LeaveRequest(Builder builder) {
        /**
         * 请假记录ID
         * <p> 示例值：4718803945687580505
         */
        this.leaveRequestId = builder.leaveRequestId;
        /**
         * 雇佣信息ID
         * <p> 示例值：4718803945687580505
         */
        this.employmentId = builder.employmentId;
        /**
         * 员工姓名
         * <p> 示例值：
         */
        this.employmentName = builder.employmentName;
        /**
         * 假期类型ID
         * <p> 示例值：0
         */
        this.leaveTypeId = builder.leaveTypeId;
        /**
         * 假期类型名称
         * <p> 示例值：
         */
        this.leaveTypeName = builder.leaveTypeName;
        /**
         * 假期开始时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
         * <p> 示例值：2022-07-06 morning
         */
        this.startTime = builder.startTime;
        /**
         * 假期结束时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
         * <p> 示例值：2023-01-05
         */
        this.endTime = builder.endTime;
        /**
         * 假期时长
         * <p> 示例值：2
         */
        this.leaveDuration = builder.leaveDuration;
        /**
         * 假期时长单位;;可选值有：;;- 1: 天;;- 2: 小时
         * <p> 示例值：2
         */
        this.leaveDurationUnit = builder.leaveDurationUnit;
        /**
         * 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;- 4：审批中（取消休假）;- 5：审批中（返岗）;- 6：已返岗;- 7：已拒绝;- 8：已取消;- 9：已撤回
         * <p> 示例值：2
         */
        this.leaveRequestStatus = builder.leaveRequestStatus;
        /**
         * 数据来源;;可选值有：;;- "manual"：手动创建;;- "system"：系统创建"
         * <p> 示例值：manual
         */
        this.grantSource = builder.grantSource;
        /**
         * 返岗时间
         * <p> 示例值：1662134400
         */
        this.returnTime = builder.returnTime;
        /**
         * 发起时间
         * <p> 示例值：1659080476
         */
        this.submittedAt = builder.submittedAt;
        /**
         * 发起人
         * <p> 示例值：7109664941775241244
         */
        this.submittedBy = builder.submittedBy;
        /**
         * 备注
         * <p> 示例值：备注
         */
        this.notes = builder.notes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getLeaveRequestId() {
        return this.leaveRequestId;
    }

    public void setLeaveRequestId(String leaveRequestId) {
        this.leaveRequestId = leaveRequestId;
    }

    public String getEmploymentId() {
        return this.employmentId;
    }

    public void setEmploymentId(String employmentId) {
        this.employmentId = employmentId;
    }

    public I18n[] getEmploymentName() {
        return this.employmentName;
    }

    public void setEmploymentName(I18n[] employmentName) {
        this.employmentName = employmentName;
    }

    public String getLeaveTypeId() {
        return this.leaveTypeId;
    }

    public void setLeaveTypeId(String leaveTypeId) {
        this.leaveTypeId = leaveTypeId;
    }

    public I18n[] getLeaveTypeName() {
        return this.leaveTypeName;
    }

    public void setLeaveTypeName(I18n[] leaveTypeName) {
        this.leaveTypeName = leaveTypeName;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getLeaveDuration() {
        return this.leaveDuration;
    }

    public void setLeaveDuration(String leaveDuration) {
        this.leaveDuration = leaveDuration;
    }

    public Integer getLeaveDurationUnit() {
        return this.leaveDurationUnit;
    }

    public void setLeaveDurationUnit(Integer leaveDurationUnit) {
        this.leaveDurationUnit = leaveDurationUnit;
    }

    public Integer getLeaveRequestStatus() {
        return this.leaveRequestStatus;
    }

    public void setLeaveRequestStatus(Integer leaveRequestStatus) {
        this.leaveRequestStatus = leaveRequestStatus;
    }

    public String getGrantSource() {
        return this.grantSource;
    }

    public void setGrantSource(String grantSource) {
        this.grantSource = grantSource;
    }

    public String getReturnTime() {
        return this.returnTime;
    }

    public void setReturnTime(String returnTime) {
        this.returnTime = returnTime;
    }

    public String getSubmittedAt() {
        return this.submittedAt;
    }

    public void setSubmittedAt(String submittedAt) {
        this.submittedAt = submittedAt;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public static class Builder {
        /**
         * 请假记录ID
         * <p> 示例值：4718803945687580505
         */
        private String leaveRequestId;
        /**
         * 雇佣信息ID
         * <p> 示例值：4718803945687580505
         */
        private String employmentId;
        /**
         * 员工姓名
         * <p> 示例值：
         */
        private I18n[] employmentName;
        /**
         * 假期类型ID
         * <p> 示例值：0
         */
        private String leaveTypeId;
        /**
         * 假期类型名称
         * <p> 示例值：
         */
        private I18n[] leaveTypeName;
        /**
         * 假期开始时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
         * <p> 示例值：2022-07-06 morning
         */
        private String startTime;
        /**
         * 假期结束时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
         * <p> 示例值：2023-01-05
         */
        private String endTime;
        /**
         * 假期时长
         * <p> 示例值：2
         */
        private String leaveDuration;
        /**
         * 假期时长单位;;可选值有：;;- 1: 天;;- 2: 小时
         * <p> 示例值：2
         */
        private Integer leaveDurationUnit;
        /**
         * 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;- 4：审批中（取消休假）;- 5：审批中（返岗）;- 6：已返岗;- 7：已拒绝;- 8：已取消;- 9：已撤回
         * <p> 示例值：2
         */
        private Integer leaveRequestStatus;
        /**
         * 数据来源;;可选值有：;;- "manual"：手动创建;;- "system"：系统创建"
         * <p> 示例值：manual
         */
        private String grantSource;
        /**
         * 返岗时间
         * <p> 示例值：1662134400
         */
        private String returnTime;
        /**
         * 发起时间
         * <p> 示例值：1659080476
         */
        private String submittedAt;
        /**
         * 发起人
         * <p> 示例值：7109664941775241244
         */
        private String submittedBy;
        /**
         * 备注
         * <p> 示例值：备注
         */
        private String notes;

        /**
         * 请假记录ID
         * <p> 示例值：4718803945687580505
         *
         * @param leaveRequestId
         * @return
         */
        public Builder leaveRequestId(String leaveRequestId) {
            this.leaveRequestId = leaveRequestId;
            return this;
        }


        /**
         * 雇佣信息ID
         * <p> 示例值：4718803945687580505
         *
         * @param employmentId
         * @return
         */
        public Builder employmentId(String employmentId) {
            this.employmentId = employmentId;
            return this;
        }


        /**
         * 员工姓名
         * <p> 示例值：
         *
         * @param employmentName
         * @return
         */
        public Builder employmentName(I18n[] employmentName) {
            this.employmentName = employmentName;
            return this;
        }


        /**
         * 假期类型ID
         * <p> 示例值：0
         *
         * @param leaveTypeId
         * @return
         */
        public Builder leaveTypeId(String leaveTypeId) {
            this.leaveTypeId = leaveTypeId;
            return this;
        }


        /**
         * 假期类型名称
         * <p> 示例值：
         *
         * @param leaveTypeName
         * @return
         */
        public Builder leaveTypeName(I18n[] leaveTypeName) {
            this.leaveTypeName = leaveTypeName;
            return this;
        }


        /**
         * 假期开始时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
         * <p> 示例值：2022-07-06 morning
         *
         * @param startTime
         * @return
         */
        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }


        /**
         * 假期结束时间，格式可能为：;; - 字符串日期：如 "2022-09-09";; - 字符串日期加 morning/afternoon：如 "2022-09-09 morning""
         * <p> 示例值：2023-01-05
         *
         * @param endTime
         * @return
         */
        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }


        /**
         * 假期时长
         * <p> 示例值：2
         *
         * @param leaveDuration
         * @return
         */
        public Builder leaveDuration(String leaveDuration) {
            this.leaveDuration = leaveDuration;
            return this;
        }


        /**
         * 假期时长单位;;可选值有：;;- 1: 天;;- 2: 小时
         * <p> 示例值：2
         *
         * @param leaveDurationUnit
         * @return
         */
        public Builder leaveDurationUnit(Integer leaveDurationUnit) {
            this.leaveDurationUnit = leaveDurationUnit;
            return this;
        }


        /**
         * 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;- 4：审批中（取消休假）;- 5：审批中（返岗）;- 6：已返岗;- 7：已拒绝;- 8：已取消;- 9：已撤回
         * <p> 示例值：2
         *
         * @param leaveRequestStatus
         * @return
         */
        public Builder leaveRequestStatus(Integer leaveRequestStatus) {
            this.leaveRequestStatus = leaveRequestStatus;
            return this;
        }


        /**
         * 数据来源;;可选值有：;;- "manual"：手动创建;;- "system"：系统创建"
         * <p> 示例值：manual
         *
         * @param grantSource
         * @return
         */
        public Builder grantSource(String grantSource) {
            this.grantSource = grantSource;
            return this;
        }


        /**
         * 返岗时间
         * <p> 示例值：1662134400
         *
         * @param returnTime
         * @return
         */
        public Builder returnTime(String returnTime) {
            this.returnTime = returnTime;
            return this;
        }


        /**
         * 发起时间
         * <p> 示例值：1659080476
         *
         * @param submittedAt
         * @return
         */
        public Builder submittedAt(String submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }


        /**
         * 发起人
         * <p> 示例值：7109664941775241244
         *
         * @param submittedBy
         * @return
         */
        public Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }


        /**
         * 备注
         * <p> 示例值：备注
         *
         * @param notes
         * @return
         */
        public Builder notes(String notes) {
            this.notes = notes;
            return this;
        }


        public LeaveRequest build() {
            return new LeaveRequest(this);
        }
    }
}
