// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.google.gson.annotations.SerializedName;

public class Application {
    /**
     * 投递id
     * <p> 示例值：6949805467799537964
     */
    @SerializedName("id")
    private String id;
    /**
     * 投递的职位 ID
     * <p> 示例值：6843547872837273223
     */
    @SerializedName("job_id")
    private String jobId;
    /**
     * 候选人 ID
     * <p> 示例值：6843547872837273223
     */
    @SerializedName("talent_id")
    private String talentId;
    /**
     * 简历来源 ID
     * <p> 示例值：6583482347283472832
     */
    @SerializedName("resume_resource_id")
    private String resumeResourceId;
    /**
     * 投递处于的阶段
     * <p> 示例值：
     */
    @SerializedName("stage")
    private ApplicationStageInfo stage;
    /**
     * 活跃状态
     * <p> 示例值：1
     */
    @SerializedName("active_status")
    private Integer activeStatus;
    /**
     * 投递方式
     * <p> 示例值：1
     */
    @SerializedName("delivery_type")
    private Integer deliveryType;
    /**
     * 投递来源信息
     * <p> 示例值：
     */
    @SerializedName("resume_source_info")
    private ApplicationResumeSource resumeSourceInfo;
    /**
     * 官网投递来源
     * <p> 示例值：
     */
    @SerializedName("website_resume_source")
    private ApplicationWebsiteResumeSource websiteResumeSource;
    /**
     * 简历附件 ID
     * <p> 示例值：6960663240925956415
     */
    @SerializedName("talent_attachment_resume_id")
    private String talentAttachmentResumeId;
    /**
     * 创建时间
     * <p> 示例值：1632990774278
     */
    @SerializedName("create_time")
    private String createTime;
    /**
     * 修改时间
     * <p> 示例值：1634801678103
     */
    @SerializedName("modify_time")
    private String modifyTime;
    /**
     * 阶段变更时间列表
     * <p> 示例值：
     */
    @SerializedName("stage_time_list")
    private ApplicationStageTime[] stageTimeList;
    /**
     * 终止原因的类型
     * <p> 示例值：1
     */
    @SerializedName("termination_type")
    private Integer terminationType;
    /**
     * 终止的具体原因的id列表
     * <p> 示例值：
     */
    @SerializedName("termination_reason_list")
    private String[] terminationReasonList;
    /**
     * 终止备注
     * <p> 示例值：其他投递已入职
     */
    @SerializedName("termination_reason_note")
    private String terminationReasonNote;
    /**
     * 意向投递城市列表
     * <p> 示例值：
     */
    @SerializedName("application_preferred_city_list")
    private CodeNameObject[] applicationPreferredCityList;

    // builder 开始
    public Application() {
    }

    public Application(Builder builder) {
        /**
         * 投递id
         * <p> 示例值：6949805467799537964
         */
        this.id = builder.id;
        /**
         * 投递的职位 ID
         * <p> 示例值：6843547872837273223
         */
        this.jobId = builder.jobId;
        /**
         * 候选人 ID
         * <p> 示例值：6843547872837273223
         */
        this.talentId = builder.talentId;
        /**
         * 简历来源 ID
         * <p> 示例值：6583482347283472832
         */
        this.resumeResourceId = builder.resumeResourceId;
        /**
         * 投递处于的阶段
         * <p> 示例值：
         */
        this.stage = builder.stage;
        /**
         * 活跃状态
         * <p> 示例值：1
         */
        this.activeStatus = builder.activeStatus;
        /**
         * 投递方式
         * <p> 示例值：1
         */
        this.deliveryType = builder.deliveryType;
        /**
         * 投递来源信息
         * <p> 示例值：
         */
        this.resumeSourceInfo = builder.resumeSourceInfo;
        /**
         * 官网投递来源
         * <p> 示例值：
         */
        this.websiteResumeSource = builder.websiteResumeSource;
        /**
         * 简历附件 ID
         * <p> 示例值：6960663240925956415
         */
        this.talentAttachmentResumeId = builder.talentAttachmentResumeId;
        /**
         * 创建时间
         * <p> 示例值：1632990774278
         */
        this.createTime = builder.createTime;
        /**
         * 修改时间
         * <p> 示例值：1634801678103
         */
        this.modifyTime = builder.modifyTime;
        /**
         * 阶段变更时间列表
         * <p> 示例值：
         */
        this.stageTimeList = builder.stageTimeList;
        /**
         * 终止原因的类型
         * <p> 示例值：1
         */
        this.terminationType = builder.terminationType;
        /**
         * 终止的具体原因的id列表
         * <p> 示例值：
         */
        this.terminationReasonList = builder.terminationReasonList;
        /**
         * 终止备注
         * <p> 示例值：其他投递已入职
         */
        this.terminationReasonNote = builder.terminationReasonNote;
        /**
         * 意向投递城市列表
         * <p> 示例值：
         */
        this.applicationPreferredCityList = builder.applicationPreferredCityList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getTalentId() {
        return this.talentId;
    }

    public void setTalentId(String talentId) {
        this.talentId = talentId;
    }

    public String getResumeResourceId() {
        return this.resumeResourceId;
    }

    public void setResumeResourceId(String resumeResourceId) {
        this.resumeResourceId = resumeResourceId;
    }

    public ApplicationStageInfo getStage() {
        return this.stage;
    }

    public void setStage(ApplicationStageInfo stage) {
        this.stage = stage;
    }

    public Integer getActiveStatus() {
        return this.activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public Integer getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public ApplicationResumeSource getResumeSourceInfo() {
        return this.resumeSourceInfo;
    }

    public void setResumeSourceInfo(ApplicationResumeSource resumeSourceInfo) {
        this.resumeSourceInfo = resumeSourceInfo;
    }

    public ApplicationWebsiteResumeSource getWebsiteResumeSource() {
        return this.websiteResumeSource;
    }

    public void setWebsiteResumeSource(ApplicationWebsiteResumeSource websiteResumeSource) {
        this.websiteResumeSource = websiteResumeSource;
    }

    public String getTalentAttachmentResumeId() {
        return this.talentAttachmentResumeId;
    }

    public void setTalentAttachmentResumeId(String talentAttachmentResumeId) {
        this.talentAttachmentResumeId = talentAttachmentResumeId;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }

    public ApplicationStageTime[] getStageTimeList() {
        return this.stageTimeList;
    }

    public void setStageTimeList(ApplicationStageTime[] stageTimeList) {
        this.stageTimeList = stageTimeList;
    }

    public Integer getTerminationType() {
        return this.terminationType;
    }

    public void setTerminationType(Integer terminationType) {
        this.terminationType = terminationType;
    }

    public String[] getTerminationReasonList() {
        return this.terminationReasonList;
    }

    public void setTerminationReasonList(String[] terminationReasonList) {
        this.terminationReasonList = terminationReasonList;
    }

    public String getTerminationReasonNote() {
        return this.terminationReasonNote;
    }

    public void setTerminationReasonNote(String terminationReasonNote) {
        this.terminationReasonNote = terminationReasonNote;
    }

    public CodeNameObject[] getApplicationPreferredCityList() {
        return this.applicationPreferredCityList;
    }

    public void setApplicationPreferredCityList(CodeNameObject[] applicationPreferredCityList) {
        this.applicationPreferredCityList = applicationPreferredCityList;
    }

    public static class Builder {
        /**
         * 投递id
         * <p> 示例值：6949805467799537964
         */
        private String id;
        /**
         * 投递的职位 ID
         * <p> 示例值：6843547872837273223
         */
        private String jobId;
        /**
         * 候选人 ID
         * <p> 示例值：6843547872837273223
         */
        private String talentId;
        /**
         * 简历来源 ID
         * <p> 示例值：6583482347283472832
         */
        private String resumeResourceId;
        /**
         * 投递处于的阶段
         * <p> 示例值：
         */
        private ApplicationStageInfo stage;
        /**
         * 活跃状态
         * <p> 示例值：1
         */
        private Integer activeStatus;
        /**
         * 投递方式
         * <p> 示例值：1
         */
        private Integer deliveryType;
        /**
         * 投递来源信息
         * <p> 示例值：
         */
        private ApplicationResumeSource resumeSourceInfo;
        /**
         * 官网投递来源
         * <p> 示例值：
         */
        private ApplicationWebsiteResumeSource websiteResumeSource;
        /**
         * 简历附件 ID
         * <p> 示例值：6960663240925956415
         */
        private String talentAttachmentResumeId;
        /**
         * 创建时间
         * <p> 示例值：1632990774278
         */
        private String createTime;
        /**
         * 修改时间
         * <p> 示例值：1634801678103
         */
        private String modifyTime;
        /**
         * 阶段变更时间列表
         * <p> 示例值：
         */
        private ApplicationStageTime[] stageTimeList;
        /**
         * 终止原因的类型
         * <p> 示例值：1
         */
        private Integer terminationType;
        /**
         * 终止的具体原因的id列表
         * <p> 示例值：
         */
        private String[] terminationReasonList;
        /**
         * 终止备注
         * <p> 示例值：其他投递已入职
         */
        private String terminationReasonNote;
        /**
         * 意向投递城市列表
         * <p> 示例值：
         */
        private CodeNameObject[] applicationPreferredCityList;

        /**
         * 投递id
         * <p> 示例值：6949805467799537964
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 投递的职位 ID
         * <p> 示例值：6843547872837273223
         *
         * @param jobId
         * @return
         */
        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }


        /**
         * 候选人 ID
         * <p> 示例值：6843547872837273223
         *
         * @param talentId
         * @return
         */
        public Builder talentId(String talentId) {
            this.talentId = talentId;
            return this;
        }


        /**
         * 简历来源 ID
         * <p> 示例值：6583482347283472832
         *
         * @param resumeResourceId
         * @return
         */
        public Builder resumeResourceId(String resumeResourceId) {
            this.resumeResourceId = resumeResourceId;
            return this;
        }


        /**
         * 投递处于的阶段
         * <p> 示例值：
         *
         * @param stage
         * @return
         */
        public Builder stage(ApplicationStageInfo stage) {
            this.stage = stage;
            return this;
        }


        /**
         * 活跃状态
         * <p> 示例值：1
         *
         * @param activeStatus
         * @return
         */
        public Builder activeStatus(Integer activeStatus) {
            this.activeStatus = activeStatus;
            return this;
        }


        /**
         * 投递方式
         * <p> 示例值：1
         *
         * @param deliveryType
         * @return
         */
        public Builder deliveryType(Integer deliveryType) {
            this.deliveryType = deliveryType;
            return this;
        }


        /**
         * 投递来源信息
         * <p> 示例值：
         *
         * @param resumeSourceInfo
         * @return
         */
        public Builder resumeSourceInfo(ApplicationResumeSource resumeSourceInfo) {
            this.resumeSourceInfo = resumeSourceInfo;
            return this;
        }


        /**
         * 官网投递来源
         * <p> 示例值：
         *
         * @param websiteResumeSource
         * @return
         */
        public Builder websiteResumeSource(ApplicationWebsiteResumeSource websiteResumeSource) {
            this.websiteResumeSource = websiteResumeSource;
            return this;
        }


        /**
         * 简历附件 ID
         * <p> 示例值：6960663240925956415
         *
         * @param talentAttachmentResumeId
         * @return
         */
        public Builder talentAttachmentResumeId(String talentAttachmentResumeId) {
            this.talentAttachmentResumeId = talentAttachmentResumeId;
            return this;
        }


        /**
         * 创建时间
         * <p> 示例值：1632990774278
         *
         * @param createTime
         * @return
         */
        public Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }


        /**
         * 修改时间
         * <p> 示例值：1634801678103
         *
         * @param modifyTime
         * @return
         */
        public Builder modifyTime(String modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }


        /**
         * 阶段变更时间列表
         * <p> 示例值：
         *
         * @param stageTimeList
         * @return
         */
        public Builder stageTimeList(ApplicationStageTime[] stageTimeList) {
            this.stageTimeList = stageTimeList;
            return this;
        }


        /**
         * 终止原因的类型
         * <p> 示例值：1
         *
         * @param terminationType
         * @return
         */
        public Builder terminationType(Integer terminationType) {
            this.terminationType = terminationType;
            return this;
        }


        /**
         * 终止的具体原因的id列表
         * <p> 示例值：
         *
         * @param terminationReasonList
         * @return
         */
        public Builder terminationReasonList(String[] terminationReasonList) {
            this.terminationReasonList = terminationReasonList;
            return this;
        }


        /**
         * 终止备注
         * <p> 示例值：其他投递已入职
         *
         * @param terminationReasonNote
         * @return
         */
        public Builder terminationReasonNote(String terminationReasonNote) {
            this.terminationReasonNote = terminationReasonNote;
            return this;
        }


        /**
         * 意向投递城市列表
         * <p> 示例值：
         *
         * @param applicationPreferredCityList
         * @return
         */
        public Builder applicationPreferredCityList(CodeNameObject[] applicationPreferredCityList) {
            this.applicationPreferredCityList = applicationPreferredCityList;
            return this;
        }


        public Application build() {
            return new Application(this);
        }
    }
}
