/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.authen.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.authen.v1.model.CreateAccessTokenReq;
import com.lark.oapi.service.authen.v1.model.CreateAccessTokenResp;
import com.lark.oapi.service.authen.v1.model.CreateRefreshAccessTokenReq;
import com.lark.oapi.service.authen.v1.model.CreateRefreshAccessTokenResp;
import com.lark.oapi.service.authen.v1.model.GetUserInfoResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenService {
    private static final Logger log = LoggerFactory.getLogger(AuthenService.class);
    private final AccessToken accessToken;
    private final RefreshAccessToken refreshAccessToken;
    private final UserInfo userInfo;

    public AuthenService(Config config) {
        this.accessToken = new AccessToken(config);
        this.refreshAccessToken = new RefreshAccessToken(config);
        this.userInfo = new UserInfo(config);
    }

    public AccessToken accessToken() {
        return this.accessToken;
    }

    public RefreshAccessToken refreshAccessToken() {
        return this.refreshAccessToken;
    }

    public UserInfo userInfo() {
        return this.userInfo;
    }

    public static class AccessToken {
        private final Config config;

        public AccessToken(Config config) {
            this.config = config;
        }

        public CreateAccessTokenResp create(CreateAccessTokenReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateAccessTokenResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/authen/v1/access_token", Sets.newHashSet(AccessTokenType.App), req), CreateAccessTokenResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/authen/v1/access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateAccessTokenResp create(CreateAccessTokenReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/authen/v1/access_token", Sets.newHashSet(AccessTokenType.App), req);
            CreateAccessTokenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateAccessTokenResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/authen/v1/access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class RefreshAccessToken {
        private final Config config;

        public RefreshAccessToken(Config config) {
            this.config = config;
        }

        public CreateRefreshAccessTokenResp create(CreateRefreshAccessTokenReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateRefreshAccessTokenResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/authen/v1/refresh_access_token", Sets.newHashSet(AccessTokenType.App), req), CreateRefreshAccessTokenResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/authen/v1/refresh_access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateRefreshAccessTokenResp create(CreateRefreshAccessTokenReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/authen/v1/refresh_access_token", Sets.newHashSet(AccessTokenType.App), req);
            CreateRefreshAccessTokenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateRefreshAccessTokenResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/authen/v1/refresh_access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class UserInfo {
        private final Config config;

        public UserInfo(Config config) {
            this.config = config;
        }

        public GetUserInfoResp get(RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetUserInfoResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/authen/v1/user_info", Sets.newHashSet(AccessTokenType.User), null), GetUserInfoResp.class)) == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/authen/v1/user_info", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public GetUserInfoResp get() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/authen/v1/user_info", Sets.newHashSet(AccessTokenType.User), null);
            GetUserInfoResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetUserInfoResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/authen/v1/user_info", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }
}

