/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.hire.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.hire.v1.model.BatchGetIdTalentReq;
import com.lark.oapi.service.hire.v1.model.BatchGetIdTalentResp;
import com.lark.oapi.service.hire.v1.model.CombinedCreateJobReq;
import com.lark.oapi.service.hire.v1.model.CombinedCreateJobResp;
import com.lark.oapi.service.hire.v1.model.CombinedUpdateJobReq;
import com.lark.oapi.service.hire.v1.model.CombinedUpdateJobResp;
import com.lark.oapi.service.hire.v1.model.ConfigJobReq;
import com.lark.oapi.service.hire.v1.model.ConfigJobResp;
import com.lark.oapi.service.hire.v1.model.CreateApplicationReq;
import com.lark.oapi.service.hire.v1.model.CreateApplicationResp;
import com.lark.oapi.service.hire.v1.model.CreateNoteReq;
import com.lark.oapi.service.hire.v1.model.CreateNoteResp;
import com.lark.oapi.service.hire.v1.model.GetApplicationReq;
import com.lark.oapi.service.hire.v1.model.GetApplicationResp;
import com.lark.oapi.service.hire.v1.model.GetAttachmentReq;
import com.lark.oapi.service.hire.v1.model.GetAttachmentResp;
import com.lark.oapi.service.hire.v1.model.GetByApplicationEmployeeReq;
import com.lark.oapi.service.hire.v1.model.GetByApplicationEmployeeResp;
import com.lark.oapi.service.hire.v1.model.GetByApplicationReferralReq;
import com.lark.oapi.service.hire.v1.model.GetByApplicationReferralResp;
import com.lark.oapi.service.hire.v1.model.GetEmployeeReq;
import com.lark.oapi.service.hire.v1.model.GetEmployeeResp;
import com.lark.oapi.service.hire.v1.model.GetJobManagerReq;
import com.lark.oapi.service.hire.v1.model.GetJobManagerResp;
import com.lark.oapi.service.hire.v1.model.GetJobReq;
import com.lark.oapi.service.hire.v1.model.GetJobResp;
import com.lark.oapi.service.hire.v1.model.GetNoteReq;
import com.lark.oapi.service.hire.v1.model.GetNoteResp;
import com.lark.oapi.service.hire.v1.model.GetOfferSchemaReq;
import com.lark.oapi.service.hire.v1.model.GetOfferSchemaResp;
import com.lark.oapi.service.hire.v1.model.GetTalentReq;
import com.lark.oapi.service.hire.v1.model.GetTalentResp;
import com.lark.oapi.service.hire.v1.model.ListApplicationInterviewReq;
import com.lark.oapi.service.hire.v1.model.ListApplicationInterviewResp;
import com.lark.oapi.service.hire.v1.model.ListApplicationReq;
import com.lark.oapi.service.hire.v1.model.ListApplicationResp;
import com.lark.oapi.service.hire.v1.model.ListJobProcessReq;
import com.lark.oapi.service.hire.v1.model.ListJobProcessResp;
import com.lark.oapi.service.hire.v1.model.ListNoteReq;
import com.lark.oapi.service.hire.v1.model.ListNoteResp;
import com.lark.oapi.service.hire.v1.model.ListResumeSourceReq;
import com.lark.oapi.service.hire.v1.model.ListResumeSourceResp;
import com.lark.oapi.service.hire.v1.model.OfferApplicationReq;
import com.lark.oapi.service.hire.v1.model.OfferApplicationResp;
import com.lark.oapi.service.hire.v1.model.P2ApplicationStageChangedV1;
import com.lark.oapi.service.hire.v1.model.PatchEhrImportTaskReq;
import com.lark.oapi.service.hire.v1.model.PatchEhrImportTaskResp;
import com.lark.oapi.service.hire.v1.model.PatchEmployeeReq;
import com.lark.oapi.service.hire.v1.model.PatchEmployeeResp;
import com.lark.oapi.service.hire.v1.model.PatchNoteReq;
import com.lark.oapi.service.hire.v1.model.PatchNoteResp;
import com.lark.oapi.service.hire.v1.model.PreviewAttachmentReq;
import com.lark.oapi.service.hire.v1.model.PreviewAttachmentResp;
import com.lark.oapi.service.hire.v1.model.TerminateApplicationReq;
import com.lark.oapi.service.hire.v1.model.TerminateApplicationResp;
import com.lark.oapi.service.hire.v1.model.TransferOnboardApplicationReq;
import com.lark.oapi.service.hire.v1.model.TransferOnboardApplicationResp;
import com.lark.oapi.service.hire.v1.model.UpdateConfigJobReq;
import com.lark.oapi.service.hire.v1.model.UpdateConfigJobResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HireService {
    private static final Logger log = LoggerFactory.getLogger(HireService.class);
    private final Application application;
    private final ApplicationInterview applicationInterview;
    private final Attachment attachment;
    private final EhrImportTask ehrImportTask;
    private final Employee employee;
    private final Job job;
    private final JobManager jobManager;
    private final JobProcess jobProcess;
    private final Note note;
    private final OfferSchema offerSchema;
    private final Referral referral;
    private final ResumeSource resumeSource;
    private final Talent talent;

    public HireService(Config config) {
        this.application = new Application(config);
        this.applicationInterview = new ApplicationInterview(config);
        this.attachment = new Attachment(config);
        this.ehrImportTask = new EhrImportTask(config);
        this.employee = new Employee(config);
        this.job = new Job(config);
        this.jobManager = new JobManager(config);
        this.jobProcess = new JobProcess(config);
        this.note = new Note(config);
        this.offerSchema = new OfferSchema(config);
        this.referral = new Referral(config);
        this.resumeSource = new ResumeSource(config);
        this.talent = new Talent(config);
    }

    public Application application() {
        return this.application;
    }

    public ApplicationInterview applicationInterview() {
        return this.applicationInterview;
    }

    public Attachment attachment() {
        return this.attachment;
    }

    public EhrImportTask ehrImportTask() {
        return this.ehrImportTask;
    }

    public Employee employee() {
        return this.employee;
    }

    public Job job() {
        return this.job;
    }

    public JobManager jobManager() {
        return this.jobManager;
    }

    public JobProcess jobProcess() {
        return this.jobProcess;
    }

    public Note note() {
        return this.note;
    }

    public OfferSchema offerSchema() {
        return this.offerSchema;
    }

    public Referral referral() {
        return this.referral;
    }

    public ResumeSource resumeSource() {
        return this.resumeSource;
    }

    public Talent talent() {
        return this.talent;
    }

    public static class Application {
        private final Config config;

        public Application(Config config) {
            this.config = config;
        }

        public CreateApplicationResp create(CreateApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/applications", Sets.newHashSet(AccessTokenType.Tenant), req), CreateApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateApplicationResp create(CreateApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/applications", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetApplicationResp get(GetApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications/:application_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetApplicationResp get(GetApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications/:application_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListApplicationResp list(ListApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications", Sets.newHashSet(AccessTokenType.Tenant), req), ListApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListApplicationResp list(ListApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public OfferApplicationResp offer(OfferApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            OfferApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications/:application_id/offer", Sets.newHashSet(AccessTokenType.Tenant), req), OfferApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/offer", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public OfferApplicationResp offer(OfferApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications/:application_id/offer", Sets.newHashSet(AccessTokenType.Tenant), req);
            OfferApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, OfferApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/offer", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TerminateApplicationResp terminate(TerminateApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            TerminateApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/applications/:application_id/terminate", Sets.newHashSet(AccessTokenType.Tenant), req), TerminateApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/terminate", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TerminateApplicationResp terminate(TerminateApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/applications/:application_id/terminate", Sets.newHashSet(AccessTokenType.Tenant), req);
            TerminateApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TerminateApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/terminate", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TransferOnboardApplicationResp transferOnboard(TransferOnboardApplicationReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            TransferOnboardApplicationResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/applications/:application_id/transfer_onboard", Sets.newHashSet(AccessTokenType.Tenant), req), TransferOnboardApplicationResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/transfer_onboard", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TransferOnboardApplicationResp transferOnboard(TransferOnboardApplicationReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/applications/:application_id/transfer_onboard", Sets.newHashSet(AccessTokenType.Tenant), req);
            TransferOnboardApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TransferOnboardApplicationResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/transfer_onboard", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ApplicationInterview {
        private final Config config;

        public ApplicationInterview(Config config) {
            this.config = config;
        }

        public ListApplicationInterviewResp list(ListApplicationInterviewReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListApplicationInterviewResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications/:application_id/interviews", Sets.newHashSet(AccessTokenType.Tenant), req), ListApplicationInterviewResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/interviews", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListApplicationInterviewResp list(ListApplicationInterviewReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/applications/:application_id/interviews", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListApplicationInterviewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListApplicationInterviewResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/applications/:application_id/interviews", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Attachment {
        private final Config config;

        public Attachment(Config config) {
            this.config = config;
        }

        public GetAttachmentResp get(GetAttachmentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetAttachmentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/attachments/:attachment_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetAttachmentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/attachments/:attachment_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetAttachmentResp get(GetAttachmentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/attachments/:attachment_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAttachmentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/attachments/:attachment_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PreviewAttachmentResp preview(PreviewAttachmentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PreviewAttachmentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/attachments/:attachment_id/preview", Sets.newHashSet(AccessTokenType.Tenant), req), PreviewAttachmentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/attachments/:attachment_id/preview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PreviewAttachmentResp preview(PreviewAttachmentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/attachments/:attachment_id/preview", Sets.newHashSet(AccessTokenType.Tenant), req);
            PreviewAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PreviewAttachmentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/attachments/:attachment_id/preview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class EhrImportTask {
        private final Config config;

        public EhrImportTask(Config config) {
            this.config = config;
        }

        public PatchEhrImportTaskResp patch(PatchEhrImportTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchEhrImportTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/hire/v1/ehr_import_tasks/:ehr_import_task_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchEhrImportTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/ehr_import_tasks/:ehr_import_task_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchEhrImportTaskResp patch(PatchEhrImportTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/hire/v1/ehr_import_tasks/:ehr_import_task_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchEhrImportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchEhrImportTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/ehr_import_tasks/:ehr_import_task_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Employee {
        private final Config config;

        public Employee(Config config) {
            this.config = config;
        }

        public GetEmployeeResp get(GetEmployeeReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetEmployeeResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/employees/:employee_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetEmployeeResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/employees/:employee_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetEmployeeResp get(GetEmployeeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/employees/:employee_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetEmployeeResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/employees/:employee_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetByApplicationEmployeeResp getByApplication(GetByApplicationEmployeeReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetByApplicationEmployeeResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/employees/get_by_application", Sets.newHashSet(AccessTokenType.Tenant), req), GetByApplicationEmployeeResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/employees/get_by_application", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetByApplicationEmployeeResp getByApplication(GetByApplicationEmployeeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/employees/get_by_application", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetByApplicationEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetByApplicationEmployeeResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/employees/get_by_application", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchEmployeeResp patch(PatchEmployeeReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchEmployeeResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/hire/v1/employees/:employee_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchEmployeeResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/employees/:employee_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchEmployeeResp patch(PatchEmployeeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/hire/v1/employees/:employee_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchEmployeeResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/employees/:employee_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Job {
        private final Config config;

        public Job(Config config) {
            this.config = config;
        }

        public CombinedCreateJobResp combinedCreate(CombinedCreateJobReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CombinedCreateJobResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/jobs/combined_create", Sets.newHashSet(AccessTokenType.Tenant), req), CombinedCreateJobResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/combined_create", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CombinedCreateJobResp combinedCreate(CombinedCreateJobReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/jobs/combined_create", Sets.newHashSet(AccessTokenType.Tenant), req);
            CombinedCreateJobResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CombinedCreateJobResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/combined_create", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CombinedUpdateJobResp combinedUpdate(CombinedUpdateJobReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CombinedUpdateJobResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/jobs/:job_id/combined_update", Sets.newHashSet(AccessTokenType.Tenant), req), CombinedUpdateJobResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/combined_update", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CombinedUpdateJobResp combinedUpdate(CombinedUpdateJobReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/jobs/:job_id/combined_update", Sets.newHashSet(AccessTokenType.Tenant), req);
            CombinedUpdateJobResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CombinedUpdateJobResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/combined_update", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ConfigJobResp config(ConfigJobReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ConfigJobResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/jobs/:job_id/config", Sets.newHashSet(AccessTokenType.Tenant), req), ConfigJobResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/config", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ConfigJobResp config(ConfigJobReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/jobs/:job_id/config", Sets.newHashSet(AccessTokenType.Tenant), req);
            ConfigJobResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ConfigJobResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/config", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetJobResp get(GetJobReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetJobResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/jobs/:job_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetJobResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetJobResp get(GetJobReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/jobs/:job_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetJobResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetJobResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateConfigJobResp updateConfig(UpdateConfigJobReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            UpdateConfigJobResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/jobs/:job_id/update_config", Sets.newHashSet(AccessTokenType.Tenant), req), UpdateConfigJobResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/update_config", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateConfigJobResp updateConfig(UpdateConfigJobReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/jobs/:job_id/update_config", Sets.newHashSet(AccessTokenType.Tenant), req);
            UpdateConfigJobResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateConfigJobResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/update_config", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class JobManager {
        private final Config config;

        public JobManager(Config config) {
            this.config = config;
        }

        public GetJobManagerResp get(GetJobManagerReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetJobManagerResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/jobs/:job_id/managers/:manager_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetJobManagerResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/managers/:manager_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetJobManagerResp get(GetJobManagerReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/jobs/:job_id/managers/:manager_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetJobManagerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetJobManagerResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/jobs/:job_id/managers/:manager_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class JobProcess {
        private final Config config;

        public JobProcess(Config config) {
            this.config = config;
        }

        public ListJobProcessResp list(ListJobProcessReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListJobProcessResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/job_processes", Sets.newHashSet(AccessTokenType.Tenant), req), ListJobProcessResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/job_processes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListJobProcessResp list(ListJobProcessReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/job_processes", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListJobProcessResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListJobProcessResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/job_processes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Note {
        private final Config config;

        public Note(Config config) {
            this.config = config;
        }

        public CreateNoteResp create(CreateNoteReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateNoteResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/notes", Sets.newHashSet(AccessTokenType.Tenant), req), CreateNoteResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateNoteResp create(CreateNoteReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/notes", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateNoteResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetNoteResp get(GetNoteReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetNoteResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/notes/:note_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetNoteResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes/:note_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetNoteResp get(GetNoteReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/notes/:note_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetNoteResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes/:note_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListNoteResp list(ListNoteReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListNoteResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/notes", Sets.newHashSet(AccessTokenType.Tenant), req), ListNoteResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListNoteResp list(ListNoteReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/notes", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListNoteResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchNoteResp patch(PatchNoteReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchNoteResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/hire/v1/notes/:note_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchNoteResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes/:note_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchNoteResp patch(PatchNoteReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/hire/v1/notes/:note_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchNoteResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/notes/:note_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class OfferSchema {
        private final Config config;

        public OfferSchema(Config config) {
            this.config = config;
        }

        public GetOfferSchemaResp get(GetOfferSchemaReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetOfferSchemaResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/offer_schemas/:offer_schema_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetOfferSchemaResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/offer_schemas/:offer_schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetOfferSchemaResp get(GetOfferSchemaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/offer_schemas/:offer_schema_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetOfferSchemaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetOfferSchemaResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/offer_schemas/:offer_schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Referral {
        private final Config config;

        public Referral(Config config) {
            this.config = config;
        }

        public GetByApplicationReferralResp getByApplication(GetByApplicationReferralReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetByApplicationReferralResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/referrals/get_by_application", Sets.newHashSet(AccessTokenType.Tenant), req), GetByApplicationReferralResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/referrals/get_by_application", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetByApplicationReferralResp getByApplication(GetByApplicationReferralReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/referrals/get_by_application", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetByApplicationReferralResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetByApplicationReferralResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/referrals/get_by_application", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ResumeSource {
        private final Config config;

        public ResumeSource(Config config) {
            this.config = config;
        }

        public ListResumeSourceResp list(ListResumeSourceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListResumeSourceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/resume_sources", Sets.newHashSet(AccessTokenType.Tenant), req), ListResumeSourceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/resume_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListResumeSourceResp list(ListResumeSourceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/resume_sources", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListResumeSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListResumeSourceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/resume_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Talent {
        private final Config config;

        public Talent(Config config) {
            this.config = config;
        }

        public BatchGetIdTalentResp batchGetId(BatchGetIdTalentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            BatchGetIdTalentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/talents/batch_get_id", Sets.newHashSet(AccessTokenType.Tenant), req), BatchGetIdTalentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/talents/batch_get_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchGetIdTalentResp batchGetId(BatchGetIdTalentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/hire/v1/talents/batch_get_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            BatchGetIdTalentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchGetIdTalentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/talents/batch_get_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTalentResp get(GetTalentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetTalentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/talents/:talent_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetTalentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/talents/:talent_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTalentResp get(GetTalentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/hire/v1/talents/:talent_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetTalentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTalentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/hire/v1/talents/:talent_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static abstract class P2ApplicationStageChangedV1Handler
    implements IEventHandler<P2ApplicationStageChangedV1> {
        @Override
        public P2ApplicationStageChangedV1 getEvent() {
            return new P2ApplicationStageChangedV1();
        }
    }
}

