/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.tenant.v2;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.tenant.v2.model.QueryTenantProductAssignInfoResp;
import com.lark.oapi.service.tenant.v2.model.QueryTenantResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantService {
    private static final Logger log = LoggerFactory.getLogger(TenantService.class);
    private final Tenant tenant;
    private final TenantProductAssignInfo tenantProductAssignInfo;

    public TenantService(Config config) {
        this.tenant = new Tenant(config);
        this.tenantProductAssignInfo = new TenantProductAssignInfo(config);
    }

    public Tenant tenant() {
        return this.tenant;
    }

    public TenantProductAssignInfo tenantProductAssignInfo() {
        return this.tenantProductAssignInfo;
    }

    public static class Tenant {
        private final Config config;

        public Tenant(Config config) {
            this.config = config;
        }

        public QueryTenantResp query(RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            QueryTenantResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/tenant/v2/tenant/query", Sets.newHashSet(AccessTokenType.Tenant), null), QueryTenantResp.class)) == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/tenant/v2/tenant/query", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public QueryTenantResp query() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/tenant/v2/tenant/query", Sets.newHashSet(AccessTokenType.Tenant), null);
            QueryTenantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTenantResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/tenant/v2/tenant/query", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }

    public static class TenantProductAssignInfo {
        private final Config config;

        public TenantProductAssignInfo(Config config) {
            this.config = config;
        }

        public QueryTenantProductAssignInfoResp query(RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            QueryTenantProductAssignInfoResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/tenant/v2/tenant/assign_info_list/query", Sets.newHashSet(AccessTokenType.Tenant), null), QueryTenantProductAssignInfoResp.class)) == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/tenant/v2/tenant/assign_info_list/query", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public QueryTenantProductAssignInfoResp query() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/tenant/v2/tenant/assign_info_list/query", Sets.newHashSet(AccessTokenType.Tenant), null);
            QueryTenantProductAssignInfoResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTenantProductAssignInfoResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/tenant/v2/tenant/assign_info_list/query", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }
}

