// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;

public class DepartmentCreate {
    /**
     * 实体在CoreHR内部的唯一键
     * <p> 示例值：4719456877659520852
     */
    @SerializedName("id")
    private String id;
    /**
     * 子类型
     * <p> 示例值：
     */
    @SerializedName("sub_type")
    private Enum subType;
    /**
     * 部门负责人
     * <p> 示例值：6893013238632416776
     */
    @SerializedName("manager")
    private String manager;
    /**
     * 是否保密
     * <p> 示例值：true
     */
    @SerializedName("is_confidential")
    private Boolean isConfidential;
    /**
     * 层级关系，内层字段见实体
     * <p> 示例值：
     */
    @SerializedName("hiberarchy_common")
    private HiberarchyCommon hiberarchyCommon;
    /**
     * 生效时间
     * <p> 示例值：2020-05-01 00:00:00
     */
    @SerializedName("effective_time")
    private String effectiveTime;
    /**
     * 失效时间
     * <p> 示例值：2020-05-02 00:00:00
     */
    @SerializedName("expiration_time")
    private String expirationTime;
    /**
     * 自定义字段
     * <p> 示例值：
     */
    @SerializedName("custom_fields")
    private ObjectFieldData[] customFields;

    // builder 开始
    public DepartmentCreate() {
    }

    public DepartmentCreate(Builder builder) {
        /**
         * 实体在CoreHR内部的唯一键
         * <p> 示例值：4719456877659520852
         */
        this.id = builder.id;
        /**
         * 子类型
         * <p> 示例值：
         */
        this.subType = builder.subType;
        /**
         * 部门负责人
         * <p> 示例值：6893013238632416776
         */
        this.manager = builder.manager;
        /**
         * 是否保密
         * <p> 示例值：true
         */
        this.isConfidential = builder.isConfidential;
        /**
         * 层级关系，内层字段见实体
         * <p> 示例值：
         */
        this.hiberarchyCommon = builder.hiberarchyCommon;
        /**
         * 生效时间
         * <p> 示例值：2020-05-01 00:00:00
         */
        this.effectiveTime = builder.effectiveTime;
        /**
         * 失效时间
         * <p> 示例值：2020-05-02 00:00:00
         */
        this.expirationTime = builder.expirationTime;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        this.customFields = builder.customFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Enum getSubType() {
        return this.subType;
    }

    public void setSubType(Enum subType) {
        this.subType = subType;
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public Boolean getIsConfidential() {
        return this.isConfidential;
    }

    public void setIsConfidential(Boolean isConfidential) {
        this.isConfidential = isConfidential;
    }

    public HiberarchyCommon getHiberarchyCommon() {
        return this.hiberarchyCommon;
    }

    public void setHiberarchyCommon(HiberarchyCommon hiberarchyCommon) {
        this.hiberarchyCommon = hiberarchyCommon;
    }

    public String getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(String effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public ObjectFieldData[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(ObjectFieldData[] customFields) {
        this.customFields = customFields;
    }

    public static class Builder {
        /**
         * 实体在CoreHR内部的唯一键
         * <p> 示例值：4719456877659520852
         */
        private String id;
        /**
         * 子类型
         * <p> 示例值：
         */
        private Enum subType;
        /**
         * 部门负责人
         * <p> 示例值：6893013238632416776
         */
        private String manager;
        /**
         * 是否保密
         * <p> 示例值：true
         */
        private Boolean isConfidential;
        /**
         * 层级关系，内层字段见实体
         * <p> 示例值：
         */
        private HiberarchyCommon hiberarchyCommon;
        /**
         * 生效时间
         * <p> 示例值：2020-05-01 00:00:00
         */
        private String effectiveTime;
        /**
         * 失效时间
         * <p> 示例值：2020-05-02 00:00:00
         */
        private String expirationTime;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        private ObjectFieldData[] customFields;

        /**
         * 实体在CoreHR内部的唯一键
         * <p> 示例值：4719456877659520852
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 子类型
         * <p> 示例值：
         *
         * @param subType
         * @return
         */
        public Builder subType(Enum subType) {
            this.subType = subType;
            return this;
        }


        /**
         * 部门负责人
         * <p> 示例值：6893013238632416776
         *
         * @param manager
         * @return
         */
        public Builder manager(String manager) {
            this.manager = manager;
            return this;
        }


        /**
         * 是否保密
         * <p> 示例值：true
         *
         * @param isConfidential
         * @return
         */
        public Builder isConfidential(Boolean isConfidential) {
            this.isConfidential = isConfidential;
            return this;
        }


        /**
         * 层级关系，内层字段见实体
         * <p> 示例值：
         *
         * @param hiberarchyCommon
         * @return
         */
        public Builder hiberarchyCommon(HiberarchyCommon hiberarchyCommon) {
            this.hiberarchyCommon = hiberarchyCommon;
            return this;
        }


        /**
         * 生效时间
         * <p> 示例值：2020-05-01 00:00:00
         *
         * @param effectiveTime
         * @return
         */
        public Builder effectiveTime(String effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }


        /**
         * 失效时间
         * <p> 示例值：2020-05-02 00:00:00
         *
         * @param expirationTime
         * @return
         */
        public Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }


        /**
         * 自定义字段
         * <p> 示例值：
         *
         * @param customFields
         * @return
         */
        public Builder customFields(ObjectFieldData[] customFields) {
            this.customFields = customFields;
            return this;
        }


        public DepartmentCreate build() {
            return new DepartmentCreate(this);
        }
    }
}
