// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;

public class Dependent {
    /**
     * 亲属姓名
     * <p> 示例值：
     */
    @SerializedName("name")
    private PersonName name;
    /**
     * 亲属关系，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)亲属关系（relationship）枚举定义获得
     * <p> 示例值：
     */
    @SerializedName("relationship")
    private Enum relationship;
    /**
     * 亲属性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
     * <p> 示例值：
     */
    @SerializedName("gender")
    private Enum gender;
    /**
     * 生日
     * <p> 示例值：2020-01-01
     */
    @SerializedName("date_of_birth")
    private String dateOfBirth;
    /**
     * 国籍
     * <p> 示例值：123456
     */
    @SerializedName("nationality_id")
    private String nationalityId;
    /**
     * 证件号码
     * <p> 示例值：
     */
    @SerializedName("national_id_list")
    private NationalId[] nationalIdList;
    /**
     * 配偶工作状态，比如working（在岗）、not_working（不在岗）
     * <p> 示例值：
     */
    @SerializedName("spouses_working_status")
    private Enum spousesWorkingStatus;
    /**
     * 包含家属医疗保险
     * <p> 示例值：true
     */
    @SerializedName("is_this_person_covered_by_health_insurance")
    private Boolean isThisPersonCoveredByHealthInsurance;
    /**
     * 允许家属抵扣税款
     * <p> 示例值：false
     */
    @SerializedName("is_this_person_allowed_for_tax_deduction")
    private Boolean isThisPersonAllowedForTaxDeduction;
    /**
     * 自定义字段
     * <p> 示例值：
     */
    @SerializedName("custom_fields")
    private ObjectFieldData[] customFields;

    // builder 开始
    public Dependent() {
    }

    public Dependent(Builder builder) {
        /**
         * 亲属姓名
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 亲属关系，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)亲属关系（relationship）枚举定义获得
         * <p> 示例值：
         */
        this.relationship = builder.relationship;
        /**
         * 亲属性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
         * <p> 示例值：
         */
        this.gender = builder.gender;
        /**
         * 生日
         * <p> 示例值：2020-01-01
         */
        this.dateOfBirth = builder.dateOfBirth;
        /**
         * 国籍
         * <p> 示例值：123456
         */
        this.nationalityId = builder.nationalityId;
        /**
         * 证件号码
         * <p> 示例值：
         */
        this.nationalIdList = builder.nationalIdList;
        /**
         * 配偶工作状态，比如working（在岗）、not_working（不在岗）
         * <p> 示例值：
         */
        this.spousesWorkingStatus = builder.spousesWorkingStatus;
        /**
         * 包含家属医疗保险
         * <p> 示例值：true
         */
        this.isThisPersonCoveredByHealthInsurance = builder.isThisPersonCoveredByHealthInsurance;
        /**
         * 允许家属抵扣税款
         * <p> 示例值：false
         */
        this.isThisPersonAllowedForTaxDeduction = builder.isThisPersonAllowedForTaxDeduction;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        this.customFields = builder.customFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public PersonName getName() {
        return this.name;
    }

    public void setName(PersonName name) {
        this.name = name;
    }

    public Enum getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Enum relationship) {
        this.relationship = relationship;
    }

    public Enum getGender() {
        return this.gender;
    }

    public void setGender(Enum gender) {
        this.gender = gender;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getNationalityId() {
        return this.nationalityId;
    }

    public void setNationalityId(String nationalityId) {
        this.nationalityId = nationalityId;
    }

    public NationalId[] getNationalIdList() {
        return this.nationalIdList;
    }

    public void setNationalIdList(NationalId[] nationalIdList) {
        this.nationalIdList = nationalIdList;
    }

    public Enum getSpousesWorkingStatus() {
        return this.spousesWorkingStatus;
    }

    public void setSpousesWorkingStatus(Enum spousesWorkingStatus) {
        this.spousesWorkingStatus = spousesWorkingStatus;
    }

    public Boolean getIsThisPersonCoveredByHealthInsurance() {
        return this.isThisPersonCoveredByHealthInsurance;
    }

    public void setIsThisPersonCoveredByHealthInsurance(Boolean isThisPersonCoveredByHealthInsurance) {
        this.isThisPersonCoveredByHealthInsurance = isThisPersonCoveredByHealthInsurance;
    }

    public Boolean getIsThisPersonAllowedForTaxDeduction() {
        return this.isThisPersonAllowedForTaxDeduction;
    }

    public void setIsThisPersonAllowedForTaxDeduction(Boolean isThisPersonAllowedForTaxDeduction) {
        this.isThisPersonAllowedForTaxDeduction = isThisPersonAllowedForTaxDeduction;
    }

    public ObjectFieldData[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(ObjectFieldData[] customFields) {
        this.customFields = customFields;
    }

    public static class Builder {
        /**
         * 亲属姓名
         * <p> 示例值：
         */
        private PersonName name;
        /**
         * 亲属关系，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)亲属关系（relationship）枚举定义获得
         * <p> 示例值：
         */
        private Enum relationship;
        /**
         * 亲属性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
         * <p> 示例值：
         */
        private Enum gender;
        /**
         * 生日
         * <p> 示例值：2020-01-01
         */
        private String dateOfBirth;
        /**
         * 国籍
         * <p> 示例值：123456
         */
        private String nationalityId;
        /**
         * 证件号码
         * <p> 示例值：
         */
        private NationalId[] nationalIdList;
        /**
         * 配偶工作状态，比如working（在岗）、not_working（不在岗）
         * <p> 示例值：
         */
        private Enum spousesWorkingStatus;
        /**
         * 包含家属医疗保险
         * <p> 示例值：true
         */
        private Boolean isThisPersonCoveredByHealthInsurance;
        /**
         * 允许家属抵扣税款
         * <p> 示例值：false
         */
        private Boolean isThisPersonAllowedForTaxDeduction;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        private ObjectFieldData[] customFields;

        /**
         * 亲属姓名
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(PersonName name) {
            this.name = name;
            return this;
        }


        /**
         * 亲属关系，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)亲属关系（relationship）枚举定义获得
         * <p> 示例值：
         *
         * @param relationship
         * @return
         */
        public Builder relationship(Enum relationship) {
            this.relationship = relationship;
            return this;
        }


        /**
         * 亲属性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
         * <p> 示例值：
         *
         * @param gender
         * @return
         */
        public Builder gender(Enum gender) {
            this.gender = gender;
            return this;
        }


        /**
         * 生日
         * <p> 示例值：2020-01-01
         *
         * @param dateOfBirth
         * @return
         */
        public Builder dateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }


        /**
         * 国籍
         * <p> 示例值：123456
         *
         * @param nationalityId
         * @return
         */
        public Builder nationalityId(String nationalityId) {
            this.nationalityId = nationalityId;
            return this;
        }


        /**
         * 证件号码
         * <p> 示例值：
         *
         * @param nationalIdList
         * @return
         */
        public Builder nationalIdList(NationalId[] nationalIdList) {
            this.nationalIdList = nationalIdList;
            return this;
        }


        /**
         * 配偶工作状态，比如working（在岗）、not_working（不在岗）
         * <p> 示例值：
         *
         * @param spousesWorkingStatus
         * @return
         */
        public Builder spousesWorkingStatus(Enum spousesWorkingStatus) {
            this.spousesWorkingStatus = spousesWorkingStatus;
            return this;
        }


        /**
         * 包含家属医疗保险
         * <p> 示例值：true
         *
         * @param isThisPersonCoveredByHealthInsurance
         * @return
         */
        public Builder isThisPersonCoveredByHealthInsurance(Boolean isThisPersonCoveredByHealthInsurance) {
            this.isThisPersonCoveredByHealthInsurance = isThisPersonCoveredByHealthInsurance;
            return this;
        }


        /**
         * 允许家属抵扣税款
         * <p> 示例值：false
         *
         * @param isThisPersonAllowedForTaxDeduction
         * @return
         */
        public Builder isThisPersonAllowedForTaxDeduction(Boolean isThisPersonAllowedForTaxDeduction) {
            this.isThisPersonAllowedForTaxDeduction = isThisPersonAllowedForTaxDeduction;
            return this;
        }


        /**
         * 自定义字段
         * <p> 示例值：
         *
         * @param customFields
         * @return
         */
        public Builder customFields(ObjectFieldData[] customFields) {
            this.customFields = customFields;
            return this;
        }


        public Dependent build() {
            return new Dependent(this);
        }
    }
}
