// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.speech_to_text.v1.model;

import com.google.gson.annotations.SerializedName;

public class FileConfig {
    /**
     * 仅包含字母数字和下划线的 16 位字符串作为文件的标识，用户生成
     * <p> 示例值：qwe12dd34567890w
     */
    @SerializedName("file_id")
    private String fileId;
    /**
     * 语音格式，目前仅支持：pcm
     * <p> 示例值：pcm
     */
    @SerializedName("format")
    private String format;
    /**
     * 引擎类型，目前仅支持：16k_auto 中英混合
     * <p> 示例值：16k_auto
     */
    @SerializedName("engine_type")
    private String engineType;

    // builder 开始
    public FileConfig() {
    }

    public FileConfig(Builder builder) {
        /**
         * 仅包含字母数字和下划线的 16 位字符串作为文件的标识，用户生成
         * <p> 示例值：qwe12dd34567890w
         */
        this.fileId = builder.fileId;
        /**
         * 语音格式，目前仅支持：pcm
         * <p> 示例值：pcm
         */
        this.format = builder.format;
        /**
         * 引擎类型，目前仅支持：16k_auto 中英混合
         * <p> 示例值：16k_auto
         */
        this.engineType = builder.engineType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public static class Builder {
        /**
         * 仅包含字母数字和下划线的 16 位字符串作为文件的标识，用户生成
         * <p> 示例值：qwe12dd34567890w
         */
        private String fileId;
        /**
         * 语音格式，目前仅支持：pcm
         * <p> 示例值：pcm
         */
        private String format;
        /**
         * 引擎类型，目前仅支持：16k_auto 中英混合
         * <p> 示例值：16k_auto
         */
        private String engineType;

        /**
         * 仅包含字母数字和下划线的 16 位字符串作为文件的标识，用户生成
         * <p> 示例值：qwe12dd34567890w
         *
         * @param fileId
         * @return
         */
        public Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }


        /**
         * 语音格式，目前仅支持：pcm
         * <p> 示例值：pcm
         *
         * @param format
         * @return
         */
        public Builder format(String format) {
            this.format = format;
            return this;
        }


        /**
         * 引擎类型，目前仅支持：16k_auto 中英混合
         * <p> 示例值：16k_auto
         *
         * @param engineType
         * @return
         */
        public Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }


        public FileConfig build() {
            return new FileConfig(this);
        }
    }
}
