// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;

public class ParticipantQuality {
    /**
     * 网络
     * <p> 示例值：
     */
    @SerializedName("network")
    private QualityNetwork network;
    /**
     * 音频
     * <p> 示例值：
     */
    @SerializedName("audio")
    private QualityAudio audio;
    /**
     * 视频
     * <p> 示例值：
     */
    @SerializedName("video")
    private QualityVideoSharing video;
    /**
     * 共享屏幕
     * <p> 示例值：
     */
    @SerializedName("screen_sharing")
    private QualityVideoSharing screenSharing;
    /**
     * Cpu使用量
     * <p> 示例值：
     */
    @SerializedName("cpu_usage")
    private QualityCpuUsage cpuUsage;

    // builder 开始
    public ParticipantQuality() {
    }

    public ParticipantQuality(Builder builder) {
        /**
         * 网络
         * <p> 示例值：
         */
        this.network = builder.network;
        /**
         * 音频
         * <p> 示例值：
         */
        this.audio = builder.audio;
        /**
         * 视频
         * <p> 示例值：
         */
        this.video = builder.video;
        /**
         * 共享屏幕
         * <p> 示例值：
         */
        this.screenSharing = builder.screenSharing;
        /**
         * Cpu使用量
         * <p> 示例值：
         */
        this.cpuUsage = builder.cpuUsage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public QualityNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(QualityNetwork network) {
        this.network = network;
    }

    public QualityAudio getAudio() {
        return this.audio;
    }

    public void setAudio(QualityAudio audio) {
        this.audio = audio;
    }

    public QualityVideoSharing getVideo() {
        return this.video;
    }

    public void setVideo(QualityVideoSharing video) {
        this.video = video;
    }

    public QualityVideoSharing getScreenSharing() {
        return this.screenSharing;
    }

    public void setScreenSharing(QualityVideoSharing screenSharing) {
        this.screenSharing = screenSharing;
    }

    public QualityCpuUsage getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(QualityCpuUsage cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public static class Builder {
        /**
         * 网络
         * <p> 示例值：
         */
        private QualityNetwork network;
        /**
         * 音频
         * <p> 示例值：
         */
        private QualityAudio audio;
        /**
         * 视频
         * <p> 示例值：
         */
        private QualityVideoSharing video;
        /**
         * 共享屏幕
         * <p> 示例值：
         */
        private QualityVideoSharing screenSharing;
        /**
         * Cpu使用量
         * <p> 示例值：
         */
        private QualityCpuUsage cpuUsage;

        /**
         * 网络
         * <p> 示例值：
         *
         * @param network
         * @return
         */
        public Builder network(QualityNetwork network) {
            this.network = network;
            return this;
        }


        /**
         * 音频
         * <p> 示例值：
         *
         * @param audio
         * @return
         */
        public Builder audio(QualityAudio audio) {
            this.audio = audio;
            return this;
        }


        /**
         * 视频
         * <p> 示例值：
         *
         * @param video
         * @return
         */
        public Builder video(QualityVideoSharing video) {
            this.video = video;
            return this;
        }


        /**
         * 共享屏幕
         * <p> 示例值：
         *
         * @param screenSharing
         * @return
         */
        public Builder screenSharing(QualityVideoSharing screenSharing) {
            this.screenSharing = screenSharing;
            return this;
        }


        /**
         * Cpu使用量
         * <p> 示例值：
         *
         * @param cpuUsage
         * @return
         */
        public Builder cpuUsage(QualityCpuUsage cpuUsage) {
            this.cpuUsage = cpuUsage;
            return this;
        }


        public ParticipantQuality build() {
            return new ParticipantQuality(this);
        }
    }
}
