// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.google.gson.annotations.SerializedName;

public class UserTaskRemedy {

  /**
   * 用户 ID
   * <p> 示例值：abd754f7
   */
  @SerializedName("user_id")
  private String userId;
  /**
   * 补卡日期
   * <p> 示例值：20210701
   */
  @SerializedName("remedy_date")
  private Integer remedyDate;
  /**
   * 第几次上下班，0：第 1 次上下班，1：第 2 次上下班，2：第 3 次上下班，自由班制填 0
   * <p> 示例值：0
   */
  @SerializedName("punch_no")
  private Integer punchNo;
  /**
   * 上班 / 下班，1：上班，2：下班，自由班制填 0
   * <p> 示例值：1
   */
  @SerializedName("work_type")
  private Integer workType;
  /**
   * 审批 ID
   * <p> 示例值：6737202939523236113
   */
  @SerializedName("approval_id")
  private String approvalId;
  /**
   * 补卡时间，时间格式为 yyyy-MM-dd HH:mm
   * <p> 示例值：2021-07-01 08:00
   */
  @SerializedName("remedy_time")
  private String remedyTime;
  /**
   * 补卡状态（默认为审批中）
   * <p> 示例值：2
   */
  @SerializedName("status")
  private Integer status;
  /**
   * 补卡原因
   * <p> 示例值：忘记打卡
   */
  @SerializedName("reason")
  private String reason;
  /**
   * 补卡时间，精确到秒的时间戳
   * <p> 示例值：1611476284
   */
  @SerializedName("time")
  private String time;
  /**
   * 补卡时考勤组时区
   * <p> 示例值：Asia/Shanghai
   */
  @SerializedName("time_zone")
  private String timeZone;
  /**
   * 补卡发起时间，精确到秒的时间戳
   * <p> 示例值：1611476284
   */
  @SerializedName("create_time")
  private String createTime;
  /**
   * 补卡状态更新时间，精确到秒的时间戳
   * <p> 示例值：1611476284
   */
  @SerializedName("update_time")
  private String updateTime;

  // builder 开始
  public UserTaskRemedy() {
  }

  public UserTaskRemedy(Builder builder) {
    /**
     * 用户 ID
     * <p> 示例值：abd754f7
     */
    this.userId = builder.userId;
    /**
     * 补卡日期
     * <p> 示例值：20210701
     */
    this.remedyDate = builder.remedyDate;
    /**
     * 第几次上下班，0：第 1 次上下班，1：第 2 次上下班，2：第 3 次上下班，自由班制填 0
     * <p> 示例值：0
     */
    this.punchNo = builder.punchNo;
    /**
     * 上班 / 下班，1：上班，2：下班，自由班制填 0
     * <p> 示例值：1
     */
    this.workType = builder.workType;
    /**
     * 审批 ID
     * <p> 示例值：6737202939523236113
     */
    this.approvalId = builder.approvalId;
    /**
     * 补卡时间，时间格式为 yyyy-MM-dd HH:mm
     * <p> 示例值：2021-07-01 08:00
     */
    this.remedyTime = builder.remedyTime;
    /**
     * 补卡状态（默认为审批中）
     * <p> 示例值：2
     */
    this.status = builder.status;
    /**
     * 补卡原因
     * <p> 示例值：忘记打卡
     */
    this.reason = builder.reason;
    /**
     * 补卡时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     */
    this.time = builder.time;
    /**
     * 补卡时考勤组时区
     * <p> 示例值：Asia/Shanghai
     */
    this.timeZone = builder.timeZone;
    /**
     * 补卡发起时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     */
    this.createTime = builder.createTime;
    /**
     * 补卡状态更新时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     */
    this.updateTime = builder.updateTime;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getUserId() {
    return this.userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public Integer getRemedyDate() {
    return this.remedyDate;
  }

  public void setRemedyDate(Integer remedyDate) {
    this.remedyDate = remedyDate;
  }

  public Integer getPunchNo() {
    return this.punchNo;
  }

  public void setPunchNo(Integer punchNo) {
    this.punchNo = punchNo;
  }

  public Integer getWorkType() {
    return this.workType;
  }

  public void setWorkType(Integer workType) {
    this.workType = workType;
  }

  public String getApprovalId() {
    return this.approvalId;
  }

  public void setApprovalId(String approvalId) {
    this.approvalId = approvalId;
  }

  public String getRemedyTime() {
    return this.remedyTime;
  }

  public void setRemedyTime(String remedyTime) {
    this.remedyTime = remedyTime;
  }

  public Integer getStatus() {
    return this.status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getReason() {
    return this.reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public String getTime() {
    return this.time;
  }

  public void setTime(String time) {
    this.time = time;
  }

  public String getTimeZone() {
    return this.timeZone;
  }

  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }

  public String getCreateTime() {
    return this.createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public String getUpdateTime() {
    return this.updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public static class Builder {

    /**
     * 用户 ID
     * <p> 示例值：abd754f7
     */
    private String userId;
    /**
     * 补卡日期
     * <p> 示例值：20210701
     */
    private Integer remedyDate;
    /**
     * 第几次上下班，0：第 1 次上下班，1：第 2 次上下班，2：第 3 次上下班，自由班制填 0
     * <p> 示例值：0
     */
    private Integer punchNo;
    /**
     * 上班 / 下班，1：上班，2：下班，自由班制填 0
     * <p> 示例值：1
     */
    private Integer workType;
    /**
     * 审批 ID
     * <p> 示例值：6737202939523236113
     */
    private String approvalId;
    /**
     * 补卡时间，时间格式为 yyyy-MM-dd HH:mm
     * <p> 示例值：2021-07-01 08:00
     */
    private String remedyTime;
    /**
     * 补卡状态（默认为审批中）
     * <p> 示例值：2
     */
    private Integer status;
    /**
     * 补卡原因
     * <p> 示例值：忘记打卡
     */
    private String reason;
    /**
     * 补卡时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     */
    private String time;
    /**
     * 补卡时考勤组时区
     * <p> 示例值：Asia/Shanghai
     */
    private String timeZone;
    /**
     * 补卡发起时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     */
    private String createTime;
    /**
     * 补卡状态更新时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     */
    private String updateTime;

    /**
     * 用户 ID
     * <p> 示例值：abd754f7
     *
     * @param userId
     * @return
     */
    public Builder userId(String userId) {
      this.userId = userId;
      return this;
    }


    /**
     * 补卡日期
     * <p> 示例值：20210701
     *
     * @param remedyDate
     * @return
     */
    public Builder remedyDate(Integer remedyDate) {
      this.remedyDate = remedyDate;
      return this;
    }


    /**
     * 第几次上下班，0：第 1 次上下班，1：第 2 次上下班，2：第 3 次上下班，自由班制填 0
     * <p> 示例值：0
     *
     * @param punchNo
     * @return
     */
    public Builder punchNo(Integer punchNo) {
      this.punchNo = punchNo;
      return this;
    }


    /**
     * 上班 / 下班，1：上班，2：下班，自由班制填 0
     * <p> 示例值：1
     *
     * @param workType
     * @return
     */
    public Builder workType(Integer workType) {
      this.workType = workType;
      return this;
    }


    /**
     * 审批 ID
     * <p> 示例值：6737202939523236113
     *
     * @param approvalId
     * @return
     */
    public Builder approvalId(String approvalId) {
      this.approvalId = approvalId;
      return this;
    }


    /**
     * 补卡时间，时间格式为 yyyy-MM-dd HH:mm
     * <p> 示例值：2021-07-01 08:00
     *
     * @param remedyTime
     * @return
     */
    public Builder remedyTime(String remedyTime) {
      this.remedyTime = remedyTime;
      return this;
    }


    /**
     * 补卡状态（默认为审批中）
     * <p> 示例值：2
     *
     * @param status
     * @return
     */
    public Builder status(Integer status) {
      this.status = status;
      return this;
    }

    /**
     * 补卡状态（默认为审批中）
     * <p> 示例值：2
     *
     * @param status {@link com.lark.oapi.service.attendance.v1.enums.UserTaskRemedyStatusEnum}
     * @return
     */
    public Builder status(
        com.lark.oapi.service.attendance.v1.enums.UserTaskRemedyStatusEnum status) {
      this.status = status.getValue();
      return this;
    }


    /**
     * 补卡原因
     * <p> 示例值：忘记打卡
     *
     * @param reason
     * @return
     */
    public Builder reason(String reason) {
      this.reason = reason;
      return this;
    }


    /**
     * 补卡时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     *
     * @param time
     * @return
     */
    public Builder time(String time) {
      this.time = time;
      return this;
    }


    /**
     * 补卡时考勤组时区
     * <p> 示例值：Asia/Shanghai
     *
     * @param timeZone
     * @return
     */
    public Builder timeZone(String timeZone) {
      this.timeZone = timeZone;
      return this;
    }


    /**
     * 补卡发起时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     *
     * @param createTime
     * @return
     */
    public Builder createTime(String createTime) {
      this.createTime = createTime;
      return this;
    }


    /**
     * 补卡状态更新时间，精确到秒的时间戳
     * <p> 示例值：1611476284
     *
     * @param updateTime
     * @return
     */
    public Builder updateTime(String updateTime) {
      this.updateTime = updateTime;
      return this;
    }


    public UserTaskRemedy build() {
      return new UserTaskRemedy(this);
    }
  }
}
