// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.calendar.v4.model;

import com.google.gson.annotations.SerializedName;

public class ListFreebusyReqBody {

  /**
   * 查询时段开始时间，需要url编码
   * <p> 示例值：2020-10-28T12:00:00+08:00
   */
  @SerializedName("time_min")
  private String timeMin;
  /**
   * 查询时段结束时间，需要url编码
   * <p> 示例值：2020-12-28T12:00:00+08:00
   */
  @SerializedName("time_max")
  private String timeMax;
  /**
   * 用户user_id，输入时与 room_id 二选一。参见[用户相关的 ID 概念](https://open.feishu.cn/document/home/user-identity-introduction/introduction)
   * <p> 示例值：ou_xxxxxxxxxx
   */
  @SerializedName("user_id")
  private String userId;
  /**
   * 会议室room_id，输入时与 user_id 二选一
   * <p> 示例值：omm_xxxxxxxxxx
   */
  @SerializedName("room_id")
  private String roomId;

  // builder 开始
  public ListFreebusyReqBody() {
  }

  public ListFreebusyReqBody(Builder builder) {
    /**
     * 查询时段开始时间，需要url编码
     * <p> 示例值：2020-10-28T12:00:00+08:00
     */
    this.timeMin = builder.timeMin;
    /**
     * 查询时段结束时间，需要url编码
     * <p> 示例值：2020-12-28T12:00:00+08:00
     */
    this.timeMax = builder.timeMax;
    /**
     * 用户user_id，输入时与 room_id 二选一。参见[用户相关的 ID 概念](https://open.feishu.cn/document/home/user-identity-introduction/introduction)
     * <p> 示例值：ou_xxxxxxxxxx
     */
    this.userId = builder.userId;
    /**
     * 会议室room_id，输入时与 user_id 二选一
     * <p> 示例值：omm_xxxxxxxxxx
     */
    this.roomId = builder.roomId;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getTimeMin() {
    return this.timeMin;
  }

  public void setTimeMin(String timeMin) {
    this.timeMin = timeMin;
  }

  public String getTimeMax() {
    return this.timeMax;
  }

  public void setTimeMax(String timeMax) {
    this.timeMax = timeMax;
  }

  public String getUserId() {
    return this.userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getRoomId() {
    return this.roomId;
  }

  public void setRoomId(String roomId) {
    this.roomId = roomId;
  }

  public static class Builder {

    /**
     * 查询时段开始时间，需要url编码
     * <p> 示例值：2020-10-28T12:00:00+08:00
     */
    private String timeMin;
    /**
     * 查询时段结束时间，需要url编码
     * <p> 示例值：2020-12-28T12:00:00+08:00
     */
    private String timeMax;
    /**
     * 用户user_id，输入时与 room_id 二选一。参见[用户相关的 ID 概念](https://open.feishu.cn/document/home/user-identity-introduction/introduction)
     * <p> 示例值：ou_xxxxxxxxxx
     */
    private String userId;
    /**
     * 会议室room_id，输入时与 user_id 二选一
     * <p> 示例值：omm_xxxxxxxxxx
     */
    private String roomId;

    /**
     * 查询时段开始时间，需要url编码
     * <p> 示例值：2020-10-28T12:00:00+08:00
     *
     * @param timeMin
     * @return
     */
    public Builder timeMin(String timeMin) {
      this.timeMin = timeMin;
      return this;
    }


    /**
     * 查询时段结束时间，需要url编码
     * <p> 示例值：2020-12-28T12:00:00+08:00
     *
     * @param timeMax
     * @return
     */
    public Builder timeMax(String timeMax) {
      this.timeMax = timeMax;
      return this;
    }


    /**
     * 用户user_id，输入时与 room_id 二选一。参见[用户相关的 ID 概念](https://open.feishu.cn/document/home/user-identity-introduction/introduction)
     * <p> 示例值：ou_xxxxxxxxxx
     *
     * @param userId
     * @return
     */
    public Builder userId(String userId) {
      this.userId = userId;
      return this;
    }


    /**
     * 会议室room_id，输入时与 user_id 二选一
     * <p> 示例值：omm_xxxxxxxxxx
     *
     * @param roomId
     * @return
     */
    public Builder roomId(String roomId) {
      this.roomId = roomId;
      return this;
    }


    public ListFreebusyReqBody build() {
      return new ListFreebusyReqBody(this);
    }
  }
}
