// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.contact.v3.model;

import com.google.gson.annotations.SerializedName;

public class ListScopeRespBody {

  /**
   * 已授权部门列表，授权范围为全员可见时返回的是当前企业的所有一级部门列表
   * <p> 示例值：od-8756c536552a91988b1b64559356c5a4
   */
  @SerializedName("department_ids")
  private String[] departmentIds;
  /**
   * 已授权用户列表，应用申请了获取用户user_id 权限时返回；当授权范围为全员可见时返回的是当前企业所有顶级部门用户列表
   * <p> 示例值：ou_5f3e2df282bf5aaeeaa2ea71ab9f1229
   */
  @SerializedName("user_ids")
  private String[] userIds;
  /**
   * 已授权的用户组，授权范围为全员可见时返回的是当前企业所有用户组
   * <p> 示例值：["g193821"]
   */
  @SerializedName("group_ids")
  private String[] groupIds;
  /**
   * 是否还有更多项
   * <p> 示例值：true
   */
  @SerializedName("has_more")
  private Boolean hasMore;
  /**
   * 分页标记，当 has_more 为 true 时，会同时返回新的 page_token
   * <p> 示例值：AQD9/Rn9eij9Pm39ED40/dk53s4Ebp882DYfFaPFbz00L4CMZJrqGdzNyc8BcZtDbwVUvRmQTvyMYicnGWrde9X56TgdBuS+JKiSIkdexPw=
   */
  @SerializedName("page_token")
  private String pageToken;

  public String[] getDepartmentIds() {
    return this.departmentIds;
  }

  public void setDepartmentIds(String[] departmentIds) {
    this.departmentIds = departmentIds;
  }

  public String[] getUserIds() {
    return this.userIds;
  }

  public void setUserIds(String[] userIds) {
    this.userIds = userIds;
  }

  public String[] getGroupIds() {
    return this.groupIds;
  }

  public void setGroupIds(String[] groupIds) {
    this.groupIds = groupIds;
  }

  public Boolean getHasMore() {
    return this.hasMore;
  }

  public void setHasMore(Boolean hasMore) {
    this.hasMore = hasMore;
  }

  public String getPageToken() {
    return this.pageToken;
  }

  public void setPageToken(String pageToken) {
    this.pageToken = pageToken;
  }

}
