// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.drive.v1.model;

import com.google.gson.annotations.SerializedName;

public class FileStatistics {

  /**
   * 文件历史访问人数，同一用户（user_id）多次访问按一次计算。
   * <p> 示例值：10
   */
  @SerializedName("uv")
  private Integer uv;
  /**
   * 文件历史访问次数，同一用户（user_id）多次访问按多次计算。（注：同一用户相邻两次访问间隔在半小时内视为一次访问）
   * <p> 示例值：15
   */
  @SerializedName("pv")
  private Integer pv;
  /**
   * 文件历史点赞总数，若对应的文档类型不支持点赞，返回 -1
   * <p> 示例值：2
   */
  @SerializedName("like_count")
  private Integer likeCount;
  /**
   * 时间戳（秒）
   * <p> 示例值：1627367349
   */
  @SerializedName("timestamp")
  private Integer timestamp;

  // builder 开始
  public FileStatistics() {
  }

  public FileStatistics(Builder builder) {
    /**
     * 文件历史访问人数，同一用户（user_id）多次访问按一次计算。
     * <p> 示例值：10
     */
    this.uv = builder.uv;
    /**
     * 文件历史访问次数，同一用户（user_id）多次访问按多次计算。（注：同一用户相邻两次访问间隔在半小时内视为一次访问）
     * <p> 示例值：15
     */
    this.pv = builder.pv;
    /**
     * 文件历史点赞总数，若对应的文档类型不支持点赞，返回 -1
     * <p> 示例值：2
     */
    this.likeCount = builder.likeCount;
    /**
     * 时间戳（秒）
     * <p> 示例值：1627367349
     */
    this.timestamp = builder.timestamp;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Integer getUv() {
    return this.uv;
  }

  public void setUv(Integer uv) {
    this.uv = uv;
  }

  public Integer getPv() {
    return this.pv;
  }

  public void setPv(Integer pv) {
    this.pv = pv;
  }

  public Integer getLikeCount() {
    return this.likeCount;
  }

  public void setLikeCount(Integer likeCount) {
    this.likeCount = likeCount;
  }

  public Integer getTimestamp() {
    return this.timestamp;
  }

  public void setTimestamp(Integer timestamp) {
    this.timestamp = timestamp;
  }

  public static class Builder {

    /**
     * 文件历史访问人数，同一用户（user_id）多次访问按一次计算。
     * <p> 示例值：10
     */
    private Integer uv;
    /**
     * 文件历史访问次数，同一用户（user_id）多次访问按多次计算。（注：同一用户相邻两次访问间隔在半小时内视为一次访问）
     * <p> 示例值：15
     */
    private Integer pv;
    /**
     * 文件历史点赞总数，若对应的文档类型不支持点赞，返回 -1
     * <p> 示例值：2
     */
    private Integer likeCount;
    /**
     * 时间戳（秒）
     * <p> 示例值：1627367349
     */
    private Integer timestamp;

    /**
     * 文件历史访问人数，同一用户（user_id）多次访问按一次计算。
     * <p> 示例值：10
     *
     * @param uv
     * @return
     */
    public Builder uv(Integer uv) {
      this.uv = uv;
      return this;
    }


    /**
     * 文件历史访问次数，同一用户（user_id）多次访问按多次计算。（注：同一用户相邻两次访问间隔在半小时内视为一次访问）
     * <p> 示例值：15
     *
     * @param pv
     * @return
     */
    public Builder pv(Integer pv) {
      this.pv = pv;
      return this;
    }


    /**
     * 文件历史点赞总数，若对应的文档类型不支持点赞，返回 -1
     * <p> 示例值：2
     *
     * @param likeCount
     * @return
     */
    public Builder likeCount(Integer likeCount) {
      this.likeCount = likeCount;
      return this;
    }


    /**
     * 时间戳（秒）
     * <p> 示例值：1627367349
     *
     * @param timestamp
     * @return
     */
    public Builder timestamp(Integer timestamp) {
      this.timestamp = timestamp;
      return this;
    }


    public FileStatistics build() {
      return new FileStatistics(this);
    }
  }
}
